/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.sources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.IResourceSource;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.api.IHardcodedSourceRegistry;
import org.complexityanalyzer.config.ComplexityConfig;

public class HardcodedSourcesProvider
implements IResourceSource,
IHardcodedSourceRegistry {
    private static final int NORMAL_PRIORITY = 35;
    private static final int OVERRIDE_PRIORITY = 1000;
    private final Map<Item, SourceRule> normalSources = new ConcurrentHashMap<Item, SourceRule>();
    private final Map<Item, SourceRule> overrideSources = new ConcurrentHashMap<Item, SourceRule>();
    private static HardcodedSourcesProvider INSTANCE;

    public HardcodedSourcesProvider() {
        INSTANCE = this;
    }

    public static IHardcodedSourceRegistry getRegistry() {
        if (INSTANCE == null) {
            throw new IllegalStateException("HardcodedSourcesProvider not initialized yet!");
        }
        return INSTANCE;
    }

    @Override
    public void initialize(Level level) {
        ComplexityAnalyzer.LOGGER.info("[{}] Initializing hardcoded sources...", (Object)this.getName());
        this.registerVanillaSources();
        ComplexityAnalyzer.LOGGER.info("[{}] Registered {} normal + {} override sources", new Object[]{this.getName(), this.normalSources.size(), this.overrideSources.size()});
    }

    @Override
    public void registerTransformation(Item result, Item input, Map<Item, Double> toolWear, double baseCost, String description) {
        HashMap<Item, Double> ingredients = new HashMap<Item, Double>();
        ingredients.put(input, 1.0);
        if (toolWear != null) {
            ingredients.putAll(toolWear);
        }
        String modId = this.getCallingModId();
        this.normalSources.put(result, new SourceRule(ingredients, baseCost, BaseResourceData.ResourceSourceType.BLOCK_TRANSFORMATION, description, modId));
    }

    @Override
    public void registerComplexSource(Item result, Map<Item, Double> ingredients, double baseCost, BaseResourceData.ResourceSourceType type, String description) {
        String modId = this.getCallingModId();
        this.normalSources.put(result, new SourceRule(new HashMap<Item, Double>(ingredients), baseCost, type, description, modId));
    }

    @Override
    public void registerOverride(Item result, Map<Item, Double> ingredients, double baseCost, String description) {
        String modId = this.getCallingModId();
        this.overrideSources.put(result, new SourceRule(new HashMap<Item, Double>(ingredients), baseCost, BaseResourceData.ResourceSourceType.CRAFTING, "[OVERRIDE by " + modId + "] " + description, modId));
        ComplexityAnalyzer.LOGGER.warn("[{}] Mod {} OVERRIDING analysis for {}: {}", new Object[]{this.getName(), modId, result, description});
    }

    @Override
    public void registerUnobtainable(Item item, String reason) {
        String modId = this.getCallingModId();
        this.overrideSources.put(item, new SourceRule(Collections.emptyMap(), Double.POSITIVE_INFINITY, BaseResourceData.ResourceSourceType.UNOBTAINABLE, "[UNOBTAINABLE by " + modId + "] " + reason, modId));
        ComplexityAnalyzer.LOGGER.info("[{}] Mod {} marked {} as unobtainable: {}", new Object[]{this.getName(), modId, item, reason});
    }

    @Override
    public boolean isRegistered(Item item) {
        return this.normalSources.containsKey(item) || this.overrideSources.containsKey(item);
    }

    @Override
    public boolean canProvide(Item item) {
        return this.normalSources.containsKey(item) || this.overrideSources.containsKey(item);
    }

    @Override
    public Optional<BaseResourceData> analyze(Item item) {
        boolean isOverride;
        SourceRule rule = this.overrideSources.get(item);
        boolean bl = isOverride = rule != null;
        if (rule == null) {
            rule = this.normalSources.get(item);
        }
        if (rule == null) {
            return Optional.empty();
        }
        BaseResourceData.Builder builder = new BaseResourceData.Builder(item, this).sourceType(rule.type).baseFactor(rule.baseCost).details(rule.description).sourceItems(rule.ingredients);
        if (isOverride) {
            builder.addMetadata("override", "true");
            builder.addMetadata("override_by", rule.modId);
        }
        return Optional.of(builder.build());
    }

    @Override
    public int getPriority() {
        return this.overrideSources.isEmpty() ? 35 : 1000;
    }

    @Override
    public String getName() {
        return "HardcodedSources";
    }

    @Override
    public BaseResourceData.ResourceSourceType getSourceType() {
        return BaseResourceData.ResourceSourceType.SPECIAL_ACTION;
    }

    private String getCallingModId() {
        StackTraceElement[] stack;
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String[] parts;
            String className = element.getClassName();
            if (className.startsWith("org.complexityanalyzer") || className.startsWith("java.") || className.startsWith("net.minecraft") || (parts = className.split("\\.")).length <= 0) continue;
            return parts[0];
        }
        return "minecraft";
    }

    private void registerVanillaSources() {
        ComplexityAnalyzer.LOGGER.debug("[{}] Registering vanilla sources via API...", (Object)this.getName());
        this.registerWorldInteractions();
        this.registerBucketInteractions();
        this.registerSpecialLoot();
        this.registerSpecialCrafts();
        this.registerDragonItems();
    }

    private void registerWorldInteractions() {
        this.registerDeadCoral(Items.TUBE_CORAL_BLOCK, Items.DEAD_TUBE_CORAL_BLOCK);
        this.registerDeadCoral(Items.BRAIN_CORAL_BLOCK, Items.DEAD_BRAIN_CORAL_BLOCK);
        this.registerDeadCoral(Items.BUBBLE_CORAL_BLOCK, Items.DEAD_BUBBLE_CORAL_BLOCK);
        this.registerDeadCoral(Items.FIRE_CORAL_BLOCK, Items.DEAD_FIRE_CORAL_BLOCK);
        this.registerDeadCoral(Items.HORN_CORAL_BLOCK, Items.DEAD_HORN_CORAL_BLOCK);
        this.registerDeadCoral(Items.TUBE_CORAL, Items.DEAD_TUBE_CORAL);
        this.registerDeadCoral(Items.BRAIN_CORAL, Items.DEAD_BRAIN_CORAL);
        this.registerDeadCoral(Items.BUBBLE_CORAL, Items.DEAD_BUBBLE_CORAL);
        this.registerDeadCoral(Items.FIRE_CORAL, Items.DEAD_FIRE_CORAL);
        this.registerDeadCoral(Items.HORN_CORAL, Items.DEAD_HORN_CORAL);
        this.registerDeadCoral(Items.TUBE_CORAL_FAN, Items.DEAD_TUBE_CORAL_FAN);
        this.registerDeadCoral(Items.BRAIN_CORAL_FAN, Items.DEAD_BRAIN_CORAL_FAN);
        this.registerDeadCoral(Items.BUBBLE_CORAL_FAN, Items.DEAD_BUBBLE_CORAL_FAN);
        this.registerDeadCoral(Items.FIRE_CORAL_FAN, Items.DEAD_FIRE_CORAL_FAN);
        this.registerDeadCoral(Items.HORN_CORAL_FAN, Items.DEAD_HORN_CORAL_FAN);
        this.registerStripping(Items.OAK_LOG, Items.STRIPPED_OAK_LOG);
        this.registerStripping(Items.SPRUCE_LOG, Items.STRIPPED_SPRUCE_LOG);
        this.registerStripping(Items.BIRCH_LOG, Items.STRIPPED_BIRCH_LOG);
        this.registerStripping(Items.JUNGLE_LOG, Items.STRIPPED_JUNGLE_LOG);
        this.registerStripping(Items.ACACIA_LOG, Items.STRIPPED_ACACIA_LOG);
        this.registerStripping(Items.CHERRY_LOG, Items.STRIPPED_CHERRY_LOG);
        this.registerStripping(Items.DARK_OAK_LOG, Items.STRIPPED_DARK_OAK_LOG);
        this.registerStripping(Items.MANGROVE_LOG, Items.STRIPPED_MANGROVE_LOG);
        this.registerStripping(Items.CRIMSON_STEM, Items.STRIPPED_CRIMSON_STEM);
        this.registerStripping(Items.WARPED_STEM, Items.STRIPPED_WARPED_STEM);
        this.registerStripping(Items.BAMBOO_BLOCK, Items.STRIPPED_BAMBOO_BLOCK);
        this.registerStripping(Items.OAK_WOOD, Items.STRIPPED_OAK_WOOD);
        this.registerStripping(Items.SPRUCE_WOOD, Items.STRIPPED_SPRUCE_WOOD);
        this.registerStripping(Items.BIRCH_WOOD, Items.STRIPPED_BIRCH_WOOD);
        this.registerStripping(Items.JUNGLE_WOOD, Items.STRIPPED_JUNGLE_WOOD);
        this.registerStripping(Items.ACACIA_WOOD, Items.STRIPPED_ACACIA_WOOD);
        this.registerStripping(Items.CHERRY_WOOD, Items.STRIPPED_CHERRY_WOOD);
        this.registerStripping(Items.DARK_OAK_WOOD, Items.STRIPPED_DARK_OAK_WOOD);
        this.registerStripping(Items.MANGROVE_WOOD, Items.STRIPPED_MANGROVE_WOOD);
        this.registerStripping(Items.CRIMSON_HYPHAE, Items.STRIPPED_CRIMSON_HYPHAE);
        this.registerStripping(Items.WARPED_HYPHAE, Items.STRIPPED_WARPED_HYPHAE);
        this.registerTransformation(Items.CARVED_PUMPKIN, Items.PUMPKIN, Map.of(Items.SHEARS, 0.01), 1.0, "Carving pumpkin");
        this.registerTransformation(Items.FARMLAND, Items.DIRT, Map.of(Items.WOODEN_HOE, 0.01), 1.0, "Tilling dirt");
        this.registerConcrete(Items.WHITE_CONCRETE_POWDER, Items.WHITE_CONCRETE);
        this.registerConcrete(Items.ORANGE_CONCRETE_POWDER, Items.ORANGE_CONCRETE);
        this.registerConcrete(Items.MAGENTA_CONCRETE_POWDER, Items.MAGENTA_CONCRETE);
        this.registerConcrete(Items.LIGHT_BLUE_CONCRETE_POWDER, Items.LIGHT_BLUE_CONCRETE);
        this.registerConcrete(Items.YELLOW_CONCRETE_POWDER, Items.YELLOW_CONCRETE);
        this.registerConcrete(Items.LIME_CONCRETE_POWDER, Items.LIME_CONCRETE);
        this.registerConcrete(Items.PINK_CONCRETE_POWDER, Items.PINK_CONCRETE);
        this.registerConcrete(Items.GRAY_CONCRETE_POWDER, Items.GRAY_CONCRETE);
        this.registerConcrete(Items.LIGHT_GRAY_CONCRETE_POWDER, Items.LIGHT_GRAY_CONCRETE);
        this.registerConcrete(Items.CYAN_CONCRETE_POWDER, Items.CYAN_CONCRETE);
        this.registerConcrete(Items.PURPLE_CONCRETE_POWDER, Items.PURPLE_CONCRETE);
        this.registerConcrete(Items.BLUE_CONCRETE_POWDER, Items.BLUE_CONCRETE);
        this.registerConcrete(Items.BROWN_CONCRETE_POWDER, Items.BROWN_CONCRETE);
        this.registerConcrete(Items.GREEN_CONCRETE_POWDER, Items.GREEN_CONCRETE);
        this.registerConcrete(Items.RED_CONCRETE_POWDER, Items.RED_CONCRETE);
        this.registerConcrete(Items.BLACK_CONCRETE_POWDER, Items.BLACK_CONCRETE);
        this.registerOxidation(Items.COPPER_BLOCK, Items.EXPOSED_COPPER);
        this.registerOxidation(Items.EXPOSED_COPPER, Items.WEATHERED_COPPER);
        this.registerOxidation(Items.WEATHERED_COPPER, Items.OXIDIZED_COPPER);
        this.registerOxidation(Items.CUT_COPPER, Items.EXPOSED_CUT_COPPER);
        this.registerOxidation(Items.EXPOSED_CUT_COPPER, Items.WEATHERED_CUT_COPPER);
        this.registerOxidation(Items.WEATHERED_CUT_COPPER, Items.OXIDIZED_CUT_COPPER);
        this.registerOxidation(Items.CUT_COPPER_STAIRS, Items.EXPOSED_CUT_COPPER_STAIRS);
        this.registerOxidation(Items.EXPOSED_CUT_COPPER_STAIRS, Items.WEATHERED_CUT_COPPER_STAIRS);
        this.registerOxidation(Items.WEATHERED_CUT_COPPER_STAIRS, Items.OXIDIZED_CUT_COPPER_STAIRS);
        this.registerOxidation(Items.CUT_COPPER_SLAB, Items.EXPOSED_CUT_COPPER_SLAB);
        this.registerOxidation(Items.EXPOSED_CUT_COPPER_SLAB, Items.WEATHERED_CUT_COPPER_SLAB);
        this.registerOxidation(Items.WEATHERED_CUT_COPPER_SLAB, Items.OXIDIZED_CUT_COPPER_SLAB);
        this.registerOxidation(Items.COPPER_DOOR, Items.EXPOSED_COPPER_DOOR);
        this.registerOxidation(Items.EXPOSED_COPPER_DOOR, Items.WEATHERED_COPPER_DOOR);
        this.registerOxidation(Items.WEATHERED_COPPER_DOOR, Items.OXIDIZED_COPPER_DOOR);
        this.registerOxidation(Items.COPPER_TRAPDOOR, Items.EXPOSED_COPPER_TRAPDOOR);
        this.registerOxidation(Items.EXPOSED_COPPER_TRAPDOOR, Items.WEATHERED_COPPER_TRAPDOOR);
        this.registerOxidation(Items.WEATHERED_COPPER_TRAPDOOR, Items.OXIDIZED_COPPER_TRAPDOOR);
        this.registerOxidation(Items.COPPER_GRATE, Items.EXPOSED_COPPER_GRATE);
        this.registerOxidation(Items.EXPOSED_COPPER_GRATE, Items.WEATHERED_COPPER_GRATE);
        this.registerOxidation(Items.WEATHERED_COPPER_GRATE, Items.OXIDIZED_COPPER_GRATE);
        this.registerOxidation(Items.COPPER_BULB, Items.EXPOSED_COPPER_BULB);
        this.registerOxidation(Items.EXPOSED_COPPER_BULB, Items.WEATHERED_COPPER_BULB);
        this.registerOxidation(Items.WEATHERED_COPPER_BULB, Items.OXIDIZED_COPPER_BULB);
        this.registerTransformation(Items.CHIPPED_ANVIL, Items.ANVIL, null, 0.0, "Anvil usage damage");
        this.registerTransformation(Items.DAMAGED_ANVIL, Items.CHIPPED_ANVIL, null, 0.0, "Anvil usage damage");
        this.registerComplexSource(Items.ROOTED_DIRT, Map.of(Items.MOSS_BLOCK, 1.0, Items.BONE_MEAL, 2.0), 2.0, BaseResourceData.ResourceSourceType.BLOCK_TRANSFORMATION, "Bonemeal on moss");
        this.registerComplexSource(Items.AZALEA_LEAVES, Map.of(Items.MOSS_BLOCK, 1.0, Items.BONE_MEAL, 1.0), 1.0, BaseResourceData.ResourceSourceType.BLOCK_TRANSFORMATION, "Bonemeal on moss");
        this.registerComplexSource(Items.FLOWERING_AZALEA_LEAVES, Map.of(Items.MOSS_BLOCK, 1.0, Items.BONE_MEAL, 1.0), 1.0, BaseResourceData.ResourceSourceType.BLOCK_TRANSFORMATION, "Bonemeal on moss");
    }

    private void registerBucketInteractions() {
        this.registerComplexSource(Items.LAVA_BUCKET, Map.of(Items.BUCKET, 1.0), 10.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Collecting lava");
        this.registerComplexSource(Items.PUFFERFISH_BUCKET, Map.of(Items.BUCKET, 1.0), 15.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Catching pufferfish");
        this.registerComplexSource(Items.SALMON_BUCKET, Map.of(Items.BUCKET, 1.0), 15.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Catching salmon");
        this.registerComplexSource(Items.COD_BUCKET, Map.of(Items.BUCKET, 1.0), 15.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Catching cod");
        this.registerComplexSource(Items.TROPICAL_FISH_BUCKET, Map.of(Items.BUCKET, 1.0), 20.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Catching tropical fish");
        this.registerComplexSource(Items.AXOLOTL_BUCKET, Map.of(Items.BUCKET, 1.0), 25.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Catching axolotl");
        this.registerComplexSource(Items.TADPOLE_BUCKET, Map.of(Items.BUCKET, 1.0), 20.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Catching tadpole");
    }

    private void registerSpecialLoot() {
        this.registerComplexSource(Items.ELYTRA, Collections.emptyMap(), 1000.0, BaseResourceData.ResourceSourceType.SPECIAL_LOOT, "End Ship treasure (extremely rare)");
        this.registerComplexSource(Items.FLOW_POTTERY_SHERD, Collections.emptyMap(), 150.0, BaseResourceData.ResourceSourceType.ARCHAEOLOGY, "Trial Chambers archaeology");
        this.registerComplexSource(Items.GUSTER_POTTERY_SHERD, Collections.emptyMap(), 150.0, BaseResourceData.ResourceSourceType.ARCHAEOLOGY, "Trial Chambers archaeology");
        this.registerComplexSource(Items.SCRAPE_POTTERY_SHERD, Collections.emptyMap(), 150.0, BaseResourceData.ResourceSourceType.ARCHAEOLOGY, "Trial Chambers archaeology");
        this.registerComplexSource(Items.OMINOUS_TRIAL_KEY, Map.of(Items.TRIAL_KEY, 1.0), 200.0, BaseResourceData.ResourceSourceType.SPECIAL_LOOT, "Ominous Vault drop");
    }

    private void registerSpecialCrafts() {
        this.registerComplexSource(Items.BUNDLE, Map.of(Items.STRING, 2.0, Items.RABBIT_HIDE, 1.0), 1.0, BaseResourceData.ResourceSourceType.CRAFTING, "Bundle crafting");
        this.registerComplexSource(Items.WRITTEN_BOOK, Map.of(Items.WRITABLE_BOOK, 1.0), 1.0, BaseResourceData.ResourceSourceType.CRAFTING, "Signing a book");
        this.registerComplexSource(Items.FIREWORK_STAR, Map.of(Items.GUNPOWDER, 1.0, Items.YELLOW_DYE, 1.0), 1.0, BaseResourceData.ResourceSourceType.CRAFTING, "Basic firework star");
    }

    private void registerDragonItems() {
        this.registerComplexSource(Items.DRAGON_BREATH, Map.of(Items.GLASS_BOTTLE, 1.0), 100.0, BaseResourceData.ResourceSourceType.SPECIAL_ACTION, "Collecting dragon breath");
        this.registerComplexSource(Items.LINGERING_POTION, Map.of(Items.DRAGON_BREATH, 1.0, Items.SPLASH_POTION, 1.0), 1.0, BaseResourceData.ResourceSourceType.CRAFTING, "Lingering potion brewing");
    }

    private void registerDeadCoral(Item alive, Item dead) {
        this.registerTransformation(dead, alive, null, 1.0, "Coral drying out");
    }

    private void registerStripping(Item normal, Item stripped) {
        this.registerTransformation(stripped, normal, Map.of(Items.WOODEN_AXE, 0.01), 1.0, "Stripping with axe");
    }

    private void registerConcrete(Item powder, Item concrete) {
        this.registerTransformation(concrete, powder, null, 5.0, "Solidifying in water");
    }

    private void registerOxidation(Item from, Item to) {
        double timeCost = (Double)ComplexityConfig.TIME_COST_MULTIPLIER.get() * 40000.0;
        this.registerTransformation(to, from, null, timeCost, "Natural oxidation");
    }

    private record SourceRule(Map<Item, Double> ingredients, double baseCost, BaseResourceData.ResourceSourceType type, String description, String modId) {
    }
}

