/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.sources;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.analyzer.resource.IResourceSource;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.config.ComplexityConfig;

public class PassiveProductionSource
implements IResourceSource {
    private final Map<Item, ProductionInfo> productionMap = new HashMap<Item, ProductionInfo>();

    @Override
    public void initialize(Level level) {
        this.productionMap.put(Items.EGG, new ProductionInfo(EntityType.CHICKEN, 9000.0, "Passive (lays egg)"));
        this.productionMap.put(Items.ARMADILLO_SCUTE, new ProductionInfo(EntityType.ARMADILLO, 9000.0, "Brushing / Passive"));
        this.productionMap.put(Items.TURTLE_SCUTE, new ProductionInfo(EntityType.TURTLE, 24000.0, "Grows Up"));
        this.productionMap.put(Items.TADPOLE_BUCKET, new ProductionInfo(EntityType.FROG, 1200.0, "Hatches from Frogspawn"));
        this.productionMap.put(Items.WHITE_WOOL, new ProductionInfo(EntityType.SHEEP, 2400.0, "Shearing"));
        this.productionMap.put(Items.MILK_BUCKET, new ProductionInfo(EntityType.COW, 20.0, "Milking"));
        this.productionMap.put(Items.MUSHROOM_STEW, new ProductionInfo(EntityType.MOOSHROOM, 20.0, "Milking with Bowl"));
        this.productionMap.put(Items.GOAT_HORN, new ProductionInfo(EntityType.GOAT, 6300.0, "Rams a block"));
        this.productionMap.put(Items.OCHRE_FROGLIGHT, new ProductionInfo(EntityType.FROG, 200.0, "Eats Magma Cube"));
        this.productionMap.put(Items.VERDANT_FROGLIGHT, new ProductionInfo(EntityType.FROG, 200.0, "Eats Magma Cube"));
        this.productionMap.put(Items.PEARLESCENT_FROGLIGHT, new ProductionInfo(EntityType.FROG, 200.0, "Eats Magma Cube"));
        this.productionMap.put(Items.CHORUS_FRUIT, new ProductionInfo(EntityType.SHULKER, 6000.0, "Grows on Chorus Plant"));
        this.productionMap.put(Items.PITCHER_POD, new ProductionInfo(EntityType.SNIFFER, 4800.0, "Dug up by Sniffer"));
        this.productionMap.put(Items.TORCHFLOWER_SEEDS, new ProductionInfo(EntityType.SNIFFER, 4800.0, "Dug up by Sniffer"));
        this.productionMap.put(Items.BEETROOT, new ProductionInfo(null, 4800.0, "Farming"));
        this.productionMap.put(Items.FROGSPAWN, new ProductionInfo(EntityType.FROG, 12000.0, "Breeding"));
        this.productionMap.put(Items.TURTLE_EGG, new ProductionInfo(EntityType.TURTLE, 12000.0, "Breeding"));
        this.productionMap.put(Items.PITCHER_PLANT, new ProductionInfo(null, 24000.0, "Grows from Pod"));
    }

    @Override
    public boolean canProvide(Item item) {
        return this.productionMap.containsKey(item);
    }

    @Override
    public Optional<BaseResourceData> analyze(Item item) {
        if (!this.canProvide(item)) {
            return Optional.empty();
        }
        ProductionInfo info = this.productionMap.get(item);
        double complexity = info.ticksPerItem() * (Double)ComplexityConfig.TIME_COST_MULTIPLIER.get() + (Double)ComplexityConfig.BASE_ACTION_COST.get();
        String sourceName = info.sourceType() != null ? info.sourceType().getDescription().getString() : "the environment";
        String details = String.format("From %s (Avg. ~%d ticks, Method: %s)", sourceName, (int)info.ticksPerItem(), info.method());
        return Optional.of(new BaseResourceData.Builder(item, this).sourceType(BaseResourceData.ResourceSourceType.FARMING).baseFactor(complexity).details(details).build());
    }

    @Override
    public BaseResourceData.ResourceSourceType getSourceType() {
        return BaseResourceData.ResourceSourceType.FARMING;
    }

    @Override
    public int getPriority() {
        return 30;
    }

    @Override
    public String getName() {
        return "PassiveProductionSource";
    }

    private record ProductionInfo(EntityType<?> sourceType, double ticksPerItem, String method) {
    }
}

