/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.data.ComplexityCategory;
import org.complexityanalyzer.data.ItemComplexity;
import org.jetbrains.annotations.NotNull;

public class ComplexityCache {
    private final Map<Item, ItemComplexity> cache = new ConcurrentHashMap<Item, ItemComplexity>();
    private final Map<Item, ComplexityCategory> categoryCache = new ConcurrentHashMap<Item, ComplexityCategory>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong misses = new AtomicLong(0L);

    public Optional<ItemComplexity> get(Item item) {
        ItemComplexity result = this.cache.get(item);
        if (result != null) {
            this.hits.incrementAndGet();
            return Optional.of(result);
        }
        this.misses.incrementAndGet();
        return Optional.empty();
    }

    public void put(Item item, ItemComplexity complexity) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(item, complexity);
            this.categoryCache.put(item, complexity.getCategory());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<ComplexityCategory> getCategory(Item item) {
        return Optional.ofNullable(this.categoryCache.get(item));
    }

    public boolean contains(Item item) {
        return this.cache.containsKey(item);
    }

    public Set<Item> getCachedItems() {
        this.lock.readLock().lock();
        try {
            HashSet<Item> hashSet = new HashSet<Item>(this.cache.keySet());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void remove(Item item) {
        this.lock.writeLock().lock();
        try {
            this.cache.remove(item);
            this.categoryCache.remove(item);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            int size = this.cache.size();
            this.cache.clear();
            this.categoryCache.clear();
            this.hits.set(0L);
            this.misses.set(0L);
            ComplexityAnalyzer.LOGGER.debug("ComplexityCache cleared ({} entries removed)", (Object)size);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        return this.cache.size();
    }

    public CacheStats getStats() {
        long currentMisses;
        long currentHits = this.hits.get();
        long total = currentHits + (currentMisses = this.misses.get());
        double hitRate = total > 0L ? (double)currentHits / (double)total * 100.0 : 0.0;
        return new CacheStats(this.cache.size(), this.categoryCache.size(), currentHits, currentMisses, hitRate);
    }

    public void resetStats() {
        this.hits.set(0L);
        this.misses.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getItemsByCategory(ComplexityCategory category) {
        this.lock.readLock().lock();
        try {
            ArrayList<Item> items = new ArrayList<Item>();
            for (Map.Entry<Item, ComplexityCategory> entry : this.categoryCache.entrySet()) {
                if (entry.getValue() != category) continue;
                items.add(entry.getKey());
            }
            ArrayList<Item> arrayList = items;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public record CacheStats(int cacheSize, int categoryCacheSize, long hits, long misses, double hitRate) {
        @Override
        @NotNull
        public String toString() {
            return String.format("CacheStats{size=%d, categories=%d, hits=%d, misses=%d, hitRate=%.2f%%}", this.cacheSize, this.categoryCacheSize, this.hits, this.misses, this.hitRate);
        }
    }
}

