/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.cache;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.graph.RecipeGraph;
import org.jetbrains.annotations.NotNull;

public class GraphCache {
    private RecipeGraph currentGraph = null;
    private long version = 0L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void setGraph(RecipeGraph graph) {
        this.lock.writeLock().lock();
        try {
            this.currentGraph = graph;
            ++this.version;
            ComplexityAnalyzer.LOGGER.debug("Graph updated to version {}", (Object)this.version);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public RecipeGraph getGraph() {
        this.lock.readLock().lock();
        try {
            RecipeGraph recipeGraph = this.currentGraph;
            return recipeGraph;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isInitialized() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.currentGraph != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getVersion() {
        this.lock.readLock().lock();
        try {
            long l = this.version;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getRecipeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.currentGraph != null ? this.currentGraph.getTotalRecipeCount() : 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getItemCount() {
        this.lock.readLock().lock();
        try {
            int n = this.currentGraph != null ? this.currentGraph.getAllItems().size() : 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasRecipe(Item item) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.currentGraph != null && this.currentGraph.hasRecipe(item);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            if (this.currentGraph != null) {
                this.currentGraph.clear();
                this.currentGraph = null;
            }
            this.version = 0L;
            ComplexityAnalyzer.LOGGER.debug("GraphCache cleared");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public GraphStats getStats() {
        this.lock.readLock().lock();
        try {
            if (this.currentGraph == null) {
                GraphStats graphStats = new GraphStats(this.version, 0, 0, false);
                return graphStats;
            }
            RecipeGraph.GraphStats graphStats = this.currentGraph.getStats();
            GraphStats graphStats2 = new GraphStats(this.version, graphStats.itemsWithRecipes(), graphStats.totalRecipes(), true);
            return graphStats2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public record GraphStats(long version, int itemCount, int recipeCount, boolean initialized) {
        @Override
        @NotNull
        public String toString() {
            return String.format("GraphStats{version=%d, items=%d, recipes=%d, initialized=%s}", this.version, this.itemCount, this.recipeCount, this.initialized);
        }
    }
}

