/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.sources.UniversalLootSource;
import org.complexityanalyzer.command.AnalyzeCommand;
import org.complexityanalyzer.command.ChunkCommands;
import org.complexityanalyzer.command.EntityAnalyzeCommand;
import org.complexityanalyzer.command.ExportCommand;
import org.complexityanalyzer.command.LootAnalyzeCommand;
import org.complexityanalyzer.command.ResourceCommand;
import org.complexityanalyzer.command.TreeCommand;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.event.DatapackSyncHandler;

@EventBusSubscriber(modid="complexityanalyzer")
public class ComplexityCommand {
    private static final SuggestionProvider<CommandSourceStack> ITEM_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.ITEM.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> ENTITY_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(id -> {
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
        return type.getCategory() != MobCategory.MISC;
    }), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> LOOT_TABLE_SUGGESTIONS = (context, builder) -> {
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return builder.buildFuture();
        }
        return engine.getSourceByType(UniversalLootSource.class).map(uls -> {
            uls.getAllLootData().values().stream().flatMap(map -> map.values().stream()).map(data -> {
                try {
                    String details = data.getDetails();
                    int start = details.indexOf("'") + 1;
                    int end = details.indexOf("'", start);
                    return details.substring(start, end);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).distinct().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).orElse(builder.buildFuture());
    };

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"complexity").then(Commands.literal((String)"status").executes(ComplexityCommand::executeStatus))).then(Commands.literal((String)"tps").executes(ComplexityCommand::executeTps))).then(Commands.literal((String)"stats").executes(ComplexityCommand::executeStats))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"analyze").then(Commands.literal((String)"item").then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(cmd -> AnalyzeCommand.execute((CommandContext<CommandSourceStack>)cmd, ResourceLocationArgument.getId((CommandContext)cmd, (String)"item")))))).then(Commands.literal((String)"entity").then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(cmd -> EntityAnalyzeCommand.execute((CommandContext<CommandSourceStack>)cmd, ResourceLocationArgument.getId((CommandContext)cmd, (String)"entity")))))).then(Commands.literal((String)"loot").then(Commands.argument((String)"loot_table", (ArgumentType)ResourceLocationArgument.id()).suggests(LOOT_TABLE_SUGGESTIONS).executes(ctx -> LootAnalyzeCommand.execute((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"loot_table"))))))).then(Commands.literal((String)"resource").then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(cmd -> ResourceCommand.execute((CommandContext<CommandSourceStack>)cmd, ResourceLocationArgument.getId((CommandContext)cmd, (String)"item")))))).then(Commands.literal((String)"tree").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(ctx -> TreeCommand.execute((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"item"), "player", 100))).then(Commands.literal((String)"depth").then(((RequiredArgumentBuilder)Commands.argument((String)"max_depth", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TreeCommand.execute((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"item"), "player", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max_depth")))).then(Commands.literal((String)"mode").then(Commands.argument((String)"mode_type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"player", "economic"}, (SuggestionsBuilder)builder)).executes(ctx -> TreeCommand.execute((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"item"), StringArgumentType.getString((CommandContext)ctx, (String)"mode_type"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max_depth")))))))).then(Commands.literal((String)"mode").then(((RequiredArgumentBuilder)Commands.argument((String)"mode_type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"player", "economic"}, (SuggestionsBuilder)builder)).executes(ctx -> TreeCommand.execute((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"item"), StringArgumentType.getString((CommandContext)ctx, (String)"mode_type"), 100))).then(Commands.literal((String)"depth").then(Commands.argument((String)"max_depth", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TreeCommand.execute((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"item"), StringArgumentType.getString((CommandContext)ctx, (String)"mode_type"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max_depth")))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.hasPermission(2))).executes(ComplexityCommand::executeReload))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"items").then(Commands.literal((String)"all").executes(ExportCommand::executeAllItems))).then(Commands.literal((String)"category").then(Commands.argument((String)"category_name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"Trivial", "Simple", "Moderate", "Complex", "Difficult", "Expert", "Master", "Mythical", "Transcendent", "Eternal"}, (SuggestionsBuilder)builder)).executes(ctx -> ExportCommand.executeItemsByCategory((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category_name")))))).then(Commands.literal((String)"top").then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(ctx -> ExportCommand.executeTopItems((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))))).then(Commands.literal((String)"single").then(Commands.argument((String)"item_id", (ArgumentType)ResourceLocationArgument.id()).suggests(ITEM_SUGGESTIONS).executes(ctx -> ExportCommand.executeSingleItem((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"item_id").toString()))))).then(Commands.literal((String)"csv").executes(ExportCommand::executeItemsCSV)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mobs").then(((LiteralArgumentBuilder)Commands.literal((String)"all").executes(ctx -> ExportCommand.executeAllMobs((CommandContext<CommandSourceStack>)ctx, "json"))).then(Commands.literal((String)"format").then(Commands.argument((String)"format_type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"csv", "json"}, (SuggestionsBuilder)builder)).executes(ctx -> ExportCommand.executeAllMobs((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"format_type"))))))).then(Commands.literal((String)"category").then(Commands.argument((String)"category_name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(MobCategory.values()).map(MobCategory::getName), (SuggestionsBuilder)builder)).executes(ctx -> ExportCommand.executeMobsByCategory((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category_name")))))).then(Commands.literal((String)"top").then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(ctx -> ExportCommand.executeTopMobs((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))))).then(Commands.literal((String)"single").then(Commands.argument((String)"mob_id", (ArgumentType)ResourceLocationArgument.id()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> ExportCommand.executeSingleMob((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"mob_id").toString()))))).then(Commands.literal((String)"csv").executes(ctx -> ExportCommand.executeAllMobs((CommandContext<CommandSourceStack>)ctx, "csv")))))).then(ChunkCommands.register()));
        ComplexityAnalyzer.LOGGER.info("Registered /complexity command with role-based permissions");
    }

    private static int executeStatus(CommandContext<CommandSourceStack> context) {
        String stateIcon;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = DatapackSyncHandler.getEngine();
        if (engine == null) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Analysis Engine is not initialized!").withStyle(ChatFormatting.RED));
            return 0;
        }
        AnalysisEngine.State state = engine.getCurrentState();
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\u2699 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Complexity Analyzer Status").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        ChatFormatting stateColor = switch (state.toString()) {
            case "READY" -> {
                stateIcon = "\u2713";
                yield ChatFormatting.GREEN;
            }
            case "LOADING", "INITIALIZING" -> {
                stateIcon = "\u23f3";
                yield ChatFormatting.YELLOW;
            }
            case "ERROR", "FAILED" -> {
                stateIcon = "\u2717";
                yield ChatFormatting.RED;
            }
            default -> {
                stateIcon = "\u25c6";
                yield ChatFormatting.GRAY;
            }
        };
        output.sendInfo(source, (Component)Component.literal((String)"  Engine State: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(stateIcon + " " + String.valueOf((Object)state))).withStyle(new ChatFormatting[]{stateColor, ChatFormatting.BOLD})));
        if (engine.isReady()) {
            AnalysisEngine.EngineStats stats = engine.getStats();
            output.sendInfo(source, (Component)Component.literal((String)""));
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udcca Data Overview:").withStyle(ChatFormatting.AQUA));
            output.sendInfo(source, (Component)Component.literal((String)"    Items with recipes: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(stats.itemCount())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
            output.sendInfo(source, (Component)Component.literal((String)"    Total recipes: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(stats.recipeCount())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
            output.sendInfo(source, (Component)Component.literal((String)"    Base resources: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(stats.baseResourceCount())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        } else {
            output.sendInfo(source, (Component)Component.literal((String)""));
            output.sendInfo(source, (Component)Component.literal((String)"  \u26a0 Engine not ready. Statistics unavailable.").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        return 1;
    }

    private static int executeReload(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (engine == null) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Engine not initialized!"));
            return 0;
        }
        String adminName = source.getTextName();
        output.broadcastWarning((Component)Component.literal((String)"\u26a0 Analysis system is reloading... Possible lag!"));
        output.sendToAdmins((Component)Component.literal((String)("System reload initiated by " + adminName)));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udd04 Reloading Analysis Systems...").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"  This may take a few seconds and cause lag.").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        output.sendInfo(source, (Component)Component.literal((String)"  Running in background...").withStyle(ChatFormatting.DARK_GRAY));
        engine.reloadAsync((Level)source.getLevel());
        return 1;
    }

    private static int executeTps(CommandContext<CommandSourceStack> context) {
        ChatFormatting tpsColor;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        MinecraftServer server = source.getServer();
        double mspt = (double)server.getAverageTickTimeNanos() / 1000000.0;
        double tps = 1000.0 / Math.max(50.0, mspt);
        double finalTps = Math.min(20.0, tps);
        ChatFormatting chatFormatting = tps >= 19.0 ? ChatFormatting.GREEN : (tpsColor = tps >= 16.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        ChatFormatting msptColor = mspt <= 40.0 ? ChatFormatting.GREEN : (mspt <= 50.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory() / 1024L / 1024L;
        long totalMemory = runtime.totalMemory() / 1024L / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        long usedMemory = totalMemory - freeMemory;
        double memoryPercent = (double)usedMemory / (double)totalMemory * 100.0;
        ChatFormatting memoryColor = memoryPercent < 60.0 ? ChatFormatting.GREEN : (memoryPercent < 80.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        double avgPing = server.getPlayerList().getPlayers().stream().mapToInt(player -> player.connection.latency()).average().orElse(0.0);
        ChatFormatting pingColor = avgPing < 100.0 ? ChatFormatting.GREEN : (avgPing < 200.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcc8 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Server Performance").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \u2699 Tick Performance").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        MutableComponent tpsComponent = Component.literal((String)"    TPS: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", finalTps)).withStyle(new ChatFormatting[]{tpsColor, ChatFormatting.BOLD}));
        String tpsIcon = tps >= 19.0 ? " \u2713" : (tps >= 16.0 ? " \u26a0" : " \u2717");
        tpsComponent.append((Component)Component.literal((String)tpsIcon).withStyle(tpsColor));
        output.sendInfo(source, (Component)tpsComponent);
        output.sendInfo(source, (Component)Component.literal((String)"    MSPT: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f ms", mspt)).withStyle(msptColor)));
        String msptBar = ComplexityCommand.getPerformanceBar(mspt);
        output.sendInfo(source, (Component)Component.literal((String)("    " + msptBar)).withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udcbe Memory Usage").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    Used: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(usedMemory + " MB")).withStyle(memoryColor)).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)(totalMemory + " MB")).withStyle(ChatFormatting.WHITE)));
        output.sendInfo(source, (Component)Component.literal((String)"    Max Available: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(maxMemory + " MB")).withStyle(ChatFormatting.YELLOW)));
        String memoryBar = ComplexityCommand.getMemoryBar(usedMemory, totalMemory);
        output.sendInfo(source, (Component)Component.literal((String)("    " + memoryBar + " ")).withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.format("%.1f%%", memoryPercent)).withStyle(memoryColor)));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83c\udf10 Network").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    Players Online: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(server.getPlayerCount())).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        if (server.getPlayerCount() > 0) {
            output.sendInfo(source, (Component)Component.literal((String)"    Avg Ping: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.0f ms", avgPing)).withStyle(pingColor)));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        return 1;
    }

    private static int executeStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Engine is not ready!").withStyle(ChatFormatting.RED));
            output.sendInfo(source, (Component)Component.literal((String)("Current state: " + String.valueOf((Object)engine.getCurrentState()))).withStyle(ChatFormatting.GRAY));
            return 0;
        }
        AnalysisEngine.EngineStats stats = engine.getStats();
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcca ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"Detailed Statistics").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd17 Recipe Graph").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    Items: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(stats.itemCount())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"    Recipes: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(stats.recipeCount())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        if (stats.itemCount() > 0) {
            double avgRecipesPerItem = (double)stats.recipeCount() / (double)stats.itemCount();
            output.sendInfo(source, (Component)Component.literal((String)"    Avg Recipes/Item: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", avgRecipesPerItem)).withStyle(ChatFormatting.AQUA)));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \u26cf Base Resources").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    Cached Items: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(stats.baseResourceCount())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"    (Mining, Loot, Mobs, etc.)").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        output.sendInfo(source, (Component)Component.literal((String)""));
        long totalEntries = stats.itemCount() + stats.baseResourceCount();
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udcbf Total Database Entries: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(totalEntries)).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        return 1;
    }

    private static String getPerformanceBar(double current) {
        int percent = (int)Math.min(100.0, current / 50.0 * 100.0);
        int filled = percent / 10;
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < filled) {
                bar.append("\u2588");
                continue;
            }
            bar.append("\u2591");
        }
        bar.append("]");
        return bar.toString();
    }

    private static String getMemoryBar(long used, long total) {
        int percent = (int)((double)used / (double)total * 100.0);
        int filled = percent / 10;
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < filled) {
                bar.append("\u2588");
                continue;
            }
            bar.append("\u2591");
        }
        bar.append("]");
        return bar.toString();
    }
}

