/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.compat.jei.DirectRecipeExtractor;
import org.complexityanalyzer.compat.jei.JeiPluginScanner;
import org.complexityanalyzer.config.ComplexityConfig;
import org.complexityanalyzer.graph.RecipeGraph;

public class JeiCompatibilityModule {
    public static void collectRecipesFromJeiPlugins(RecipeGraph graph, Level level) {
        if (!ModList.get().isLoaded("jei")) {
            ComplexityAnalyzer.LOGGER.info("JEI not found. Skipping JEI recipe import.");
            return;
        }
        if (!((Boolean)ComplexityConfig.ENABLE_JEI_INTEGRATION.get()).booleanValue()) {
            ComplexityAnalyzer.LOGGER.info("JEI integration disabled in config");
            return;
        }
        try {
            JeiPluginScanner.scanAndImportRecipes(graph, level);
            DirectRecipeExtractor.extractCustomRecipes(graph, level);
        }
        catch (Throwable t) {
            ComplexityAnalyzer.LOGGER.error("JEI integration failed catastrophically", t);
        }
    }
}

