/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.compat.jei.JeiRecipeConverter;
import org.complexityanalyzer.compat.jei.MockRecipeRegistration;
import org.complexityanalyzer.compat.jei.SafePluginLoader;
import org.complexityanalyzer.config.ComplexityConfig;
import org.complexityanalyzer.graph.RecipeGraph;
import org.complexityanalyzer.graph.RecipeNode;

public class JeiPluginScanner {
    public static void scanAndImportRecipes(RecipeGraph graph, Level level) {
        ArrayList cleanPlugins = new ArrayList();
        ModList.get().getMods().forEach(modInfo -> {
            String modId = modInfo.getModId();
            if (modId.equals("jei") || modId.equals("complexityanalyzer")) {
                return;
            }
            try {
                ModFileScanData scanData = modInfo.getOwningFile().getFile().getScanResult();
                scanData.getAnnotations().stream().filter(ad -> ad.annotationType().getClassName().equals("mezz.jei.api.JeiPlugin")).forEach(ad -> {
                    IModPlugin plugin = SafePluginLoader.tryLoadPlugin(ad.clazz().getClassName(), modId);
                    if (plugin != null) {
                        cleanPlugins.add(plugin);
                    }
                });
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.warn("Error scanning mod {} for JEI plugins: {}", (Object)modId, (Object)e.getMessage());
            }
        });
        if (cleanPlugins.isEmpty()) {
            ComplexityAnalyzer.LOGGER.info("No server-safe JEI plugins found to import recipes from.");
            return;
        }
        ComplexityAnalyzer.LOGGER.info("Found {} server-safe JEI plugin(s), extracting recipes...", (Object)cleanPlugins.size());
        int pluginsProcessed = 0;
        int totalRecipesImported = 0;
        for (IModPlugin plugin : cleanPlugins) {
            try {
                List<RecipeNode> recipes;
                String pluginId = plugin.getPluginUid().toString();
                if (JeiPluginScanner.isBlacklisted(plugin.getPluginUid().getNamespace())) {
                    ComplexityAnalyzer.LOGGER.info("Skipping blacklisted plugin: {}", (Object)pluginId);
                    continue;
                }
                MockRecipeRegistration mockRegistration = new MockRecipeRegistration(level);
                try {
                    plugin.registerRecipes((IRecipeRegistration)mockRegistration);
                }
                catch (ExceptionInInitializerError | NoClassDefFoundError e) {
                    ComplexityAnalyzer.LOGGER.warn("Plugin {} failed during recipe registration (client-only code likely). Skipping. Error: {}", (Object)pluginId, (Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    ComplexityAnalyzer.LOGGER.debug("Plugin {} threw exception during recipe registration: {}", (Object)pluginId, (Object)e.getMessage());
                }
                if ((recipes = JeiRecipeConverter.convertAll(mockRegistration.getCollectedRecipes(), mockRegistration.getLevel())).isEmpty()) continue;
                recipes.forEach(graph::addRecipe);
                ++pluginsProcessed;
                totalRecipesImported += recipes.size();
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.warn("Failed to process JEI plugin {}: {}", (Object)plugin.getClass().getName(), (Object)e.getMessage());
            }
        }
        ComplexityAnalyzer.LOGGER.info("JEI import complete: {} plugins processed, {} recipes imported.", (Object)pluginsProcessed, (Object)totalRecipesImported);
    }

    private static boolean isBlacklisted(String modId) {
        return ((List)ComplexityConfig.JEI_PLUGIN_BLACKLIST.get()).contains(modId);
    }
}

