/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.compat.jei.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MockRecipeRegistration
implements IRecipeRegistration {
    private final Map<RecipeType<?>, List<?>> collectedRecipes = new HashMap();
    private final Level level;
    private final RecipeManager recipeManager;
    private static IJeiHelpers STUB_HELPERS = null;
    private static IVanillaRecipeFactory STUB_RECIPE_FACTORY = null;

    public MockRecipeRegistration(Level level) {
        this.level = level;
        this.recipeManager = level.getRecipeManager();
    }

    public Level getLevel() {
        return this.level;
    }

    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        if (recipes.isEmpty()) {
            return;
        }
        this.collectedRecipes.put(recipeType, new ArrayList<T>(recipes));
    }

    @NotNull
    public Map<RecipeType<?>, List<?>> getCollectedRecipes() {
        return Collections.unmodifiableMap(this.collectedRecipes);
    }

    @NotNull
    public IJeiHelpers getJeiHelpers() {
        if (STUB_HELPERS == null) {
            STUB_HELPERS = this.createProxyWithRecipeManager(IJeiHelpers.class);
        }
        return STUB_HELPERS;
    }

    @NotNull
    public IIngredientManager getIngredientManager() {
        try {
            Class<?> jeiInternalClass = Class.forName("mezz.jei.common.Internal");
            Method getIngredientManager = jeiInternalClass.getMethod("getIngredientManager", new Class[0]);
            Object manager = getIngredientManager.invoke(null, new Object[0]);
            if (manager instanceof IIngredientManager) {
                return (IIngredientManager)manager;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createProxyWithRecipeManager(IIngredientManager.class);
    }

    @NotNull
    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        if (STUB_RECIPE_FACTORY == null) {
            STUB_RECIPE_FACTORY = this.createProxyWithRecipeManager(IVanillaRecipeFactory.class);
        }
        return STUB_RECIPE_FACTORY;
    }

    public <T> void addIngredientInfo(T ingredient, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
    }

    public <T> void addIngredientInfo(List<T> ingredients, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
    }

    private <T> T createProxyWithRecipeManager(Class<T> interfaceClass) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new StubInvocationHandlerWithRecipeManager(this.recipeManager));
    }

    private static class StubInvocationHandlerWithRecipeManager
    implements InvocationHandler {
        private final RecipeManager recipeManager;

        public StubInvocationHandlerWithRecipeManager(RecipeManager recipeManager) {
            this.recipeManager = recipeManager;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String methodName = method.getName();
            if (methodName.equals("getRecipeManager")) {
                return this.recipeManager;
            }
            if (methodName.equals("getAllRecipesFor") && args.length == 1) {
                Object jeiType = args[0];
                try {
                    RecipeType jeiRecipeType;
                    ResourceLocation uid;
                    net.minecraft.world.item.crafting.RecipeType mcType;
                    if (jeiType instanceof RecipeType && (mcType = (net.minecraft.world.item.crafting.RecipeType)BuiltInRegistries.RECIPE_TYPE.get(uid = (jeiRecipeType = (RecipeType)jeiType).getUid())) != null) {
                        List result = this.recipeManager.getAllRecipesFor(mcType);
                        return result;
                    }
                }
                catch (Exception e) {
                    ComplexityAnalyzer.LOGGER.error("Failed to retrieve recipes for JEI RecipeType", (Throwable)e);
                }
            }
            switch (methodName) {
                case "toString": {
                    return "MockJeiStub@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "equals": {
                    return args.length == 1 && proxy == args[0];
                }
            }
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                return null;
            }
            if (returnType == Boolean.TYPE) {
                return false;
            }
            if (returnType.isPrimitive()) {
                return 0;
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                return Collections.emptyList();
            }
            if (Optional.class.isAssignableFrom(returnType)) {
                return Optional.empty();
            }
            return null;
        }
    }
}

