/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import java.lang.reflect.Constructor;
import mezz.jei.api.IModPlugin;
import org.complexityanalyzer.ComplexityAnalyzer;

public class SafePluginLoader {
    public static IModPlugin tryLoadPlugin(String className, String modId) {
        try {
            Class<?> pluginClass = Class.forName(className);
            if (!IModPlugin.class.isAssignableFrom(pluginClass)) {
                return null;
            }
            Constructor<?> ctor = pluginClass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (IModPlugin)ctor.newInstance(new Object[0]);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            ComplexityAnalyzer.LOGGER.warn("[SafeLoader] Skipping client-only JEI plugin from mod '{}': {} (Reason: {})", new Object[]{modId, className, e.getClass().getSimpleName()});
            return null;
        }
        catch (Throwable t) {
            ComplexityAnalyzer.LOGGER.error("[SafeLoader] Failed to load JEI plugin class '{}' from mod '{}'", new Object[]{className, modId, t});
            return null;
        }
    }
}

