/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.data;

import net.minecraft.world.item.Item;
import org.complexityanalyzer.data.ComplexityCategory;

public class ItemComplexity {
    private final Item item;
    private final double complexity;
    private final int depth;
    private final int totalIngredients;
    private final ComplexityCategory category;
    private final boolean hasCycle;
    private final boolean hasRecipe;
    private final String errorMessage;

    private ItemComplexity(Builder builder) {
        this.item = builder.item;
        this.complexity = builder.complexity;
        this.depth = builder.depth;
        this.totalIngredients = builder.totalIngredients;
        this.category = builder.category != null ? builder.category : ComplexityCategory.fromComplexity(builder.complexity);
        this.hasCycle = builder.hasCycle;
        this.hasRecipe = builder.hasRecipe;
        this.errorMessage = builder.errorMessage;
    }

    public Item getItem() {
        return this.item;
    }

    public double getComplexity() {
        return this.complexity;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getTotalIngredients() {
        return this.totalIngredients;
    }

    public ComplexityCategory getCategory() {
        return this.category;
    }

    public boolean hasCycle() {
        return this.hasCycle;
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValid() {
        return this.errorMessage == null && !this.hasCycle && this.complexity >= 0.0;
    }

    public static ItemComplexity error(Item item, String error) {
        return new Builder(item).complexity(-1.0).category(ComplexityCategory.UNCALCULABLE).errorMessage(error).build();
    }

    public static ItemComplexity cycle(Item item) {
        return new Builder(item).complexity(-1.0).category(ComplexityCategory.UNCALCULABLE).hasCycle(true).errorMessage("Cyclic dependency detected").build();
    }

    public static ItemComplexity noRecipe(Item item) {
        return new Builder(item).complexity(1.0).category(ComplexityCategory.TRIVIAL).hasRecipe(false).build();
    }

    public static ItemComplexity infinite(Item item) {
        return new Builder(item).complexity(Double.POSITIVE_INFINITY).category(ComplexityCategory.ETERNAL).build();
    }

    public String toString() {
        return String.format("ItemComplexity{item=%s, complexity=%.2f, depth=%d, category=%s}", new Object[]{this.item, this.complexity, this.depth, this.category});
    }

    public static class Builder {
        private final Item item;
        private double complexity = 0.0;
        private int depth = 0;
        private int totalIngredients = 0;
        private ComplexityCategory category;
        private boolean hasCycle = false;
        private boolean hasRecipe = true;
        private String errorMessage;

        public Builder(Item item) {
            this.item = item;
        }

        public Builder complexity(double complexity) {
            this.complexity = complexity;
            return this;
        }

        public Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public Builder totalIngredients(int totalIngredients) {
            this.totalIngredients = totalIngredients;
            return this;
        }

        public Builder category(ComplexityCategory category) {
            this.category = category;
            return this;
        }

        public Builder hasCycle(boolean hasCycle) {
            this.hasCycle = hasCycle;
            return this;
        }

        public Builder hasRecipe(boolean hasRecipe) {
            this.hasRecipe = hasRecipe;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ItemComplexity build() {
            return new ItemComplexity(this);
        }
    }
}

