/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.event;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.core.AnalysisEngine;

@EventBusSubscriber(modid="complexityanalyzer")
public class DatapackSyncHandler {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        AnalysisEngine engine = AnalysisEngine.getInstance();
        engine.createGeoManager(server);
        engine.initializeAsync((Level)server.overworld(), () -> ComplexityAnalyzer.LOGGER.info("Analysis engine initialization complete."));
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        AnalysisEngine.getInstance().shutdown();
    }

    public static AnalysisEngine getEngine() {
        return AnalysisEngine.getInstance();
    }
}

