/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.geoscan.task;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.jetbrains.annotations.Nullable;

public class ScanNotifier {
    private final MinecraftServer server;
    private long lastLogTime = 0L;
    private static final long LOG_INTERVAL_MS = 15000L;

    public ScanNotifier(MinecraftServer server) {
        this.server = server;
    }

    public void broadcastInfo(String message) {
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)("\u00a7e[CA] \u00a7f" + message)), false);
    }

    public void broadcastWarning(String message) {
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)("\u00a7e[CA] \u00a76WARNING! \u00a7f" + message)), false);
    }

    public void broadcastSevere(String message) {
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)("\u00a7c[CA] \u00a7l" + message)), false);
    }

    public void broadcastSuccess(String message) {
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)("\u00a7a[CA] \u00a7f" + message)), false);
    }

    public void sendSuccess(@Nullable CommandSourceStack source, String message) {
        MutableComponent component = Component.literal((String)("\u00a7a[CA] \u00a7f" + message));
        if (source != null) {
            source.sendSuccess(() -> ScanNotifier.lambda$sendSuccess$0((Component)component), false);
        } else {
            this.logInfo(message);
        }
    }

    public void sendFailure(@Nullable CommandSourceStack source, String message) {
        MutableComponent component = Component.literal((String)("\u00a7c[CA] Error: " + message));
        if (source != null) {
            source.sendFailure((Component)component);
        } else {
            this.logError(message);
        }
    }

    public void logInfo(String message) {
        ComplexityAnalyzer.LOGGER.info(message);
    }

    public void logWarn(String message) {
        ComplexityAnalyzer.LOGGER.warn(message);
    }

    public void logError(String message) {
        ComplexityAnalyzer.LOGGER.error(message);
    }

    public void logError(String message, Throwable throwable) {
        ComplexityAnalyzer.LOGGER.error(message, throwable);
    }

    public void logProgress(boolean shouldLog, String message) {
        if (!shouldLog) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogTime > 15000L) {
            this.lastLogTime = currentTime;
            this.logInfo(message);
        }
    }

    public void notifyScanCountdown(int secondsLeft) {
        if (secondsLeft > 0 && (secondsLeft <= 10 || secondsLeft % 15 == 0)) {
            this.broadcastInfo(String.format("World analysis will start in %d seconds...", secondsLeft));
        } else if (secondsLeft == 0) {
            this.broadcastSevere("Scan started! High server load may occur!");
        }
    }

    public void notifyScanStarting(int chunksPerBiome, String initiator) {
        this.logInfo("Countdown finished. Starting scan requested by " + initiator + " for " + chunksPerBiome + " chunks per biome.");
    }

    public void notifyScanPreparationComplete(int totalBiomes) {
        this.broadcastInfo("Preliminary analysis complete. Background scanning begins.");
        this.logInfo("Geo-scan preparation complete. Found " + totalBiomes + " reachable biomes to scan/update.");
    }

    public void notifyDatabaseIsUpToDate() {
        this.broadcastSuccess("Database is already up to date.");
    }

    public void notifyReconnaissanceFinished(boolean wasStopped) {
        if (wasStopped) {
            this.broadcastInfo("Reconnaissance scan stopped. Progress saved.");
        } else {
            this.broadcastSuccess("Reconnaissance complete! Starting final data refinement in background...");
        }
    }

    public void notifyRefinementFinished() {
        this.broadcastSuccess("Geo-scan complete! Database is fully optimized.");
        this.logInfo("Global refinement complete. GeoDatabase is now fully operational.");
    }

    private static /* synthetic */ Component lambda$sendSuccess$0(Component component) {
        return component;
    }
}

