/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev;

import java.io.File;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.landdev.LDN;
import net.fexcraft.mod.landdev.cmd.CkCmd;
import net.fexcraft.mod.landdev.cmd.CntCmd;
import net.fexcraft.mod.landdev.cmd.DebugCmd;
import net.fexcraft.mod.landdev.cmd.DisCmd;
import net.fexcraft.mod.landdev.cmd.LDCmd;
import net.fexcraft.mod.landdev.cmd.MunCmd;
import net.fexcraft.mod.landdev.cmd.RgCmd;
import net.fexcraft.mod.landdev.events.LocationUpdate;
import net.fexcraft.mod.landdev.util.AliasLoader;
import net.fexcraft.mod.landdev.util.GuiHandler;
import net.fexcraft.mod.landdev.util.PacketReceiver;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.impl.PacketTagHandler;
import net.fexcraft.mod.uni.packet.PacketTagListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="landdev", name="LandDev", version="1.x.x", dependencies="required-after:fcl", acceptedMinecraftVersions="*", acceptableRemoteVersions="*")
public class LandDev {
    public static final String NAME = "LandDev";
    public static final String VERSION = "1.x.x";
    @Mod.Instance(value="landdev")
    public static LandDev INSTANCE;
    public static File SAVE_DIR;
    public static final String PKT_RECEIVER_ID = "landdev:util";
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LDN.preinit(event.getModConfigurationDirectory());
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        if (event.getSide().isClient()) {
            UniFCL.regTagPacketListener((String)PKT_RECEIVER_ID, (boolean)true, (PacketTagListener)new PacketReceiver());
            MinecraftForge.EVENT_BUS.register((Object)new LocationUpdate());
        }
        LDN.init(this);
    }

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        LDN.postinit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        LDN.onServerStarting();
        AliasLoader.load();
        event.registerServerCommand((ICommand)new DebugCmd());
        event.registerServerCommand((ICommand)new LDCmd());
        event.registerServerCommand((ICommand)new CkCmd());
        event.registerServerCommand((ICommand)new DisCmd());
        event.registerServerCommand((ICommand)new MunCmd());
        event.registerServerCommand((ICommand)new CntCmd());
        event.registerServerCommand((ICommand)new RgCmd());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        LDN.onServerStarted();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        LDN.onServerStopping();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        LDN.onServerStop();
    }

    public static final File getSaveDirectory() {
        return SAVE_DIR;
    }

    public static void log(Object obj) {
        logger.log(Level.INFO, obj);
    }

    public static void debug(String s) {
        if (EnvInfo.DEV) {
            logger.log(Level.INFO, s);
        }
    }

    public static void sendLocationPacket(EntityW entity, TagCW com) {
        PacketHandler.getInstance().sendTo((IMessage)new PacketTagHandler.I12_PacketTag(PKT_RECEIVER_ID, com), (EntityPlayerMP)entity.local());
    }

    public static void sendToAll(TagCW com) {
        if (ResManager.INSTANCE.LOADED) {
            PacketHandler.getInstance().sendToAll((IMessage)new PacketTagHandler.I12_PacketTag(PKT_RECEIVER_ID, com));
        }
    }

    static {
        SAVE_DIR = new File("./landdev/");
    }
}

