/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.PermInteractive;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.util.ResManager;

public class Citizens
implements Saveable,
PermInteractive {
    protected LinkedHashMap<UUID, Citizen> citizens = new LinkedHashMap();
    protected PermAction.PermActions actions;

    public Citizens(PermAction.PermActions actions) {
        this.actions = actions;
    }

    @Override
    public void save(JsonMap map) {
        JsonMap sta = map.getMap("citizen");
        this.citizens.forEach((key, citizen) -> {
            JsonMap cit = new JsonMap();
            citizen.save(cit);
            sta.add(key.toString(), (JsonValue)cit);
        });
    }

    @Override
    public void load(JsonMap map) {
        if (!map.has("citizen")) {
            return;
        }
        this.citizens.clear();
        ((Map)map.getMap((String)"citizen").value).forEach((key, val) -> {
            Citizen cit = new Citizen(UUID.fromString(key), this.actions);
            cit.load(val.asMap());
            this.citizens.put(cit.uuid, cit);
        });
    }

    public boolean isCitizen(UUID uuid) {
        return this.citizens.get(uuid) != null;
    }

    public int size() {
        return this.citizens.size();
    }

    public Map<UUID, Citizen> map() {
        return this.citizens;
    }

    public int indexOf(UUID uuid) {
        int idx = 0;
        for (UUID uid : this.citizens.keySet()) {
            if (uuid.equals(uid)) {
                return idx;
            }
            ++idx;
        }
        return 0;
    }

    public Citizen get(int index) {
        int idx = 0;
        for (Citizen cit : this.citizens.values()) {
            if (idx == index) {
                return cit;
            }
            ++idx;
        }
        return null;
    }

    public Citizen get(UUID uuid) {
        return this.citizens.get(uuid);
    }

    public void clear(boolean mun) {
        ArrayList<UUID> citi = new ArrayList<UUID>(this.citizens.keySet());
        for (UUID uuid : citi) {
            LDPlayer player = ResManager.getPlayer(uuid, true);
            if (mun) {
                player.leaveMunicipality();
                continue;
            }
            player.leaveCounty();
        }
        this.citizens.clear();
    }

    public LinkedHashMap<UUID, Citizen> get() {
        return this.citizens;
    }

    @Override
    public boolean can(PermAction act, UUID uuid) {
        if (!this.actions.isValid(act)) {
            return false;
        }
        Citizen cit = this.citizens.get(uuid);
        return cit != null && cit.actions.get((Object)act) != false;
    }

    @Override
    public boolean can(UUID uuid, PermAction ... acts) {
        for (PermAction act : acts) {
            if (!this.actions.isValid(act)) continue;
            Citizen cit = this.citizens.get(uuid);
            if (!cit.actions.get((Object)act).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void remove(LDPlayer player) {
        this.citizens.remove(player.uuid);
    }

    public void remove(UUID uuid) {
        this.citizens.remove(uuid);
    }

    public void add(LDPlayer player) {
        this.citizens.put(player.uuid, new Citizen(player.uuid, this.actions));
    }

    public void add(UUID uuid) {
        this.citizens.put(uuid, new Citizen(uuid, this.actions));
    }

    public static class Citizen
    implements Saveable {
        public LinkedHashMap<PermAction, Boolean> actions = new LinkedHashMap();
        public final UUID uuid;

        public Citizen(UUID uiid, PermAction.PermActions pacts) {
            this.uuid = uiid;
            for (PermAction action : pacts.actions) {
                this.actions.put(action, false);
            }
        }

        @Override
        public void save(JsonMap map) {
            this.actions.forEach((key, val) -> map.add(key.name(), val.booleanValue()));
        }

        @Override
        public void load(JsonMap map) {
            map.entries().forEach(entry -> {
                PermAction act = PermAction.get((String)entry.getKey());
                if (this.actions.containsKey((Object)act)) {
                    this.actions.put(act, ((JsonValue)entry.getValue()).bool());
                }
            });
        }

        public String getPlayerName() {
            return ResManager.getPlayerName(this.uuid);
        }
    }
}

