/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.util.ResManager;

public class Createable
implements Saveable {
    private long created;
    private long updated;
    private UUID creator = ResManager.CONSOLE_UUID;
    private boolean chunk = false;

    public Createable() {
    }

    public Createable(boolean bool) {
        this.chunk = bool;
    }

    @Override
    public void load(JsonMap map) {
        this.created = map.getLongTime("created");
        if (map.has("creator")) {
            this.creator = UUID.fromString(map.get("creator").string_value());
        } else if (map.has("creator0")) {
            this.creator = new UUID(map.getLong("creator0", 0L), map.getLong("creator1", 0L));
        }
        this.updated = map.getLongTime("updated");
    }

    @Override
    public void save(JsonMap map) {
        map.add("created", this.created);
        if (!this.creator.equals(ResManager.CONSOLE_UUID)) {
            map.add("creator", this.creator.toString());
        }
        map.add("updated", this.updated);
    }

    public long getCreated() {
        return this.created;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public long getUpdated() {
        return this.created;
    }

    public void update(Long time) {
        this.updated = time == null ? Time.getDate() : time;
    }

    public void update() {
        this.update(null);
    }

    public void setClaimer(UUID uuid) {
        this.creator = uuid;
        this.update();
    }

    public UUID getClaimer() {
        return this.creator;
    }

    public void create(UUID uuid) {
        this.creator = uuid;
        this.created = this.updated = Time.getDate();
    }
}

