/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.chunk;

import net.fexcraft.lib.common.math.V3D;

public class ChunkKey
implements Comparable<ChunkKey> {
    public final int x;
    public final int z;

    public ChunkKey(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public ChunkKey(String string) {
        String[] split = string.contains("_") ? string.split("_") : string.split(",");
        this.x = Integer.parseInt(split[0].trim());
        this.z = Integer.parseInt(split[1].trim());
    }

    public ChunkKey(int x, int z, boolean reg) {
        this(reg ? (int)Math.floor(x / 32) : x, reg ? (int)Math.floor(z / 32) : z);
    }

    public ChunkKey(V3D pos) {
        this((int)pos.x >> 4, (int)pos.z >> 4);
    }

    public String toString() {
        return this.x + "_" + this.z;
    }

    public boolean equals(Object o) {
        if (o instanceof int[]) {
            int[] a = (int[])o;
            return a.length > 1 && this.x == a[0] && this.z == a[1];
        }
        if (o instanceof ChunkKey) {
            ChunkKey c = (ChunkKey)o;
            return this.x == c.x && this.z == c.z;
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(ChunkKey c) {
        if (c.x < this.x) {
            return -1;
        }
        if (c.x > this.x) {
            if (c.z < this.z) {
                return -1;
            }
            if (c.z > this.z) {
                return 1;
            }
        }
        return 0;
    }

    public String comma() {
        return this.x + ", " + this.z;
    }

    public ChunkKey asRegion() {
        return new ChunkKey(this.x, this.z, true);
    }

    public int hashCode() {
        return this.x * 31 + this.z;
    }
}

