/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.district;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.landdev.data.Citizens;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Manageable;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.util.ResManager;

public class DistrictOwner
implements Saveable {
    public Municipality municipality;
    public County county;
    public boolean is_county;
    public int owid;

    @Override
    public void save(JsonMap map) {
        map.add("county", this.is_county);
        map.add("owner", this.owid);
    }

    @Override
    public void load(JsonMap map) {
        this.is_county = map.getBoolean("county", this.is_county);
        this.owid = map.getInteger("owner", -1);
        if (this.is_county) {
            this.county = ResManager.getCounty(this.owid, true);
        } else {
            this.municipality = ResManager.getMunicipality(this.owid, true);
        }
    }

    public int county_id() {
        return this.is_county ? this.county.id : this.municipality.county.id;
    }

    public Manageable manageable() {
        return this.is_county ? this.county.manage : this.municipality.manage;
    }

    public String name() {
        return this.is_county ? this.county.name() : this.municipality.name();
    }

    public void set(Municipality mun) {
        this.is_county = false;
        this.county = null;
        this.municipality = mun;
        this.owid = this.municipality.id;
    }

    public void set(County ct) {
        this.is_county = true;
        this.county = ct;
        this.municipality = null;
        this.owid = this.county.id;
    }

    public boolean isPartOf(LDPlayer player) {
        if (this.is_county) {
            return player.county.id == this.owid;
        }
        return player.municipality.id == this.owid;
    }

    public Account account() {
        return this.is_county ? this.county.account : this.municipality.account;
    }

    public Citizens citizen() {
        return this.is_county ? this.county.citizens : this.municipality.citizens;
    }

    public Layers layer() {
        return this.is_county ? Layers.COUNTY : Layers.MUNICIPALITY;
    }

    public void addTaxStat(long tax) {
        if (this.is_county) {
            this.county.tax_collected += tax;
        } else {
            this.municipality.tax_collected += tax;
        }
    }
}

