/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.player;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.hooks.ExternalData;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.Permit;
import net.fexcraft.mod.landdev.event.JoinLayerEvent;
import net.fexcraft.mod.landdev.event.LDEvent;
import net.fexcraft.mod.landdev.event.LeaveLayerEvent;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;

public class LDPlayer
implements Saveable,
Layer,
LDUIModule,
Appendable<UniEntity> {
    public UUID uuid;
    public boolean offline = true;
    public boolean adm;
    public EntityW entity;
    public long joined;
    public long login;
    public long last_login;
    public long last_logout;
    public long last_pos_update;
    public long last_tax;
    public MailData mail;
    public String nickname;
    public String colorcode = "2";
    public Account account;
    public ArrayList<Permit> permits = new ArrayList();
    public Municipality municipality;
    public County county;
    public Chunk_ chunk_current;
    public Chunk_ chunk_last;
    public ExternalData external = new ExternalData(this);
    public static final int UI_NICKNAME = 1;

    public LDPlayer(UUID uuid) {
        this.uuid = uuid;
        this.mail = new MailData(Layers.PLAYER, uuid);
        this.account = DataManager.getAccount((String)("player:" + uuid.toString()), (boolean)false, (boolean)true);
    }

    @Override
    public void save(JsonMap map) {
        map.add("uuid", this.uuid.toString());
        map.add("joined", this.joined);
        map.add("last_login", this.login);
        map.add("last_logout", Time.getDate());
        this.mail.save(map);
        if (this.nickname != null) {
            map.add("nick-name", this.nickname);
        }
        if (this.colorcode != null) {
            map.add("color-code", this.colorcode);
        }
        if (this.permits.size() > 0) {
            JsonArray array = new JsonArray();
            this.permits.forEach(perm -> {
                JsonMap pmap = new JsonMap();
                perm.save(pmap);
                array.add((JsonValue)pmap);
            });
            map.add("permits", (JsonValue)array);
        }
        if (this.municipality.id >= 0 && this.county != this.municipality.county) {
            this.county = this.municipality.county;
        }
        map.add("municipality", this.municipality.id);
        map.add("county", this.county.id);
        map.add("last_tax", this.last_tax);
        this.external.save(this, map);
        DataManager.save((Account)this.account);
    }

    @Override
    public void load(JsonMap map) {
        this.joined = map.getLong("joined", Time.getDate());
        this.last_login = map.getLong("last_login", 0L);
        this.last_logout = map.getLong("last_logout", 0L);
        this.mail.load(map);
        this.nickname = map.getString("nick-name", this.nickname);
        this.colorcode = map.getString("color-code", this.colorcode);
        if (map.has("permits")) {
            ((List)map.get((String)"permits").asArray().value).forEach(elm -> {
                Permit perm = new Permit();
                perm.load(elm.asMap());
                if (!perm.expired()) {
                    this.permits.add(perm);
                }
            });
        }
        this.municipality = ResManager.getMunicipality(map.getInteger("municipality", -1), true);
        this.county = ResManager.getCounty(map.getInteger("county", -1), true);
        if (this.municipality.id >= 0 && this.county != this.municipality.county) {
            this.county = this.municipality.county;
        }
        this.last_tax = map.getLong("last_tax", 0L);
        this.external.load(this, map);
    }

    @Override
    public void gendef() {
        this.joined = Time.getDate();
        this.municipality = ResManager.getMunicipality(-1, true);
        this.county = ResManager.getCounty(-1, true);
        this.external.gendef(this);
    }

    @Override
    public String saveId() {
        return this.uuid.toString();
    }

    @Override
    public String saveTable() {
        return "players";
    }

    public boolean hasPermit(PermAction act, Layers layer, int id) {
        for (Permit perm : this.permits) {
            if (perm.action != act || perm.origin_layer != layer || perm.origin_id != id || perm.expired()) continue;
            return true;
        }
        return false;
    }

    public Permit getPermit(PermAction act, Layers layer, int id) {
        for (Permit perm : this.permits) {
            if (perm.action != act || perm.origin_layer != layer || perm.origin_id != id || perm.expired()) continue;
            return perm;
        }
        return null;
    }

    public WorldW world() {
        return this.entity.getWorld();
    }

    public boolean isInManagement(Layers layer) {
        if (layer == Layers.MUNICIPALITY) {
            return this.municipality.manage.isStaff(this.uuid) || this.municipality.manage.isManager(this.uuid);
        }
        if (layer == Layers.COUNTY) {
            return this.county.manage.isStaff(this.uuid) || this.county.manage.isManager(this.uuid);
        }
        if (layer == Layers.REGION) {
            return this.county.region.manage.isStaff(this.uuid) || this.county.region.manage.isManager(this.uuid);
        }
        return false;
    }

    public void sendLocationUpdate(boolean moved, boolean label, int time) {
        TagCW com = TagCW.create();
        com.set("task", "location_update");
        boolean mun = this.chunk_current.district.municipality() != null;
        TagLW icons = TagLW.create();
        icons.add(this.chunk_current.district.icon.getnn());
        if (mun) {
            icons.add(this.chunk_current.district.municipality().icon.getnn());
        }
        icons.add(this.chunk_current.district.county().icon.getnn());
        icons.add(this.chunk_current.district.region().icon.getnn());
        com.set("icons", icons);
        TagLW lines = TagLW.create();
        if (moved) {
            lines.add(this.chunk_current.district.region().name());
            lines.add(this.chunk_current.district.county().name());
            if (mun) {
                lines.add(this.chunk_current.district.municipality().name());
            }
            lines.add(this.chunk_current.district.name());
        }
        if (label) {
            lines.add(this.chunk_current.label.label);
        }
        com.set("lines", lines);
        if (time > 0) {
            com.set("time", time);
        }
        LandDev.sendLocationPacket(this.entity, com);
    }

    public String name() {
        return "&" + this.colorcode + (this.nickname == null ? (this.entity == null ? "<PEN>" : this.entity.getName()) : this.nickname);
    }

    public String name_raw() {
        return this.nickname == null ? (this.entity == null ? "<PEN>" : this.entity.getName()) : this.nickname;
    }

    @Override
    public Layers getLayer() {
        return Layers.PLAYER;
    }

    @Override
    public Layers getParentLayer() {
        return null;
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("player.title");
        switch (container.pos.x) {
            case 0: {
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.uuid);
                resp.addRow("name", LDUIRow.ELM_GENERIC, this.entity.getName());
                resp.addButton("nick", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.nickname == null ? "" : this.nickname);
                resp.addButton("color", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.colorcode == null ? "" : this.colorcode);
                resp.addBlank();
                resp.addButton("company", LDUIRow.ELM_GENERIC, LDUIButton.EMPTY, "W-I-P");
                if (this.municipality.id > -1) {
                    resp.addButton("municipality", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.municipality.name());
                }
                resp.addButton("county", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.county.name());
                resp.addButton("region", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.county.region.name());
                break;
            }
            case 1: {
                resp.setTitle("player.appearance.title");
                resp.addRow("appearance.nick", LDUIRow.ELM_GENERIC);
                resp.addField("appearance.nick_field", this.nickname == null ? "" : this.nickname);
                resp.addRow("appearance.color", LDUIRow.ELM_GENERIC);
                resp.addField("appearance.color_field", this.colorcode == null ? "" : this.colorcode);
                resp.addButton("appearance.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
                resp.setFormular();
            }
        }
        this.external.sync_packet(container, resp);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        switch (req.event()) {
            case "nick": 
            case "color": {
                container.open(1);
                break;
            }
            case "company": {
                break;
            }
            case "municipality": {
                if (this.municipality.id <= -1) break;
                container.open(LDKeys.MUNICIPALITY, 0, this.municipality.id, 0);
                break;
            }
            case "county": {
                container.open(LDKeys.COUNTY, 0, this.county.id, 0);
                break;
            }
            case "region": {
                container.open(LDKeys.REGION, 0, this.county.region.id, 0);
                break;
            }
            case "appearance.submit": {
                char c;
                String nick = req.getField("appearance.nick_field");
                if (nick.length() == 0 || nick.length() > 16) break;
                this.nickname = nick;
                String color = req.getField("appearance.color_field");
                if (color.length() > 0 && ((c = color.charAt(0)) >= '0' && c <= '9' || c >= 'a' && c <= 'f')) {
                    this.colorcode = c + "";
                }
                this.save();
                container.open(0);
                break;
            }
        }
        this.external.on_interact(container, req);
    }

    public boolean isCurrentlyInDistrict(int id) {
        return this.chunk_current != null && this.chunk_current.district.id == id;
    }

    public boolean isCurrentlyInMunicipality(int id) {
        return this.chunk_current != null && !this.chunk_current.district.owner.is_county && this.chunk_current.district.municipality().id == id;
    }

    public boolean isCurrentlyInCounty(int id) {
        return this.chunk_current != null && this.chunk_current.district.county().id == id;
    }

    public boolean isCurrentlyInRegion(int id) {
        return this.chunk_current != null && this.chunk_current.district.region().id == id;
    }

    public void addMail(Mail newmail) {
        this.mail.add(newmail);
        if (this.entity != null && this.mail.unread() > 0) {
            this.entity.send("landdev.mail.player.new");
        }
    }

    public void addMailAndSave(Mail newmail) {
        this.addMail(newmail);
        this.save();
    }

    public boolean isMunicipalityManager() {
        return this.municipality.manage.isManager(this.uuid);
    }

    public boolean isCountyManager() {
        return this.county.manage.isManager(this.uuid);
    }

    public void setCitizenOf(Municipality mun) {
        this.municipality.manage.removeStaff(this.uuid);
        this.municipality.citizens.remove(this);
        LDEvent.run(new LeaveLayerEvent(this.municipality, this));
        if (mun.county.id != this.county.id) {
            this.county.manage.removeStaff(this.uuid);
            this.county.citizens.remove(this);
            LDEvent.run(new LeaveLayerEvent(this.county, this));
        }
        this.municipality = mun;
        this.municipality.citizens.add(this);
        LDEvent.run(new JoinLayerEvent(this.municipality, this));
        if (mun.county.id != this.county.id) {
            this.county = mun.county;
            this.county.citizens.add(this);
            LDEvent.run(new JoinLayerEvent(this.county, this));
        }
    }

    public void setCitizenOf(County ncounty) {
        if (this.municipality.id >= 0 && this.municipality.county.id != ncounty.id) {
            this.municipality.manage.removeStaff(this.uuid);
            this.municipality.citizens.remove(this);
            LDEvent.run(new LeaveLayerEvent(this.municipality, this));
            this.municipality = ResManager.getMunicipality(-1, true);
        }
        if (ncounty.id != this.county.id) {
            this.county.manage.removeStaff(this.uuid);
            this.county.citizens.remove(this);
            LDEvent.run(new LeaveLayerEvent(this.county, this));
        }
        this.county = ncounty;
        this.county.citizens.add(this);
        LDEvent.run(new JoinLayerEvent(this.county, this));
    }

    public void leaveMunicipality() {
        this.municipality.manage.removeStaff(this.uuid);
        this.municipality.citizens.remove(this);
        this.municipality = ResManager.getMunicipality(-1, true);
        LDEvent.run(new LeaveLayerEvent(this.municipality, this));
    }

    public void leaveCounty() {
        this.county.manage.removeStaff(this.uuid);
        this.county.citizens.remove(this);
        this.county = ResManager.getCounty(-1, true);
        LDEvent.run(new LeaveLayerEvent(this.county, this));
    }

    public Appendable<UniEntity> create(UniEntity type) {
        return new LDPlayer((UUID)type.entity.local());
    }

    public String id() {
        return "landdev:player";
    }
}

