/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.db;

import java.io.File;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.db.Database;
import net.fexcraft.mod.landdev.util.LDConfig;

public class JsonFileDB
implements Database {
    @Override
    public void save(Saveable type) {
        File file = new File(LandDev.SAVE_DIR, type.saveTable() + "/" + type.saveId() + ".json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        JsonMap map = new JsonMap();
        type.save(map);
        JsonHandler.print((File)file, (JsonValue)map, (JsonHandler.PrintOption)(LDConfig.SAVE_SPACED_JSON ? JsonHandler.PrintOption.SPACED : JsonHandler.PrintOption.FLAT));
    }

    public JsonMap load(String table, String id) {
        File file = new File(LandDev.SAVE_DIR, table + "/" + id + ".json");
        return file.exists() ? JsonHandler.parse((File)file) : new JsonMap();
    }

    @Override
    public boolean exists(String table, String id) {
        if (table.equals("chunks")) {
            return true;
        }
        return new File(LandDev.SAVE_DIR, table + "/" + id + ".json").exists();
    }

    @Override
    public boolean internal() {
        return true;
    }

    @Override
    public int getNewEntryId(String table) {
        File file = new File(LandDev.SAVE_DIR, table + "/");
        int i = 1;
        while (new File(file, i + ".json").exists()) {
            ++i;
        }
        return i;
    }
}

