/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.dynmap;

import java.io.IOException;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.util.ResManager;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class LandDevShader
implements HDShader {
    private String name;
    private Layers layer;

    public LandDevShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get((Object)"name");
        this.layer = Layers.valueOf(((String)configuration.get((Object)"layer")).toUpperCase());
    }

    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new ShaderState(this, mapiter, map, cache, scale);
    }

    public boolean isBiomeDataNeeded() {
        return false;
    }

    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s((JSONObject)mapObject, (String)"shader", (Object)this.name);
    }

    public void exportAsMaterialLibrary(DynmapCommandSender dynmapCommandSender, OBJExport objExport) throws IOException {
    }

    public String[] getCurrentBlockMaterials(DynmapBlockState dynmapBlockState, MapIterator mapIterator, int[] ints, BlockStep[] blockSteps) {
        return new String[0];
    }

    private static class ShaderState
    implements HDShaderState {
        private Color[] colors = new Color[]{new Color()};
        private Color color = new Color();
        protected HDMap map;
        private HDLighting lighting;
        final int[] table;
        private RGB rgb = new RGB();
        private LandDevShader shader;
        private MapIterator mapi;

        private ShaderState(LandDevShader ldshader, MapIterator mapiter, HDMap hdmap, MapChunkCache cache, int scale) {
            this.map = hdmap;
            this.mapi = mapiter;
            this.shader = ldshader;
            this.lighting = this.map.getLighting();
            this.table = MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null;
        }

        public HDShader getShader() {
            return this.shader;
        }

        public HDMap getMap() {
            return this.map;
        }

        public HDLighting getLighting() {
            return this.lighting;
        }

        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i].setTransparent();
            }
        }

        public boolean processBlock(HDPerspectiveState ps) {
            Chunk_ ck = ResManager.getChunkS(this.mapi.getX(), this.mapi.getZ());
            this.rgb.packed = this.getLayerColor(ck);
            byte[] arr = this.rgb.toByteArray();
            if (this.isNotSameLayer(ck, this.mapi.getX(), this.mapi.getZ())) {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (byte)((double)arr[i] * 0.5);
                }
            }
            this.color.setRGBA(arr[0] + 128, arr[1] + 128, arr[2] + 128, 255);
            this.lighting.applyLighting(ps, (HDShaderState)this, this.color, this.colors);
            return true;
        }

        private int getLayerColor(Chunk_ ck) {
            if (ck == null) {
                return RGB.BLACK.packed;
            }
            switch (this.shader.layer) {
                case COMPANY: {
                    this.rgb.packed = RGB.BLUE.packed;
                    return this.rgb.packed;
                }
                case DISTRICT: {
                    this.rgb.packed = ck.district.color.getInteger();
                    return this.rgb.packed;
                }
                case MUNICIPALITY: {
                    if (ck.district.municipality() == null) {
                        this.rgb.packed = ResManager.getMunicipality((int)-1, (boolean)true).color.getInteger();
                        return this.rgb.packed;
                    }
                    this.rgb.packed = ck.district.municipality().color.getInteger();
                    return this.rgb.packed;
                }
                case COUNTY: {
                    this.rgb.packed = ck.district.county().color.getInteger();
                    return this.rgb.packed;
                }
                case REGION: {
                    this.rgb.packed = ck.district.region().color.getInteger();
                    return this.rgb.packed;
                }
                case INTER: {
                    this.rgb.packed = RGB.RED.packed;
                    return this.rgb.packed;
                }
            }
            this.rgb.packed = RGB.WHITE.packed;
            return this.rgb.packed;
        }

        private boolean isNotSameLayer(Chunk_ ck, int ox, int oz) {
            if (ck == null) {
                return false;
            }
            boolean bool = false;
            if (ox < 0) {
                if (ox % -16 == 0 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x - 1, ck.key.z))) {
                    bool = true;
                }
                if (ox % -16 == -1 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x + 1, ck.key.z))) {
                    bool = true;
                }
            } else {
                if (ox % 16 == 0 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x - 1, ck.key.z))) {
                    bool = true;
                }
                if (ox % 16 == 15 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x + 1, ck.key.z))) {
                    bool = true;
                }
            }
            if (oz < 0) {
                if (oz % -16 == 0 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x, ck.key.z - 1))) {
                    bool = true;
                }
                if (oz % -16 == -1 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x, ck.key.z + 1))) {
                    bool = true;
                }
            } else {
                if (oz % 16 == 0 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x, ck.key.z - 1))) {
                    bool = true;
                }
                if (oz % 16 == 15 && this.isNotSameLayer(ck, ResManager.getChunk(ck.key.x, ck.key.z + 1))) {
                    bool = true;
                }
            }
            return bool;
        }

        private boolean isNotSameLayer(Chunk_ ck, Chunk_ ock) {
            if (ock == null) {
                return false;
            }
            switch (this.shader.layer) {
                case COMPANY: {
                    return false;
                }
                case DISTRICT: {
                    return ck.district.id != ock.district.id;
                }
                case MUNICIPALITY: {
                    if (ck.district.municipality() == null && ock.district.municipality() == null) {
                        return false;
                    }
                    if (ck.district.municipality() == null && ock.district.municipality() != null) {
                        return true;
                    }
                    if (ck.district.municipality() != null && ock.district.municipality() == null) {
                        return true;
                    }
                    return ck.district.municipality().id != ock.district.municipality().id;
                }
                case COUNTY: {
                    return ck.district.county().id != ock.district.county().id;
                }
                case REGION: {
                    return ck.district.region().id != ock.district.region().id;
                }
            }
            return false;
        }

        public void rayFinished(HDPerspectiveState ps) {
        }

        public void getRayColor(Color color, int index) {
            color.setColor(this.colors[index]);
        }

        public void cleanup() {
        }

        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        public int[] getLightingTable() {
            return this.table;
        }

        public void setLastBlockState(DynmapBlockState dbs) {
        }
    }
}

