/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui;

import java.util.HashMap;
import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.chunk.ChunkType;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.ui.ChunkClaimUI;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;
import net.fexcraft.mod.uni.world.MessageSender;

public class ChunkClaimCon
extends ContainerInterface {
    protected ChunkData[][] chunks = new ChunkData[15][15];
    protected HashMap<Integer, DisData> dists = new HashMap();
    protected ChunkClaimUI cui;
    protected District district;
    protected LDPlayer ldp;
    protected UUID uuid;
    protected Mode mode;
    protected int prix;

    public ChunkClaimCon(JsonMap map, UniEntity ply, V3I pos) {
        super(map, ply, pos);
        this.ldp = ResManager.getPlayer(ply);
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int k = 0; k < this.chunks[i].length; ++k) {
                this.chunks[i][k] = new ChunkData();
            }
        }
    }

    public ContainerInterface set(UserInterface ui) {
        this.cui = (ChunkClaimUI)ui;
        return super.set(ui);
    }

    public void init() {
        this.mode = Mode.fromKey(this.uiid);
        this.uuid = this.player.entity.getUUID();
        if (!this.player.entity.isOnClient()) {
            if (this.mode != Mode.SELL && (this.mode != Mode.BUY || this.pos.y >= 0)) {
                this.district = ResManager.getDistrict(this.pos.y);
            }
            if (this.mode == Mode.SELL) {
                this.district = this.ldp.chunk_current.district;
            }
        }
        this.prix = this.pos.y;
    }

    public void packet(TagCW pkt, boolean client) {
        if (client) {
            if (pkt.has("ckdata")) {
                TagLW list = pkt.getList("cks");
                for (int i = 0; i < 15; ++i) {
                    for (int k = 0; k < 15; ++k) {
                        this.chunks[i][k] = new ChunkData(list.getCompound(k + i * 15), i - 7 + this.pos.x, k - 7 + this.pos.z);
                    }
                }
                this.dists.clear();
                list = pkt.getList("dis");
                list.forEach(tag -> this.dists.put(tag.getInteger("i"), new DisData((TagCW)tag)));
            }
            if (pkt.has("msg")) {
                ((UIText)this.cui.texts.get("title")).value(pkt.getString("msg"));
                ((UIText)this.cui.texts.get("title")).translate();
            }
        } else if (pkt.has("sync")) {
            this.sendSync(TagCW.create());
        } else if (pkt.has("claim")) {
            int[] key = pkt.getIntArray("claim");
            Chunk_ chunk = ResManager.getChunk(key[0] - 7 + this.pos.x, key[1] - 7 + this.pos.z);
            if (chunk == null) {
                return;
            }
            TagCW com = TagCW.create();
            if (!this.ldp.adm && this.mode.claimtrans() && !this.adjacent(chunk, this.district)) {
                this.sendMsg(com, "landdev.gui.claim.not_adjacent");
                return;
            }
            if (!this.ldp.adm && chunk.locked()) {
                this.sendMsg(com, "landdev.gui.claim.locked");
                return;
            }
            if (this.mode == Mode.CLAIM) {
                long price;
                if (chunk.district.id > -1) {
                    this.sendMsg(com, "landdev.gui.claim.already_claimed");
                    return;
                }
                if (this.isNotClaimable(chunk, this.district, com)) {
                    return;
                }
                long l = price = chunk.sell.price > 0L ? chunk.sell.price : LDConfig.DEFAULT_CHUNK_PRICE;
                if (price > 0L && !this.district.owner.account().getBank().processAction(Bank.Action.TRANSFER, (MessageSender)this.player.entity, this.district.account(), price, ResManager.SERVER_ACCOUNT)) {
                    return;
                }
                com.set("msg", "landdev.gui.claim.pass");
                if (chunk.district.id < 0) {
                    chunk.created.setClaimer(this.player.entity.getUUID());
                }
                if (chunk.district.id > -1) {
                    --chunk.district.chunks;
                }
                chunk.district = this.district;
                ++chunk.district.chunks;
                chunk.sell.price = 0L;
                chunk.type = ChunkType.NORMAL;
                chunk.save();
            } else if (this.mode == Mode.TRANSFER) {
                if (chunk.district.id < 0) {
                    this.sendMsg(com, "landdev.gui.claim.not_claimed");
                    return;
                }
                if (this.isNotTransferable(chunk, this.district, com)) {
                    return;
                }
                com.set("msg", "landdev.gui.claim.transferred");
                if (chunk.district.id > -1) {
                    --chunk.district.chunks;
                }
                chunk.district = this.district;
                ++chunk.district.chunks;
                chunk.owner.set(this.district.owner.is_county ? Layers.COUNTY : Layers.MUNICIPALITY, null, this.district.owner.owid);
                chunk.save();
            } else if (this.mode == Mode.SELL) {
                if (this.isNotOwner(chunk, this.district, com)) {
                    return;
                }
                com.set("msg", "landdev.gui.claim.price_set");
                chunk.sell.price = this.prix;
                chunk.save();
            } else if (this.mode == Mode.BUY) {
                Account account;
                Layers layer;
                if (this.canNotBuy(chunk, this.district, com)) {
                    return;
                }
                Layers layers = this.prix < 0 ? (this.prix == -1 ? Layers.PLAYER : (this.prix < -2 ? Layers.REGION : Layers.COMPANY)) : (layer = this.district.owner.layer());
                if (!layer.isValidChunkOwner()) {
                    return;
                }
                if (layer.is(Layers.MUNICIPALITY) && this.district.owner.is_county) {
                    this.sendMsg(com, "landdev.district.not_part_of_municipality");
                    return;
                }
                Object object = this.prix < 0 ? (this.prix == -1 ? this.ldp.account : (this.prix < -2 ? this.district.region().account : null)) : (account = this.district.owner.account());
                if (account == null) {
                    return;
                }
                if (account.getBalance() < chunk.sell.price) {
                    this.sendMsg(com, "landdev.gui.chunk.buy.notenoughmoney");
                    return;
                }
                if (!account.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)this.ldp.entity, account, chunk.sell.price, chunk.owner.getAccount(chunk))) {
                    return;
                }
                com.set("msg", "landdev.gui.claim.bought");
                if (layer.is(Layers.PLAYER)) {
                    chunk.owner.set(layer, this.uuid, 0);
                } else if (!layer.is(Layers.COMPANY)) {
                    if (layer.is(Layers.REGION)) {
                        chunk.owner.set(layer, null, this.prix);
                    } else {
                        chunk.owner.set(layer, null, this.district.getLayerId(layer));
                    }
                }
                chunk.sell.price = 0L;
                chunk.save();
            } else if (this.mode == Mode.LOCK) {
                if (!this.ldp.adm) {
                    return;
                }
                chunk.locked = !chunk.locked;
                chunk.save();
            }
            this.sendSync(com);
        }
    }

    private void sendMsg(TagCW com, String str) {
        com.set("msg", str);
        SEND_TO_CLIENT.accept(com, this.player);
    }

    private boolean adjacent(Chunk_ chunk, District district) {
        Chunk_ o = ResManager.getChunk(chunk.key.x - 1, chunk.key.z);
        if (o.district.id == district.id) {
            return true;
        }
        o = ResManager.getChunk(chunk.key.x + 1, chunk.key.z);
        if (o.district.id == district.id) {
            return true;
        }
        o = ResManager.getChunk(chunk.key.x, chunk.key.z - 1);
        if (o.district.id == district.id) {
            return true;
        }
        o = ResManager.getChunk(chunk.key.x, chunk.key.z + 1);
        return o.district.id == district.id;
    }

    private boolean sameDistrict(Chunk_ chunk, District district, TagCW com) {
        if (chunk.district.id == district.id) {
            com.set("msg", "landdev.gui.claim.part_of_district");
            SEND_TO_CLIENT.accept(com, this.player);
            return true;
        }
        return false;
    }

    private boolean isNotClaimable(Chunk_ chunk, District district, TagCW com) {
        if (this.sameDistrict(chunk, district, com)) {
            return true;
        }
        if (!this.ldp.adm && !district.can(PermAction.CHUNK_CLAIM, this.uuid)) {
            this.sendMsg(com, "landdev.gui.claim.no_perm_district");
            return true;
        }
        return false;
    }

    private boolean isNotTransferable(Chunk_ chunk, District district, TagCW com) {
        if (this.sameDistrict(chunk, district, com)) {
            return true;
        }
        if (chunk.district.region().id != district.region().id) {
            this.sendMsg(com, "landdev.gui.claim.transfer.not_same_region");
            return true;
        }
        if (!this.ldp.adm && !chunk.district.can(PermAction.MANAGE_DISTRICT, this.uuid)) {
            this.sendMsg(com, "landdev.gui.claim.transfer.no_perm_district");
            return true;
        }
        return false;
    }

    private boolean isNotOwner(Chunk_ chunk, District district, TagCW com) {
        if (chunk.owner.playerchunk && !chunk.owner.player.equals(this.uuid)) {
            this.sendMsg(com, "landdev.gui.claim.sell.not_owner");
            return true;
        }
        if (!chunk.owner.playerchunk) {
            if (!chunk.owner.owner.is(district.owner.layer())) {
                this.sendMsg(com, "landdev.gui.claim.sell.not_owner");
                return true;
            }
            if (!this.ldp.adm && !chunk.district.can(PermAction.MANAGE_DISTRICT, this.uuid)) {
                this.sendMsg(com, "landdev.gui.claim.sell.no_perm");
                return true;
            }
        }
        return false;
    }

    private boolean canNotBuy(Chunk_ chunk, District district, TagCW com) {
        if (chunk.sell.price == 0L && chunk.district.id >= 0) {
            this.sendMsg(com, "landdev.gui.claim.buy.not_for_sale");
            return true;
        }
        if (this.prix < 0) {
            if (this.prix <= -2) {
                return true;
            }
        } else {
            if (chunk.district.county() != district.county()) {
                this.sendMsg(com, "landdev.gui.claim.buy.other_county");
                return true;
            }
            if (chunk.district.owner.is_county) {
                if (!district.owner.is_county) {
                    this.sendMsg(com, "landdev.gui.claim.buy.in_county");
                    return true;
                }
            } else if (!district.owner.is_county && chunk.district.municipality().id != district.municipality().id) {
                this.sendMsg(com, "landdev.gui.claim.buy.other_municipality");
                return true;
            }
        }
        return false;
    }

    private void sendSync(TagCW compound) {
        TagCW com;
        compound.set("ckdata", true);
        TagLW list = TagLW.create();
        HashMap<Integer, District> dis = new HashMap<Integer, District>();
        Chunk_ chunk = null;
        int di = -1;
        for (int i = -7; i < 8; ++i) {
            for (int k = -7; k < 8; ++k) {
                chunk = ResManager.getChunk(this.pos.x + i, this.pos.z + k);
                com = TagCW.create();
                if (chunk == null) {
                    di = -10;
                    com.set("d", -10);
                    com.set("c", 0xFFFFFF);
                    com.set("p", 0);
                } else {
                    di = chunk.district.id;
                    com.set("d", di);
                    if (this.mode.lock()) {
                        com.set("c", chunk.locked ? 15417396 : 3319890);
                    } else {
                        com.set("c", chunk.district.color.getInteger());
                    }
                    com.set("p", chunk.sell.price == 0L && chunk.district.id == -1 ? LDConfig.DEFAULT_CHUNK_PRICE : chunk.sell.price);
                    if (chunk.locked) {
                        com.set("l", true);
                    }
                }
                list.add(com);
                if (dis.containsKey(di) || di == -10) continue;
                dis.put(di, ResManager.getDistrict(di));
            }
        }
        compound.set("cks", list);
        list = TagLW.create();
        for (District d : dis.values()) {
            com = TagCW.create();
            com.set("i", d.id);
            com.set("n", d.name());
            com.set("o", d.owner.owid);
            com.set("m", d.owner.name());
            com.set("c", d.owner.is_county);
            list.add(com);
        }
        if (dis.containsKey(-10)) {
            TagCW com2 = TagCW.create();
            com2.set("i", -10);
            com2.set("n", "not loaded");
            com2.set("o", -10);
            com2.set("m", "Void");
            com2.set("c", true);
            list.add(com2);
        }
        compound.set("dis", list);
        SEND_TO_CLIENT.accept(compound, this.player);
    }

    public static enum Mode {
        CLAIM,
        TRANSFER,
        SELL,
        BUY,
        LOCK;


        public static Mode fromKey(UIKey key) {
            switch (key.id) {
                case 100: {
                    return CLAIM;
                }
                case 101: {
                    return TRANSFER;
                }
                case 102: {
                    return SELL;
                }
                case 103: {
                    return BUY;
                }
                case 104: {
                    return LOCK;
                }
            }
            return CLAIM;
        }

        public boolean claimtrans() {
            return this == CLAIM || this == TRANSFER;
        }

        public boolean lock() {
            return this == LOCK;
        }
    }

    public static class DisData {
        protected int id;
        protected int cid;
        protected String name;
        protected String cname;
        protected boolean county;

        public DisData(TagCW com) {
            this.id = com.getInteger("i");
            this.name = com.getString("n");
            this.cid = com.getInteger("o");
            this.cname = com.getString("m");
            this.county = com.getBoolean("c");
        }
    }

    public static class ChunkData {
        protected RGB color = new RGB();
        protected long price;
        protected int dis;
        protected int x;
        protected int z;
        protected boolean locked;

        public ChunkData(TagCW com, int x, int z) {
            this.color.packed = com.getInteger("c");
            this.dis = com.getInteger("d");
            this.price = com.getLong("p");
            this.locked = com.getBoolean("l");
            this.x = x;
            this.z = z;
        }

        public ChunkData() {
        }
    }
}

