/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.ui.ChunkClaimCon;
import net.fexcraft.mod.landdev.util.ClaimMapTexture;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIElement;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ChunkClaimUI
extends UserInterface {
    protected ChunkClaimCon con;
    private static final IDL TEXTURE = IDLManager.getIDLCached((String)"landdev:textures/ui/claim.png");
    private static UIButton[][] ckbuttons = new UIButton[15][15];
    private static Integer lx;
    private static Integer lz;
    private boolean gridview = true;
    private boolean mapgrid = true;
    private boolean deltex;

    public ChunkClaimUI(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.con = (ChunkClaimCon)container;
        ChunkKey key = new ChunkKey(this.con.player.entity.getPos());
        if (lx != null && (key.x != lx || key.z != lz)) {
            this.deltex = true;
        }
        lx = key.x;
        lz = key.z;
    }

    public void init() {
        TagCW com = TagCW.create();
        com.set("sync", true);
        ContainerInterface.SEND_TO_SERVER.accept(com);
        JsonMap empty = new JsonMap();
        try {
            for (int i = 0; i < 15; ++i) {
                for (int k = 0; k < 15; ++k) {
                    UIButton button = (UIButton)UIElement.create((Class)UIButton.IMPLEMENTATION, (UserInterface)this, (JsonMap)empty);
                    button.tx = button.htx = 6 + i * 14;
                    button.x = button.htx;
                    button.ty = button.hty = 20 + k * 14;
                    button.y = button.hty;
                    button.height = 12;
                    button.width = 12;
                    ((UITab)this.tabs.get((Object)"main")).buttons.put("ck_" + i + "_" + k, button);
                    this.buttons.put("ck_" + i + "_" + k, button);
                    ChunkClaimUI.ckbuttons[i][k] = button;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((UIText)this.texts.get("title")).translate();
    }

    public void predraw(float ticks, int mx, int my) {
    }

    public void postdraw(float ticks, int mx, int my) {
        if (!this.gridview) {
            int k;
            int i;
            if (this.mapgrid) {
                for (i = 0; i < this.con.chunks.length; ++i) {
                    for (k = 0; k < this.con.chunks[i].length; ++k) {
                        this.drawer.apply(this.con.chunks[i][k].color);
                        this.drawer.draw((float)(this.gLeft + 5 + i * 14), (float)(this.gTop + 19 + k * 14), 240, 240, 14, 14);
                        this.drawer.applyWhite();
                    }
                }
            }
            ClaimMapTexture.bind(this, lx, lz);
            for (i = 0; i < this.con.chunks.length; ++i) {
                for (k = 0; k < this.con.chunks[i].length; ++k) {
                    this.drawer.draw((float)(this.gLeft + 6 + i * 14), (float)(this.gTop + 20 + k * 14), i * 16, k * 16, 12, 12);
                }
            }
        } else {
            for (int i = 0; i < this.con.chunks.length; ++i) {
                for (int k = 0; k < this.con.chunks[i].length; ++k) {
                    this.drawer.apply(this.con.chunks[i][k].color);
                    this.drawer.draw((float)(this.gLeft + 6 + i * 14), (float)(this.gTop + 20 + k * 14), 6, 20, 12, 12);
                    this.drawer.applyWhite();
                }
            }
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.startsWith("ck_")) {
            String[] arr = id.split("_");
            int cx = Integer.parseInt(arr[1]);
            int cz = Integer.parseInt(arr[2]);
            TagCW compound = TagCW.create();
            compound.set("claim", new int[]{cx, cz});
            ContainerInterface.SEND_TO_SERVER.accept(compound);
            return true;
        }
        switch (id) {
            case "map": {
                if (this.deltex) {
                    ClaimMapTexture.delete();
                    this.deltex = false;
                }
                this.gridview = false;
                return true;
            }
            case "grid": {
                this.gridview = true;
                return true;
            }
            case "map_grid": {
                this.mapgrid = !this.mapgrid;
                return true;
            }
        }
        return false;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        for (int i = 0; i < 15; ++i) {
            for (int k = 0; k < 15; ++k) {
                ChunkClaimCon.DisData dis;
                if (!ckbuttons[i][k].hovered()) continue;
                ChunkClaimCon.ChunkData ck = this.con.chunks[i][k];
                list.add(ContainerInterface.transformat((String)"landdev.gui.claim.chunk_coord", (Object[])new Object[]{ck.x, ck.z}));
                if (ck.price > 0L) {
                    list.add(ContainerInterface.transformat((String)"landdev.gui.claim.chunk_price", (Object[])new Object[]{Config.getWorthAsString((long)ck.price)}));
                }
                if ((dis = this.con.dists.get(ck.dis)) == null) {
                    return;
                }
                list.add(ContainerInterface.transformat((String)"landdev.gui.claim.district", (Object[])new Object[]{dis.name + " (" + dis.id + ")"}));
                list.add(ContainerInterface.transformat((String)("landdev.gui.claim." + (dis.county ? "county" : "municipality")), (Object[])new Object[]{dis.cname + " (" + dis.cid + ")"}));
                if (!ck.locked) continue;
                list.add(ContainerInterface.transformat((String)"landdev.gui.claim.locked", (Object[])new Object[0]));
            }
        }
        if (((UIText)this.texts.get("title")).hovered()) {
            list.add(((UIText)this.texts.get("title")).value());
        }
        if (((UIButton)this.buttons.get("grid")).hovered()) {
            list.add(ContainerInterface.translate((String)"landdev.gui.claim.gridmode"));
        }
        if (((UIButton)this.buttons.get("map")).hovered()) {
            list.add(ContainerInterface.translate((String)"landdev.gui.claim.mapmode"));
        }
        if (((UIButton)this.buttons.get("map_grid")).hovered()) {
            list.add(ContainerInterface.translate((String)"landdev.gui.claim.mapgrid"));
        }
    }
}

