/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui;

import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.MailboxUI;
import net.fexcraft.mod.landdev.ui.modules.MailModule;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UserInterface;

public class MailboxCon
extends ContainerInterface {
    protected MailData mailbox;
    public MailboxUI mui;
    private LDPlayer ldp;

    public MailboxCon(JsonMap map, UniEntity ply, V3I pos) {
        super(map, ply, pos);
        if (ply.entity.isOnClient()) {
            return;
        }
        this.ldp = ResManager.getPlayer(ply);
        this.mailbox = MailModule.getMailbox(this.ldp, pos.x, pos.y);
    }

    public ContainerInterface set(UserInterface ui) {
        this.mui = (MailboxUI)ui;
        return super.set(ui);
    }

    public void packet(TagCW com, boolean client) {
        if (client) {
            if (com.has("mails")) {
                JsonMap map = JsonHandler.parse((String)com.getString("mails"), (boolean)true).asMap();
                this.mailbox = new MailData(Layers.values()[this.pos.x], "client");
                this.mailbox.load(map);
            }
        } else if (com.getBoolean("sync")) {
            this.sendSync();
        } else if (com.has("read")) {
            this.mailbox.mails.get((int)com.getInteger((String)"read")).unread = false;
            this.ldp.entity.openUI(LDKeys.MAIL, this.pos.x, this.pos.y, com.getInteger("read"));
        } else if (com.has("delete")) {
            if (!MailModule.canDelete(this.ldp, this.pos.x, this.pos.y)) {
                return;
            }
            this.mailbox.mails.remove(com.getInteger("delete"));
            this.sendSync();
        }
    }

    private void sendSync() {
        JsonMap map = new JsonMap();
        this.mailbox.save(map);
        TagCW sync = TagCW.create();
        sync.set("mails", JsonHandler.toString((JsonValue)map, (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT));
        SEND_TO_CLIENT.accept(sync, this.player);
    }
}

