/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui.modules;

import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.util.ResManager;

public class MainModule
implements LDUIModule {
    public static MainModule INST = new MainModule();

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("main.title");
        resp.addButton("player", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("mail", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("property", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("company", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addBlank();
        resp.addButton("chunk", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("district", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("municipality", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("county", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
        resp.addButton("region", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        Chunk_ chunk = ResManager.getChunk(container.pos.y, container.pos.z);
        switch (req.event()) {
            case "player": {
                container.open(LDKeys.PLAYER, 0, 0, 0);
                return;
            }
            case "mail": {
                container.open(LDKeys.MAILBOX, Layers.PLAYER.ordinal(), 0, 0);
                return;
            }
            case "property": {
                container.open(LDKeys.PROPERTY, 0, 0, 0);
                return;
            }
            case "company": {
                container.open(LDKeys.COMPANY, 0, 0, 0);
                return;
            }
            case "chunk": {
                container.open(LDKeys.CHUNK, 0, chunk.key.x, chunk.key.z);
                return;
            }
            case "district": {
                container.open(LDKeys.DISTRICT, 0, chunk.district.id, 0);
                return;
            }
            case "municipality": {
                if (!chunk.district.owner.is_county) {
                    container.open(LDKeys.MUNICIPALITY, 0, chunk.district.owner.municipality.id, 0);
                } else {
                    container.player.entity.send("landdev.district.not_part_of_municipality");
                    container.player.entity.closeUI();
                }
                return;
            }
            case "county": {
                container.open(LDKeys.COUNTY, 0, chunk.district.owner.county_id(), 0);
                return;
            }
            case "region": {
                container.open(LDKeys.REGION, 0, chunk.district.region().id, 0);
                return;
            }
        }
    }
}

