/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui.modules;

import java.util.Map;
import net.fexcraft.mod.landdev.data.Norms;
import net.fexcraft.mod.landdev.data.norm.Norm;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;

public class NormModule {
    public static void processNorm(Norms norms, BaseCon container, ModuleRequest req, int uiid) {
        Norm norm = norms.get(container.pos.z);
        if (norm == null) {
            return;
        }
        if (norm.type.isInteger()) {
            try {
                norm.set(Integer.parseInt(req.getField("norm_field")));
            }
            catch (Exception e) {
                container.msg("Error: " + e.getMessage());
            }
        } else if (norm.type.isDecimal()) {
            try {
                norm.set(Float.valueOf(Float.parseFloat(req.getField("norm_field"))));
            }
            catch (Exception e) {
                container.msg("Error: " + e.getMessage());
            }
        } else {
            norm.set(req.getField("norm_field"));
        }
        container.open(uiid);
    }

    public static void processBool(Norms norms, BaseCon container, ModuleRequest req, int uiid) {
        Norm norm = norms.get(container.pos.z);
        if (norm == null) {
            return;
        }
        if (!norm.type.isBool()) {
            return;
        }
        norm.toggle();
        container.open(uiid);
    }

    public static boolean isNormReq(Norms norms, BaseCon container, ModuleRequest req, int uiid, int lid) {
        if (!req.event().startsWith("norm.")) {
            return false;
        }
        Norm norm = norms.get(req.event().substring(5));
        if (norm == null) {
            return false;
        }
        container.open(uiid, lid, norms.index(norm));
        return true;
    }

    public static void respNormList(Norms norms, BaseCon container, ModuleResponse resp, String prefix, boolean canman) {
        resp.setTitle(prefix + ".norms");
        LDUIButton icon = canman ? LDUIButton.OPEN : LDUIButton.EMPTY;
        for (Map.Entry<String, Norm> entry : norms.norms.entrySet()) {
            if (entry.getValue().type.isBool()) {
                resp.addRow("norm." + entry.getKey(), LDUIRow.ELM_GENERIC, icon, canman, entry.getValue().bool() ? "landdev.gui.yes" : "landdev.gui.no");
                continue;
            }
            resp.addRow("norm." + entry.getKey(), LDUIRow.ELM_GENERIC, icon, canman, entry.getValue().string());
        }
    }

    public static void respNormEdit(Norms norms, BaseCon container, ModuleResponse resp, String prefix, boolean canman) {
        resp.setTitle(prefix + ".norm_editor");
        Norm norm = norms.get(container.pos.z);
        if (norm == null) {
            return;
        }
        resp.addRow("norm_id", LDUIRow.ELM_GREEN, norm.id);
        resp.addRow("norm_value", LDUIRow.ELM_GENERIC, norm.string());
        if (!canman) {
            return;
        }
        if (norm.type.isBool()) {
            resp.addButton("norm_bool", LDUIRow.ELM_BLUE, norm.bool() ? LDUIButton.ENABLED : LDUIButton.DISABLED);
        } else {
            resp.addField("norm_field", norm.string());
            resp.addButton("norm_submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
            resp.setFormular();
        }
    }
}

