/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import java.io.File;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ProtectorInstance;

public class Protector {
    public static ProtectorInstance INSTANCE;

    public static void load() {
        File file = new File(LDConfig.CONFIG_PATH, "landdev-protector.json");
        if (!file.exists()) {
            Protector.generate(file);
        }
        JsonMap map = JsonHandler.parse((File)file);
        boolean abs = map.getBoolean("absolute_block_protection", false);
        INSTANCE = ProtectorInstance.get(abs, map);
    }

    private static void generate(File file) {
        JsonMap map = new JsonMap();
        map.add("__comment1", "In this file you can define custom interaction protection, by adding an entry the block becomes protected.");
        map.add("__comment2", "If you set 'absolute_block_protection' to true, the list in this file is ignored and all blocks become protected.");
        map.add("__comment3", "Note: There is a hardcoded exception for SIGN blocks.");
        map.add("absolute_block_protection", false);
        JsonArray blocks = new JsonArray();
        blocks.add("minecraft:chest");
        blocks.add("minecraft:ender_chest");
        blocks.add("minecraft:trapped_chest");
        blocks.add("minecraft:furnace");
        blocks.add("minecraft:lit_furnace");
        blocks.add("minecraft:hopper");
        blocks.add("minecraft:dispenser");
        blocks.add("minecraft:dropper");
        blocks.add("minecraft:unpowered_repeater");
        blocks.add("minecraft:powered_repeater");
        map.add("blocks", (JsonValue)blocks);
        JsonArray entities = new JsonArray();
        map.add("entities", (JsonValue)entities);
        JsonHandler.print((File)file, (JsonValue)map, (JsonHandler.PrintOption)JsonHandler.PrintOption.SPACED);
    }
}

