/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.event.CollectTaxEvent;
import net.fexcraft.mod.landdev.event.LDEvent;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.broad.BroadcastChannel;
import net.fexcraft.mod.landdev.util.broad.Broadcaster;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class TaxSystem
extends TimerTask {
    private static String CHATNAME = "TaxSystem";
    private static String PREFIX = "&b";
    public static TaxSystem INSTANCE;
    private static long last;

    @Override
    public void run() {
        this.load();
        long date = Time.getDate();
        if (TaxSystem.tooSoon(last, date)) {
            this.broad("Tax interval will be skipped. Previous Interval was not long ago.");
            this.broad("LAST: " + Time.getAsString((long)last) + " + INTERVAL:" + LDConfig.TAX_INTERVAL / 3600000L + "h > NOW: " + Time.getAsString((long)date));
            this.save();
            return;
        }
        this.collect(date, false);
        this.save();
    }

    private static boolean tooSoon(long last, long date) {
        return last + LDConfig.TAX_INTERVAL - 100L > date;
    }

    public void collect(long date, boolean ignore) {
        Object mail;
        long tax;
        this.broad("Starting regular Tax collection...");
        for (District dis : ResManager.DISTRICTS.values()) {
            Mail mail2 = new Mail(MailType.SYSTEM, Layers.DISTRICT, dis.id);
            mail2.addMessage("landdev.tax.district.collected");
            mail2.addMessage(Config.getWorthAsString((long)dis.tax_collected));
            mail2.setTitle("landdev.tax.summary.mail");
            mail2.expireInDays(3);
            dis.mail.add(mail2);
            dis.tax_collected = 0L;
            LDEvent.run(new CollectTaxEvent(dis));
        }
        for (Municipality mun : ResManager.MUNICIPALITIES.values()) {
            float muntax = mun.county.norms.get("municipality-tax-percent").decimal();
            if (muntax > 20.0f) {
                muntax = 20.0f;
            }
            if (muntax < 0.0f) {
                muntax = 0.0f;
            }
            tax = (long)((float)(mun.tax_collected / 100L) * muntax);
            if (mun.account.getBalance() < tax) {
                mail = new Mail(MailType.SYSTEM, Layers.COUNTY, mun.county.id);
                ((Mail)mail).addMessage("landdev.tax.county.mun_missing_funds0");
                ((Mail)mail).addMessage(mun.id + " | " + mun.name());
                ((Mail)mail).addMessage("landdev.tax.county.mun_missing_funds1");
                ((Mail)mail).addMessage(Config.getWorthAsString((long)mun.account.getBalance()));
                ((Mail)mail).addMessage("landdev.tax.county.mun_missing_funds2");
                ((Mail)mail).addMessage(Config.getWorthAsString((long)tax));
                ((Mail)mail).setTitle("landdev.tax.warning.mail");
                ((Mail)mail).expireInDays(3);
                mun.county.mail.add((Mail)mail);
                tax = mun.account.getBalance() > 0L ? mun.account.getBalance() : 0L;
            }
            mun.account.getBank().processAction(Bank.Action.TRANSFER, null, mun.account, tax, mun.county.account);
            mun.county.tax_collected += tax;
            mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, mun.id);
            ((Mail)mail).addMessage("landdev.tax.municipality.collected");
            ((Mail)mail).addMessage(Config.getWorthAsString((long)mun.tax_collected));
            ((Mail)mail).addMessage("landdev.tax.municipality.transferred");
            ((Mail)mail).addMessage(Config.getWorthAsString((long)tax));
            ((Mail)mail).setTitle("landdev.tax.summary.mail");
            ((Mail)mail).expireInDays(3);
            mun.mail.add((Mail)mail);
            mun.tax_collected = 0L;
            LDEvent.run(new CollectTaxEvent(mun));
        }
        for (County ct : ResManager.COUNTIES.values()) {
            float cttax = ct.region.norms.get("county-tax-percent").decimal();
            if (cttax > 20.0f) {
                cttax = 20.0f;
            }
            if (cttax < 0.0f) {
                cttax = 0.0f;
            }
            tax = (long)((float)(ct.tax_collected / 100L) * cttax);
            ct.account.getBank().processAction(Bank.Action.TRANSFER, null, ct.account, tax, ct.region.account);
            ct.region.tax_collected += tax;
            if (ct.account.getBalance() < tax) {
                mail = new Mail(MailType.SYSTEM, Layers.REGION, ct.region.id);
                ((Mail)mail).addMessage("landdev.tax.region.county_missing_funds0");
                ((Mail)mail).addMessage(ct.id + " | " + ct.name());
                ((Mail)mail).addMessage("landdev.tax.region.county_missing_funds1");
                ((Mail)mail).addMessage(Config.getWorthAsString((long)ct.account.getBalance()));
                ((Mail)mail).addMessage("landdev.tax.region.county_missing_funds2");
                ((Mail)mail).addMessage(Config.getWorthAsString((long)tax));
                ((Mail)mail).setTitle("landdev.tax.warning.mail");
                ((Mail)mail).expireInDays(3);
                ct.region.mail.add((Mail)mail);
                tax = ct.account.getBalance() > 0L ? ct.account.getBalance() : 0L;
            }
            mail = new Mail(MailType.SYSTEM, Layers.COUNTY, ct.id);
            ((Mail)mail).addMessage("landdev.tax.county.collected");
            ((Mail)mail).addMessage(Config.getWorthAsString((long)ct.tax_collected));
            ((Mail)mail).addMessage("landdev.tax.county.transferred");
            ((Mail)mail).addMessage(Config.getWorthAsString((long)tax));
            ((Mail)mail).setTitle("landdev.tax.summary.mail");
            ((Mail)mail).expireInDays(3);
            ct.mail.add((Mail)mail);
            ct.tax_collected = 0L;
            LDEvent.run(new CollectTaxEvent(ct));
        }
        for (Region st : ResManager.REGIONS.values()) {
            Mail mail3 = new Mail(MailType.SYSTEM, Layers.REGION, st.id);
            mail3.addMessage("landdev.tax.county.collected");
            mail3.addMessage(Config.getWorthAsString((long)st.tax_collected));
            mail3.setTitle("landdev.tax.summary.mail");
            mail3.expireInDays(3);
            st.mail.add(mail3);
            st.tax_collected = 0L;
            LDEvent.run(new CollectTaxEvent(st));
        }
        HashMap<ChunkKey, Chunk_> map = new HashMap<ChunkKey, Chunk_>(ResManager.CHUNKS);
        long cktax = 0L;
        long pytax = 0L;
        for (Chunk_ chunk : map.values()) {
            cktax += TaxSystem.taxChunk(chunk, date, ignore);
        }
        this.broad(Config.getWorthAsString((long)cktax) + " loaded Chunk tax collected.");
        if (LDConfig.TAX_OFFLINE) {
            File folder = new File(LandDev.SAVE_DIR, "players/");
            if (folder.exists()) {
                for (File file : folder.listFiles()) {
                    UUID uuid = UUID.fromString(file.getName().replace(".json", ""));
                    LDPlayer player = ResManager.getPlayer(uuid, true);
                    pytax += TaxSystem.taxPlayer(player, date, ignore);
                    ResManager.unloadIfOffline(player);
                }
            }
        } else {
            List players = WrapperHolder.getOnlinePlayerIDs();
            for (UUID player : players) {
                pytax += TaxSystem.taxPlayer(ResManager.getPlayer(player, true), date, ignore);
            }
        }
        this.broad(Config.getWorthAsString((long)pytax) + " player tax collected.");
        this.broad(Config.getWorthAsString((long)(cktax + pytax)) + " tax collected in total.");
        LDEvent.run(new CollectTaxEvent(null));
    }

    public static long taxPlayer(LDPlayer player, Long date, boolean ignore) {
        boolean kick;
        if (date == null) {
            date = last == 0L ? Time.getDate() : last;
        }
        if (TaxSystem.tooSoon(player.last_tax, date) && !ignore) {
            return 0L;
        }
        long tax = 0L;
        Account account = player.account;
        Account receiver = null;
        Saveable in = null;
        if (player.municipality.id >= 0) {
            tax = player.municipality.norms.get("citizen-tax").integer();
            receiver = player.municipality.account;
            kick = player.municipality.norms.get("kick-bankrupt").bool();
            in = player.municipality;
        } else {
            if (player.county.id < 0) {
                return 0L;
            }
            tax = player.county.norms.get("citizen-tax").integer();
            receiver = player.county.account;
            kick = player.county.norms.get("kick-bankrupt").bool();
            in = player.county;
        }
        if (tax > 0L) {
            Bank bank = player.account.getBank();
            if (account.getBalance() < tax) {
                if (account.getBalance() <= 0L) {
                    Mail mail = new Mail(MailType.SYSTEM, in.getLayer(), in.lid(), Layers.PLAYER, player.uuid).expireInDays(7);
                    mail.setTitle("landdev.tax.unpaid_notice.mail");
                    mail.addMessage("landdev.tax.no_funds");
                    if (kick && !player.isInManagement(in.getLayer())) {
                        mail.addMessage("landdev.tax.no_funds.kicked");
                        if (in.is(Layers.COUNTY)) {
                            Mail ml = new Mail(MailType.SYSTEM, in.getLayer(), in.lid());
                            ml.setTitle("landdev.tax.player_kicked");
                            ml.addMessage("landdev.tax.player_kicked.info");
                            ml.addMessage(player.name());
                            ml.addMessage(player.uuid.toString());
                            player.county.mail.add(ml);
                            player.leaveCounty();
                        } else {
                            Mail ml = new Mail(MailType.SYSTEM, in.getLayer(), in.lid());
                            ml.setTitle("landdev.tax.player_kicked");
                            ml.addMessage("landdev.tax.player_kicked.info");
                            ml.addMessage(player.name());
                            ml.addMessage(player.uuid.toString());
                            player.municipality.mail.add(ml);
                            player.leaveMunicipality();
                        }
                    }
                    player.addMailAndSave(mail);
                    return 0L;
                }
                tax = account.getBalance();
                Mail mail = new Mail(MailType.SYSTEM, in.getLayer(), in.lid(), Layers.PLAYER, player.uuid).expireInDays(7);
                mail.setTitle("landdev.tax.unpaid_notice.mail");
                mail.addMessage("landdev.tax.missing_funds");
                if (kick && !player.isInManagement(in.getLayer())) {
                    mail.addMessage("landdev.tax.missing_funds.kick");
                }
                player.addMailAndSave(mail);
            }
            bank.processAction(Bank.Action.TRANSFER, null, account, tax, receiver);
            if (player.municipality.id >= 0) {
                player.municipality.tax_collected += tax;
            } else {
                player.county.tax_collected += tax;
            }
        }
        player.last_tax = date;
        player.save();
        return tax;
    }

    public static long taxChunk(Chunk_ chunk, Long date, boolean ignore) {
        long tax;
        if (date == null) {
            date = last == 0L ? Time.getDate() : last;
        }
        if (TaxSystem.tooSoon(chunk.tax.last_tax, date) && !ignore) {
            return 0L;
        }
        if (chunk.link != null && chunk.link.root_key != null) {
            Chunk_ ck = ResManager.getChunk(chunk.link.root_key);
            return ck == null ? 0L : TaxSystem.taxChunk(ck, date, ignore);
        }
        if (chunk.district.id < -1) {
            return 0L;
        }
        if (!chunk.type.taxable()) {
            return 0L;
        }
        if (!chunk.owner.taxable()) {
            return 0L;
        }
        long l = tax = chunk.tax.custom_tax > 0L ? chunk.tax.custom_tax : chunk.district.tax();
        if (tax > 0L) {
            Account account = chunk.owner.getAccount(chunk);
            Account receiver = chunk.district.account();
            Bank bank = account.getBank();
            if (account.getBalance() < tax) {
                String ckoid;
                Layers ckow = chunk.owner.layer();
                String string = ckoid = chunk.owner.playerchunk ? chunk.owner.player.toString() : chunk.owner.owid + "";
                if (account.getBalance() <= 0L) {
                    Mail mail = new Mail(MailType.SYSTEM, chunk).expireInDays(7);
                    mail.setTitle("landdev.tax.unpaid_notice.mail");
                    mail.addMessage("landdev.tax.no_funds");
                    if (chunk.district.norms.get("unclaim-bankrupt").bool()) {
                        mail.addMessage("landdev.tax.no_funds.unclaimed");
                        chunk.owner.set(Layers.DISTRICT, null, chunk.district.id);
                    }
                    mail.addMessage("Chunk: " + chunk.key.toString());
                    chunk.sendToOwner(mail);
                    return 0L;
                }
                Mail mail = new Mail(MailType.SYSTEM, chunk).expireInDays(7);
                mail.setTitle("landdev.tax.unpaid_notice.mail");
                mail.addMessage("landdev.tax.missing_funds");
                if (chunk.district.norms.get("unclaim-bankrupt").bool()) {
                    mail.addMessage("landdev.tax.missing_funds.unclaim");
                }
                mail.addMessage("Chunk: " + chunk.key.toString());
                chunk.sendToOwner(mail);
                tax = account.getBalance();
            }
            bank.processAction(Bank.Action.TRANSFER, null, account, tax, receiver);
            chunk.district.addTaxStat(tax);
        }
        chunk.tax.last_tax = date;
        chunk.save();
        return tax;
    }

    private void broad(String str) {
        Broadcaster.send(Broadcaster.TargetTransmitter.INTERNAL_ONLY, BroadcastChannel.ANNOUNCE, "&b" + CHATNAME, str, PREFIX);
        Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.ANNOUNCE, CHATNAME, str, new Object[0]);
    }

    public TaxSystem load() {
        File file = new File(LandDev.SAVE_DIR, "tax.json");
        JsonMap map = JsonHandler.parse((File)file);
        last = map.empty() ? 0L : map.getLong("last-interval", Time.getDate() - 200L);
        INSTANCE = this;
        if (!file.exists()) {
            this.save();
        }
        return this;
    }

    public void save() {
        JsonMap map = new JsonMap();
        map.add("last-interval", last);
        JsonHandler.print((File)new File(LandDev.SAVE_DIR, "tax.json"), (JsonValue)map, (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT_SPACED);
    }

    public static void stop() {
        INSTANCE.cancel();
    }
}

