/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util.broad;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.broad.BroadcastChannel;
import net.fexcraft.mod.landdev.util.broad.Broadcaster;
import net.fexcraft.mod.landdev.util.broad.Message;
import net.fexcraft.mod.landdev.util.broad.MsgDecoder;
import net.fexcraft.mod.landdev.util.broad.MsgEncoder;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class DiscordTransmitter
implements Broadcaster.Transmitter {
    private static DiscordTransmitter INST;
    private static ChannelFuture fut;
    private static JsonMap map;

    @Override
    public void transmit(String channel, String sender, String message, Object[] args) {
        WrapperHolder.schedule(() -> {
            if (fut != null && !fut.channel().isActive()) {
                return;
            }
            try {
                JsonMap map = new JsonMap();
                map.add("c", channel);
                if (sender != null) {
                    map.add("s", sender.startsWith("&") ? sender.substring(2) : sender);
                }
                map.add("m", message);
                fut.channel().writeAndFlush((Object)new Message("msg=" + JsonHandler.toString((JsonValue)map, (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT)));
            }
            catch (Exception e) {
                LandDev.log("Error on sending message to discord bot. " + map);
                e.printStackTrace();
            }
        });
    }

    public static void restart() {
        DiscordTransmitter.exit();
        if (!LDConfig.DISCORD_BOT_ACTIVE) {
            return;
        }
        Broadcaster.SENDERS.values().removeIf(transmitter -> transmitter instanceof DiscordTransmitter);
        INST = new DiscordTransmitter();
        Broadcaster.SENDERS.put(Broadcaster.TransmitterType.DISCORD, INST);
        new Thread(() -> {
            try {
                INST.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, "DiscordIntegrationStarter").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap boot = new Bootstrap();
            boot.group((EventLoopGroup)group);
            boot.channel(NioSocketChannel.class);
            boot.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            boot.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new MsgDecoder(), new MsgEncoder(), new ClientHandler()});
                }
            });
            fut = boot.connect(LDConfig.DISCORD_BOT_ADRESS, LDConfig.DISCORD_BOT_PORT).sync();
            Channel channel = fut.sync().channel();
            channel.writeAndFlush((Object)new Message("token=" + LDConfig.DISCORD_BOT_TOKEN));
            fut.channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    public static void exit() {
        INST = null;
        if (fut != null) {
            fut.channel().close();
        }
    }

    @Override
    public Broadcaster.TransmitterType type() {
        return Broadcaster.TransmitterType.DISCORD;
    }

    static {
        map = new JsonMap();
    }

    private static class ClientHandler
    extends ChannelInboundHandlerAdapter {
        private ClientHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
            Message msg = (Message)obj;
            if (msg.length <= 0) {
                return;
            }
            if (!msg.value.startsWith("msg=")) {
                LandDev.log("Discord bot response: " + msg.value);
            }
            JsonMap map = (JsonMap)JsonHandler.parse((String)msg.value.substring(4), (boolean)true);
            String user = map.getString("s", "DiscordUser");
            if (map.has("m") && map.get("m").string_value().length() > 0) {
                Broadcaster.send(Broadcaster.TargetTransmitter.NO_DISCORD, BroadcastChannel.CHAT, "&2" + user, map.getString("m", "<MESSAGE_TEXT>"), LDConfig.CHAT_DISCORD_COLOR);
                Broadcaster.send(Broadcaster.TargetTransmitter.LOG_ONLY, BroadcastChannel.CHAT, "D|" + user, map.getString("m", "<MESSAGE_TEXT>"), new Object[0]);
            } else if (!map.has("a")) {
                Broadcaster.send(Broadcaster.TargetTransmitter.INTERNAL_ONLY, BroadcastChannel.CHAT, "&2" + user, "&b[!] ERROR, check log for details.", LDConfig.CHAT_DISCORD_COLOR);
            } else {
                Broadcaster.send(Broadcaster.TargetTransmitter.INTERNAL_ONLY, BroadcastChannel.CHAT, "&2" + user, "&b[!] &6Embeds: " + map.get("a").asArray().size(), LDConfig.CHAT_DISCORD_COLOR);
            }
            if (map.has("a")) {
                int[] idx = new int[]{1};
                map.get("a").asArray().elements().forEach(elm -> {
                    JsonArray array = elm.asArray();
                    int n = idx[0];
                    idx[0] = n + 1;
                    Broadcaster.send(Broadcaster.TargetTransmitter.INTERNAL_ONLY, BroadcastChannel.CHAT, "", "&l&6Embed " + n + ": ", "img", array.get(0).string_value(), array.get(1).string_value(), array.get(2).string_value());
                    Broadcaster.send(Broadcaster.TargetTransmitter.LOG_ONLY, BroadcastChannel.CHAT, "D|" + user, array.get(0).string_value(), new Object[0]);
                });
            }
        }
    }
}

