/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;

public class Mail
implements Saveable {
    public boolean unread;
    public Layers from;
    public String fromid;
    public Layers receiver;
    public String recid;
    public String title;
    public ArrayList<String[]> message = new ArrayList();
    public MailType type;
    public long expiry;
    public long sent = Time.getDate();
    public boolean staff;

    public Mail() {
        this.unread = true;
        this.type = MailType.SYSTEM;
    }

    public Mail(MailType mtype, Layers frl, Object id, Layers rec, Object rec_id) {
        this.type = mtype;
        this.from = frl;
        this.fromid = id.toString();
        this.receiver = rec;
        this.recid = rec_id.toString();
        this.unread = true;
    }

    public Mail(MailType mtype, Chunk_ chunk) {
        this.type = mtype;
        this.from = chunk.district.owner.layer();
        this.fromid = "" + chunk.district.owner.owid;
        this.receiver = chunk.owner.playerchunk ? Layers.PLAYER : chunk.owner.layer();
        this.recid = chunk.owner.playerchunk ? chunk.owner.player.toString() : "" + chunk.owner.owid;
        this.unread = true;
    }

    public Mail(MailType mtype, Layers lay, Object id) {
        this.type = mtype;
        this.from = lay;
        this.fromid = id.toString();
        this.receiver = lay;
        this.recid = id.toString();
        this.unread = true;
    }

    public Mail expiry(long time) {
        this.expiry = Time.getDate() + time;
        return this;
    }

    public Mail expireInDays(int days) {
        this.expiry = Time.getDate() + 86400000L * (long)days;
        return this;
    }

    public Mail setTitle(String ntitle) {
        this.title = ntitle;
        return this;
    }

    public Mail addMessage(String msg) {
        this.message.add(new String[]{msg});
        return this;
    }

    public Mail addMessage(String ... msg) {
        this.message.add(msg);
        return this;
    }

    public Mail setStaffInvite() {
        this.staff = true;
        return this;
    }

    @Override
    public void save(JsonMap map) {
        map.add("read", !this.unread);
        map.add("from", this.from.name());
        map.add("from_id", this.fromid);
        map.add("receiver", this.receiver.name());
        map.add("rec_id", this.recid);
        map.add("title", this.title);
        JsonArray msgs = new JsonArray();
        for (String[] strs : this.message) {
            msgs.add((JsonValue)new JsonArray((Object[])strs));
        }
        map.add("message", (JsonValue)msgs);
        map.add("type", this.type.name());
        map.add("sent", this.sent);
        if (this.expiry > 0L) {
            map.add("expiry", this.expiry);
        }
        if (this.staff) {
            map.add("staffinv", this.staff);
        }
    }

    @Override
    public void load(JsonMap map) {
        this.unread = !map.getBoolean("read", false);
        this.from = Layers.get(map.getString("from", Layers.NONE.name()));
        this.fromid = map.getString("from_id", "ERROR");
        this.receiver = Layers.get(map.getString("receiver", Layers.NONE.name()));
        this.recid = map.getString("rec_id", "ERROR");
        this.title = map.getString("title", "No Title");
        this.message.clear();
        JsonArray array = map.getArray("message");
        if (array.get(0).isArray()) {
            for (JsonValue val : (List)array.value) {
                this.message.add(val.asArray().toStringArray());
            }
        } else {
            for (JsonValue val : (List)array.value) {
                this.message.add(new String[]{val.string_value()});
            }
        }
        this.type = MailType.get(map.getString("type", "EXPIRED"));
        this.expiry = map.getLong("expiry", 0L);
        this.staff = map.getBoolean("staffinv", false);
        this.sent = map.getLong("sent", 0L);
    }

    public int fromInt() {
        return Integer.parseInt(this.fromid);
    }

    public UUID fromUUID() {
        return UUID.fromString(this.fromid);
    }

    public int recInt() {
        return Integer.parseInt(this.recid);
    }

    public UUID recUUID() {
        return UUID.fromString(this.recid);
    }

    public void expire() {
        this.expiry = Time.getDate();
    }

    public boolean expired() {
        return this.expiry > 0L && Time.getDate() > this.expiry;
    }

    public boolean invite() {
        return this.type == MailType.INVITE;
    }

    public boolean request() {
        return this.type == MailType.REQUEST;
    }
}

