/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.norm;

import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.norm.Norm;
import net.fexcraft.mod.landdev.data.norm.NormType;
import org.apache.commons.lang3.math.NumberUtils;

public class FloatNorm
extends Norm {
    private float value;

    public FloatNorm(String id, float def) {
        super(id, NormType.DECIMAL);
        this.value = def;
    }

    @Override
    public String string() {
        return "" + this.value;
    }

    @Override
    public int integer() {
        return (int)this.value;
    }

    @Override
    public float decimal() {
        return this.value;
    }

    @Override
    public boolean bool() {
        return this.value > 0.0f;
    }

    @Override
    public JsonValue save() {
        return new JsonValue((Object)Float.valueOf(this.value));
    }

    @Override
    public void load(JsonValue obj) {
        this.value = obj.float_value();
    }

    @Override
    public void set(Object val) {
        if (val instanceof Number) {
            this.value = ((Number)val).floatValue();
        }
        if (val instanceof Boolean) {
            float f = this.value = (Boolean)val != false ? 1.0f : 0.0f;
        }
        if (val instanceof String) {
            String str = val.toString();
            if (!NumberUtils.isCreatable((String)val.toString())) {
                return;
            }
            this.value = Float.parseFloat(str);
        }
    }

    @Override
    public Norm copy() {
        return new FloatNorm(this.id, this.value);
    }
}

