/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.norm;

import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.norm.Norm;
import net.fexcraft.mod.landdev.data.norm.NormType;
import org.apache.commons.lang3.math.NumberUtils;

public class IntegerNorm
extends Norm {
    private int value;

    public IntegerNorm(String id, int def) {
        super(id, NormType.INTEGER);
        this.value = def;
    }

    @Override
    public String string() {
        return "" + this.value;
    }

    @Override
    public int integer() {
        return this.value;
    }

    @Override
    public float decimal() {
        return this.value;
    }

    @Override
    public boolean bool() {
        return this.value > 0;
    }

    @Override
    public JsonValue save() {
        return new JsonValue((Object)this.value);
    }

    @Override
    public void load(JsonValue obj) {
        this.value = obj.integer_value();
    }

    @Override
    public void set(Object val) {
        if (val instanceof Number) {
            this.value = ((Number)val).intValue();
        }
        if (val instanceof Boolean) {
            int n = this.value = (Boolean)val != false ? 1 : 0;
        }
        if (val instanceof String) {
            String str = val.toString();
            if (!NumberUtils.isCreatable((String)val.toString())) {
                return;
            }
            this.value = str.contains(".") ? (int)Float.parseFloat(str) : Integer.parseInt(str);
        }
    }

    @Override
    public Norm copy() {
        return new IntegerNorm(this.id, this.value);
    }
}

