/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.db;

import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.tag.TagType;

public class JsonTagConverter {
    public static TagCW map(TagCW compound, JsonMap map) {
        for (Map.Entry entry : map.entries()) {
            if (((JsonValue)entry.getValue()).isMap()) {
                compound.set((String)entry.getKey(), JsonTagConverter.map(TagCW.create(), ((JsonValue)entry.getValue()).asMap()));
                continue;
            }
            if (((JsonValue)entry.getValue()).isArray()) {
                compound.set((String)entry.getKey(), JsonTagConverter.array(TagLW.create(), ((JsonValue)entry.getValue()).asArray()));
                continue;
            }
            if (((JsonValue)entry.getValue()).value instanceof Long) {
                compound.set((String)entry.getKey(), ((JsonValue)entry.getValue()).long_value());
                continue;
            }
            if (((JsonValue)entry.getValue()).value instanceof Float) {
                compound.set((String)entry.getKey(), ((JsonValue)entry.getValue()).float_value());
                continue;
            }
            if (((JsonValue)entry.getValue()).value instanceof Integer) {
                compound.set((String)entry.getKey(), ((JsonValue)entry.getValue()).integer_value());
                continue;
            }
            if (((JsonValue)entry.getValue()).value instanceof Boolean) {
                compound.set((String)entry.getKey(), ((JsonValue)entry.getValue()).bool());
                continue;
            }
            compound.set((String)entry.getKey(), ((JsonValue)entry.getValue()).string_value());
        }
        return compound;
    }

    public static TagLW array(TagLW list, JsonArray array) {
        for (JsonValue val : (List)array.value) {
            if (val.isMap()) {
                list.add(JsonTagConverter.map(TagCW.create(), val.asMap()));
                continue;
            }
            if (val.value instanceof Long) {
                list.add((float)val.long_value());
                continue;
            }
            if (val.value instanceof Float) {
                list.add(val.float_value());
                continue;
            }
            if (val.value instanceof Integer) {
                list.add(val.integer_value());
                continue;
            }
            if (val.value instanceof Boolean) {
                list.add((int)((byte)(val.bool() ? 1 : 0)));
                continue;
            }
            list.add(val.string_value());
        }
        return list;
    }

    public static JsonMap demap(TagCW com) {
        JsonMap map = new JsonMap();
        for (String key : com.keys()) {
            TagType type = com.getType(key);
            switch (type) {
                case COMPOUND: {
                    map.add(key, (JsonValue)JsonTagConverter.demap(com.getCompound(key)));
                    break;
                }
                case LIST: {
                    map.add(key, (JsonValue)JsonTagConverter.dearray(com.getList(key)));
                    break;
                }
                case STRING: {
                    map.add(key, com.getString(key));
                    break;
                }
                case LONG: {
                    map.add(key, com.getLong(key));
                    break;
                }
                case INT: {
                    map.add(key, com.getInteger(key));
                    break;
                }
                case BYTE: {
                    map.add(key, com.getBoolean(key));
                    break;
                }
                case FLOAT: {
                    map.add(key, com.getFloat(key));
                    break;
                }
                case DOUBLE: {
                    map.add(key, com.getDouble(key));
                    break;
                }
            }
        }
        return map;
    }

    public static JsonArray dearray(TagLW list) {
        JsonArray array = new JsonArray();
        block7: for (int idx = 0; idx < list.size(); ++idx) {
            TagType type = list.getType(idx);
            switch (type) {
                case COMPOUND: {
                    array.add((JsonValue)JsonTagConverter.demap(list.getCompound(idx)));
                    continue block7;
                }
                case STRING: {
                    array.add(list.getString(idx));
                    continue block7;
                }
                case INT: {
                    array.add(list.getInteger(idx));
                    continue block7;
                }
                case FLOAT: {
                    array.add(list.getFloat(idx));
                    continue block7;
                }
                case DOUBLE: {
                    array.add(list.getDouble(idx));
                    continue block7;
                }
            }
        }
        return array;
    }
}

