/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIElement;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class BaseUI
extends UserInterface {
    protected static ConcurrentHashMap<UIText, List<String>> texttips = new ConcurrentHashMap();
    protected ArrayList<BaseElm> elements = new ArrayList();
    protected List<String> hint;
    protected IDL imgres;
    protected BaseCon bon;
    protected boolean addscroll;
    protected int scroll;

    public BaseUI(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.bon = (BaseCon)container;
    }

    public void init() {
        this.sync();
    }

    private void sync() {
        TagCW com = TagCW.create();
        com.set("sync", true);
        ContainerInterface.SEND_TO_SERVER.accept(com);
    }

    public void msg(String msg) {
        ((UIText)this.texts.get("note")).value(msg);
        ((UIText)this.texts.get("note")).translate();
        ((UITab)this.tabs.get("note")).visible(true);
    }

    public void clear() {
        this.texts.keySet().removeIf(key -> key.startsWith("gen_"));
        this.buttons.keySet().removeIf(key -> key.startsWith("gen_"));
        this.fields.keySet().removeIf(key -> key.startsWith("gen_"));
        this.tabs.keySet().removeIf(key -> key.startsWith("gen_"));
    }

    public void scroll(int d) {
        int s;
        int l;
        this.scroll += d;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        int n = l = (s = this.elements.size()) < 12 ? 0 : s - 12;
        if (this.scroll > l) {
            this.scroll = l;
        }
        for (int i = 0; i < s; ++i) {
            int k;
            this.elements.get(i).repos(k, (k = i - this.scroll) >= 0 && k < 12);
        }
        UITab tab = (UITab)this.tabs.remove("scroll");
        this.tabs.put("scroll", tab);
        tab = (UITab)this.tabs.remove("icon");
        this.tabs.put("icon", tab);
    }

    public void predraw(float ticks, int mx, int my) {
        ((UIButton)this.buttons.get((Object)"flash")).ty = Time.getSecond() % 2 == 1 ? 23 : 5;
    }

    public void drawbackground(float ticks, int mx, int my) {
        if (((UITab)this.tabs.get("icon")).visible() && this.imgres != null) {
            this.drawer.bind(this.imgres);
            this.drawer.drawFull((float)(((UITab)this.tabs.get((Object)"icon")).x + 3 + this.gLeft), (float)(((UITab)this.tabs.get((Object)"icon")).y + 3 + this.gTop), 28, 28);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.startsWith("gen_")) {
            for (BaseElm elm : this.elements) {
                if (!elm.id.equals(id)) continue;
                elm.run.run();
                return true;
            }
        }
        switch (id) {
            case "scroll_up": {
                this.scroll(-1);
                return true;
            }
            case "scroll_down": {
                this.scroll(1);
                return true;
            }
            case "back": {
                TagCW com = TagCW.create();
                com.set("go_back", true);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            case "note_ok": {
                ((UITab)this.tabs.get("note")).visible(false);
                return true;
            }
        }
        return false;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.scroll(am > 0 ? 1 : -1);
        return true;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        for (UIText text : this.texts.values()) {
            if (!text.hovered()) continue;
            this.hint = texttips.get(text);
            if (this.hint == null) {
                list.add(text.value());
                continue;
            }
            list.addAll(this.hint);
        }
        if (this.bon.checkboxes.size() > 0 || this.bon.radioboxes.size() > 0) {
            for (BaseElm elm : this.elements) {
                if (!elm.icon.isCheck() && !elm.icon.isRadio() || elm.button == null || !elm.button.hovered()) continue;
                list.add(this.drawer.translate(elm.icon.translation(), new Object[0]));
            }
        }
        if (list.size() == 1 && list.get(0).length() == 0) {
            list.clear();
        }
    }

    protected void addElm(String id, LDUIRow elm, LDUIButton icon, boolean text, boolean button, boolean field, Object val) {
        BaseElm belm = new BaseElm(this, "gen_" + id, elm, icon, button);
        if (field) {
            belm.addField(this, val, icon == LDUIButton.BLANK);
        } else {
            belm.addText(this, text ? id : null, val);
        }
        this.elements.add(belm);
    }

    public static class BaseElm {
        protected LDUIRow row;
        protected LDUIButton icon;
        protected UITab tab;
        protected UIButton button;
        protected UIField field;
        protected UIText text;
        protected Runnable run;
        private String id;

        public BaseElm(BaseUI base, String id, LDUIRow row, LDUIButton icon, boolean ab) {
            this.icon = icon;
            this.row = row;
            this.id = id;
            try {
                this.tab = (UITab)UIElement.create((Class)UITab.IMPLEMENTATION, (UserInterface)base, (JsonMap)base.container.ui_map.getMap("tabs").getMap(row.tabid));
                while (base.tabs.containsKey(id)) {
                    id = (String)id + ".";
                }
                base.tabs.put(id, this.tab);
                this.tab.visible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addButton(base);
            if (!ab) {
                this.button.enabled(false);
                this.button.dcolor.packed = this.button.hcolor.packed = RGB.WHITE.packed;
                this.button.ecolor.packed = this.button.hcolor.packed;
            }
        }

        public void repos(int nidx, boolean vis) {
            this.tab.y = nidx * 14 + 19;
            if (this.text != null) {
                this.text.y = this.tab.y + 3;
                this.text.visible(vis);
            }
            if (this.button != null) {
                this.button.y = this.tab.y + 1;
                this.button.visible(vis);
            }
            if (this.field != null) {
                this.field.y = this.tab.y + 1;
                this.field.visible(vis);
            }
            this.tab.visible(vis);
        }

        public void addText(BaseUI base, String str, Object val) {
            if (str == null && val == null) {
                return;
            }
            try {
                this.text = (UIText)UIElement.create((Class)UIText.IMPLEMENTATION, (UserInterface)base, (JsonMap)base.container.ui_map.getMap("texts").getMap("temp"));
                this.text.color.packed = this.row.lighttext() ? 0xDEDEDE : 0x5D5D5D;
                this.text.hover.packed = this.row.lighttext() ? 5720589 : 13611287;
                this.text.value("landdev.gui." + base.bon.prefix + "." + str);
                String tip = "landdev.gui." + base.bon.prefix + "." + str + ".hint";
                String hin = (String)ContainerInterface.TRANSLATOR.apply(tip);
                if (!hin.equals(tip)) {
                    texttips.put(this.text, Arrays.asList(hin.split("\\\\n")));
                }
                if (val == null) {
                    this.text.translate();
                } else if (val instanceof String) {
                    String valstr = val.toString();
                    if (valstr.startsWith("!!!")) {
                        this.text.value(valstr.substring(3));
                    } else {
                        String old = this.text.value();
                        this.text.transval(valstr);
                        this.text.transval(old, new Object[]{this.text.value()});
                    }
                } else {
                    String[] arr = (String[])val;
                    if (arr.length == 0) {
                        this.text.transval(arr[0]);
                    } else {
                        this.text.transval(arr[0], (Object[])Arrays.copyOfRange(arr, 1, arr.length));
                    }
                }
                this.text.scale = -1.0f;
                this.tab.texts.put(this.id, this.text);
                base.texts.put(this.id, this.text);
                this.text.visible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void addField(BaseUI base, Object val, boolean wide) {
            try {
                this.field = (UIField)UIElement.create((Class)UIField.IMPLEMENTATION, (UserInterface)base, (JsonMap)new JsonMap());
                this.field.background = wide;
                this.field.width = this.field.background ? 212 : 198;
                this.field.height = 12;
                this.field.x = 6;
                base.fields.put(this.id, this.field);
                this.tab.fields.put(this.id, this.field);
                base.root.initField(this.field);
                this.field.maxlength(256);
                if (val != null) {
                    this.field.text(val.toString());
                }
                this.field.visible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void addButton(BaseUI base) {
            try {
                this.button = (UIButton)UIElement.create((Class)UIButton.IMPLEMENTATION, (UserInterface)base, (JsonMap)base.container.ui_map.getMap("buttons").getMap(this.icon.id));
                base.buttons.put(this.id, this.button);
                this.tab.buttons.put(this.id, this.button);
                String idx = this.id.substring(4);
                this.run = () -> {
                    if (this.icon.isCheck()) {
                        boolean bool = base.bon.checkboxes.get(idx) == false;
                        base.bon.checkboxes.put(idx, bool);
                        this.icon = LDUIButton.checkbox(bool);
                        JsonArray uv = base.container.ui_map.getMap("buttons").getMap(this.icon.id).getArray("uv");
                        this.button.tx = uv.get(0).integer_value();
                        this.button.ty = uv.get(1).integer_value();
                        return;
                    }
                    if (this.icon.isRadio()) {
                        JsonArray uv;
                        for (BaseElm elm : base.elements) {
                            if (!elm.icon.isRadio()) continue;
                            elm.icon = LDUIButton.radio(false);
                            uv = base.container.ui_map.getMap("buttons").getMap(this.icon.id).getArray("uv");
                            elm.button.tx = uv.get(0).integer_value();
                            elm.button.ty = uv.get(1).integer_value();
                        }
                        base.bon.radiobox = idx;
                        this.icon = LDUIButton.radio(true);
                        uv = base.container.ui_map.getMap("buttons").getMap(this.icon.id).getArray("uv");
                        this.button.tx = uv.get(0).integer_value();
                        this.button.ty = uv.get(1).integer_value();
                        return;
                    }
                    if (base.bon.form) {
                        if (!idx.contains("submit") && !base.bon.nosubmit) {
                            return;
                        }
                        TagCW com = TagCW.create();
                        com.set("submit", true);
                        com.set("interact", idx);
                        TagCW cbs = TagCW.create();
                        base.bon.checkboxes.forEach((key, val) -> cbs.set(key, val.booleanValue()));
                        com.set("checkboxes", cbs);
                        if (base.bon.radiobox != null) {
                            com.set("radiobox", base.bon.radiobox);
                        }
                        TagCW fields = TagCW.create();
                        base.fields.forEach((key, val) -> fields.set(key.substring(4), val.text()));
                        base.bon.sfields.forEach((key, val) -> fields.set(key, val));
                        com.set("fields", fields);
                        ContainerInterface cfr_ignored_0 = base.container;
                        ContainerInterface.SEND_TO_SERVER.accept(com);
                        return;
                    }
                    TagCW com = TagCW.create();
                    com.set("interact", idx);
                    if (base.fields.containsKey(idx)) {
                        com.set("field", ((UIField)base.fields.get(idx)).text());
                    }
                    ContainerInterface cfr_ignored_1 = base.container;
                    ContainerInterface.SEND_TO_SERVER.accept(com);
                };
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

