/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui.modules;

import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.data.Manageable;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;

public class MailModule
implements LDUIModule {
    public static MailModule INST = new MailModule();

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        Mail mail;
        resp.setTitle("mail.title");
        resp.setNoBack();
        MailData mailbox = MailModule.getMailbox(container.ldp, container.pos.x, container.pos.y);
        if (mailbox == null) {
            resp.addRow("boxnotfound", LDUIRow.ELM_GENERIC);
            return;
        }
        Mail mail2 = mail = container.pos.z >= mailbox.mails.size() ? null : mailbox.mails.get(container.pos.z);
        if (mail == null) {
            resp.addRow("notfound", LDUIRow.ELM_GENERIC);
            return;
        }
        resp.addRow("type", LDUIRow.ELM_BLUE, mail.type.name().toLowerCase());
        resp.addRow("from", LDUIRow.ELM_BLUE, mail.from.name().toLowerCase() + " > " + mail.fromid);
        resp.addRow("at", LDUIRow.ELM_BLUE, Time.getAsString((long)mail.sent));
        resp.addBlank();
        resp.addRow("title", LDUIRow.ELM_GREEN, resp.val(mail.title));
        for (int i = 0; i < mail.message.size(); ++i) {
            resp.addRow("msg" + i, LDUIRow.ELM_GENERIC, mail.message.get(i));
        }
        if (mail.invite()) {
            if (mail.expired() || mail.type == MailType.EXPIRED) {
                resp.addRow("expired", LDUIRow.ELM_RED);
            } else {
                resp.addButton("invite.accept", LDUIRow.ELM_GREEN, LDUIButton.ADD);
                resp.addButton("invite.reject", LDUIRow.ELM_RED, LDUIButton.REM);
            }
        }
        if (mail.request()) {
            if (mail.expired() || mail.type == MailType.EXPIRED) {
                resp.addRow("expired", LDUIRow.ELM_RED);
            } else {
                resp.addButton("request.accept", LDUIRow.ELM_GREEN, LDUIButton.ADD);
                resp.addButton("request.reject", LDUIRow.ELM_RED, LDUIButton.REM);
                resp.addButton("request.timeout", LDUIRow.ELM_YELLOW, LDUIButton.REM, LDConfig.REQUEST_TIMEOUT_DAYS);
            }
        }
        resp.addButton("goback", LDUIRow.ELM_GENERIC, LDUIButton.LIST);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        MailData mailbox = MailModule.getMailbox(container.ldp, container.pos.x, container.pos.y);
        if (mailbox == null) {
            return;
        }
        Mail mail = container.pos.z >= mailbox.mails.size() ? null : mailbox.mails.get(container.pos.z);
        switch (req.event()) {
            case "invite.accept": {
                if (mail.type != MailType.INVITE) {
                    return;
                }
                switch (mail.from) {
                    case MUNICIPALITY: {
                        if (mail.receiver.is(Layers.PLAYER)) {
                            LDPlayer player = ResManager.getPlayer(mail.recUUID(), true);
                            Municipality mun = ResManager.getMunicipality(mail.fromInt(), true);
                            if (mail.staff) {
                                if (!mun.citizens.isCitizen(player.uuid)) {
                                    player.entity.send("mail.municipality.staff.notmember");
                                    return;
                                }
                                mun.manage.staff.add(new Manageable.Staff(player.uuid, PermAction.MUNICIPALITY_STAFF));
                                mun.save();
                                String pln = ResManager.getPlayerName(player.uuid);
                                for (Manageable.Staff stf : mun.manage.staff) {
                                    LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                                    mail = new Mail(MailType.SYSTEM, Layers.MUNICIPALITY, mun.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                                    mail.setTitle(mun.name()).addMessage("landdev.mail.municipality.staff.added", pln);
                                    stp.addMailAndSave(mail);
                                }
                                mail.expire();
                            } else {
                                if (player.isMunicipalityManager()) {
                                    player.entity.send("landdev.mail.municipality.citizen.ismanager");
                                    return;
                                }
                                if (player.isCountyManager() && mun.county.id != player.county.id) {
                                    player.entity.send("landdev.mail.county.citizen.ismanager");
                                    return;
                                }
                                player.setCitizenOf(mun);
                                mail.expire();
                            }
                        } else if (mail.receiver.is(Layers.MUNICIPALITY)) {
                            // empty if block
                        }
                        this.goback(container);
                        return;
                    }
                    case COUNTY: {
                        if (mail.receiver.is(Layers.PLAYER)) {
                            LDPlayer player = ResManager.getPlayer(mail.recUUID(), true);
                            County ct = ResManager.getCounty(mail.fromInt(), true);
                            if (mail.staff) {
                                if (!ct.citizens.isCitizen(player.uuid)) {
                                    player.entity.send("landdev.mail.county.staff.notmember");
                                    return;
                                }
                                ct.manage.staff.add(new Manageable.Staff(player.uuid, PermAction.COUNTY_STAFF));
                                ct.save();
                                String pln = ResManager.getPlayerName(player.uuid);
                                for (Manageable.Staff stf : ct.manage.staff) {
                                    LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                                    mail = new Mail(MailType.SYSTEM, Layers.COUNTY, ct.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                                    mail.setTitle(ct.name()).addMessage("landdev.mail.county.staff.added", pln);
                                    stp.addMailAndSave(mail);
                                }
                                mail.expire();
                            } else {
                                if (player.isMunicipalityManager() && ct.id != player.municipality.county.id) {
                                    player.entity.send("landdev.mail.municipality.citizen.ismanager");
                                    return;
                                }
                                if (player.isCountyManager() && ct.id != player.county.id) {
                                    player.entity.send("landdev.mail.county.citizen.ismanager");
                                    return;
                                }
                                player.setCitizenOf(ct);
                                mail.expire();
                            }
                        } else if (mail.receiver.is(Layers.COUNTY)) {
                            // empty if block
                        }
                        this.goback(container);
                        return;
                    }
                    case REGION: {
                        if (mail.receiver.is(Layers.PLAYER)) {
                            LDPlayer player = ResManager.getPlayer(mail.recUUID(), true);
                            Region rg = ResManager.getRegion(mail.fromInt(), true);
                            if (mail.staff) {
                                if (!rg.isCitizen(player.uuid)) {
                                    player.entity.send("landdev.mail.region.staff.notmember");
                                    return;
                                }
                                rg.manage.staff.add(new Manageable.Staff(player.uuid, PermAction.COUNTY_STAFF));
                                rg.save();
                                String pln = ResManager.getPlayerName(player.uuid);
                                for (Manageable.Staff stf : rg.manage.staff) {
                                    LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                                    mail = new Mail(MailType.SYSTEM, Layers.REGION, rg.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                                    mail.setTitle(rg.name()).addMessage("landdev.mail.region.staff.added", pln);
                                    stp.addMailAndSave(mail);
                                }
                                mail.expire();
                            }
                        } else if (mail.receiver.is(Layers.REGION)) {
                            // empty if block
                        }
                        return;
                    }
                    case COMPANY: {
                        return;
                    }
                }
                return;
            }
            case "invite.reject": {
                if (mail.type != MailType.INVITE) {
                    return;
                }
                mail.expire();
                this.goback(container);
                return;
            }
            case "request.accept": {
                if (mail.type != MailType.REQUEST) {
                    return;
                }
                switch (mail.from) {
                    case PLAYER: {
                        if (mail.receiver.is(Layers.MUNICIPALITY)) {
                            LDPlayer player = ResManager.getPlayer(mail.fromUUID(), true);
                            Municipality mun = ResManager.getMunicipality(mail.recInt(), true);
                            if (player.isMunicipalityManager()) {
                                player.entity.send("landdev.mail.municipality.request.ismanager");
                                return;
                            }
                            if (player.isCountyManager() && mun.county.id != player.county.id) {
                                player.entity.send("landdev.mail.county.request.ismanager");
                                return;
                            }
                            player.setCitizenOf(mun);
                            mail.expire();
                        } else if (mail.receiver.is(Layers.COUNTY) || mail.receiver.is(Layers.COMPANY)) {
                            // empty if block
                        }
                        this.goback(container);
                        return;
                    }
                }
                return;
            }
            case "request.reject": 
            case "request.timeout": {
                if (mail.type != MailType.REQUEST) {
                    return;
                }
                int mul = req.event().endsWith("timeout") ? LDConfig.REQUEST_TIMEOUT_DAYS : 1;
                switch (mail.from) {
                    case PLAYER: {
                        if (mail.receiver.is(Layers.MUNICIPALITY)) {
                            LDPlayer player = ResManager.getPlayer(mail.fromUUID(), true);
                            Municipality mun = ResManager.getMunicipality(mail.recInt(), true);
                            mun.requests.timeouts.put(player.uuid, Time.getDate() + 86400000L * (long)mul);
                            mail.expire();
                            this.goback(container);
                        }
                        return;
                    }
                }
                return;
            }
            case "goback": {
                this.goback(container);
                return;
            }
        }
    }

    private void goback(BaseCon container) {
        container.open(LDKeys.MAILBOX, container.pos.x, container.pos.y, container.pos.z);
    }

    public static MailData getMailbox(LDPlayer player, int x, int y) {
        Layers lay = Layers.values()[x];
        switch (lay) {
            case PLAYER: {
                return player.mail;
            }
            case DISTRICT: {
                District dis = ResManager.getDistrict(y);
                if (!player.adm && !dis.can(PermAction.MAIL_READ, player.uuid)) break;
                return dis.mail;
            }
            case MUNICIPALITY: {
                Municipality mun = ResManager.getMunicipality(y, false);
                if (!player.adm && !mun.manage.can(PermAction.MAIL_READ, player.uuid)) break;
                return mun.mail;
            }
            case COUNTY: {
                County con = ResManager.getCounty(y, false);
                if (!player.adm && !con.manage.can(PermAction.MAIL_READ, player.uuid)) break;
                return con.mail;
            }
            case REGION: {
                Region st = ResManager.getRegion(y, false);
                if (!player.adm && !st.manage.can(PermAction.MAIL_READ, player.uuid)) break;
                return st.mail;
            }
        }
        return null;
    }

    public static boolean canDelete(LDPlayer player, int x, int y) {
        Layers lay = Layers.values()[x];
        switch (lay) {
            case PLAYER: {
                return true;
            }
            case DISTRICT: {
                District dis = ResManager.getDistrict(y);
                if (!player.adm && !dis.can(PermAction.MAIL_DELETE, player.uuid)) break;
                return true;
            }
            case MUNICIPALITY: {
                Municipality mun = ResManager.getMunicipality(y, false);
                if (!player.adm && !mun.manage.can(PermAction.MAIL_DELETE, player.uuid)) break;
                return true;
            }
            case COUNTY: {
                County con = ResManager.getCounty(y, false);
                if (!player.adm && !con.manage.can(PermAction.MAIL_DELETE, player.uuid)) break;
                return true;
            }
            case REGION: {
                Region st = ResManager.getRegion(y, false);
                if (!player.adm && !st.manage.can(PermAction.MAIL_DELETE, player.uuid)) break;
                return true;
            }
        }
        return false;
    }
}

