/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.chunk.ChunkApp;
import net.fexcraft.mod.landdev.data.chunk.ChunkRegion;
import net.fexcraft.mod.landdev.db.Database;
import net.fexcraft.mod.landdev.db.JsonFileDB;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.BaseUI;
import net.fexcraft.mod.landdev.ui.ChunkClaimCon;
import net.fexcraft.mod.landdev.ui.ChunkClaimUI;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.MailboxCon;
import net.fexcraft.mod.landdev.ui.MailboxUI;
import net.fexcraft.mod.landdev.util.FsmmEventHooks;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.Protector;
import net.fexcraft.mod.landdev.util.TaxSystem;
import net.fexcraft.mod.landdev.util.broad.BroadcastChannel;
import net.fexcraft.mod.landdev.util.broad.Broadcaster;
import net.fexcraft.mod.landdev.util.broad.DiscordTransmitter;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.UniChunk;
import net.fexcraft.mod.uni.UniReg;
import net.fexcraft.mod.uni.ui.UIKey;

public class LDN {
    public static final String MODID = "landdev";
    public static Database DB = new JsonFileDB();
    public static LDConfig CONFIG;
    public static Timer TAX_TIMER;
    public static Timer GENERIC_TIMER;

    public static void preinit(File confdir) {
        CONFIG = new LDConfig(new File(confdir, "landdev.json"));
        UniChunk.register((Appendable)new ChunkApp(null));
    }

    public static void init(LandDev inst) {
        FsmmEventHooks.init();
        UniReg.registerMod((String)MODID, (Object)inst);
        for (Map.Entry<UIKey, Class<? extends BaseCon>> entry : LDKeys.CONS.entrySet()) {
            UniReg.registerUI((UIKey)entry.getKey(), BaseUI.class);
            UniReg.registerMenu((UIKey)entry.getKey(), (String)"landdev:uis/base", entry.getValue());
        }
        UniReg.registerUI((UIKey)LDKeys.MAILBOX, MailboxUI.class);
        UniReg.registerMenu((UIKey)LDKeys.MAILBOX, (String)"landdev:uis/mailbox", MailboxCon.class);
        UniReg.registerUI((UIKey)LDKeys.CHUNK_CLAIM, ChunkClaimUI.class);
        UniReg.registerMenu((UIKey)LDKeys.CHUNK_CLAIM, (String)"landdev:uis/chunk_claim", ChunkClaimCon.class);
        UniReg.registerUI((UIKey)LDKeys.CHUNK_TRANSFER, ChunkClaimUI.class);
        UniReg.registerMenu((UIKey)LDKeys.CHUNK_TRANSFER, (String)"landdev:uis/chunk_claim", ChunkClaimCon.class);
        UniReg.registerUI((UIKey)LDKeys.CHUNK_SELL, ChunkClaimUI.class);
        UniReg.registerMenu((UIKey)LDKeys.CHUNK_SELL, (String)"landdev:uis/chunk_claim", ChunkClaimCon.class);
        UniReg.registerUI((UIKey)LDKeys.CHUNK_BUY, ChunkClaimUI.class);
        UniReg.registerMenu((UIKey)LDKeys.CHUNK_BUY, (String)"landdev:uis/chunk_claim", ChunkClaimCon.class);
    }

    public static void postinit() {
        Protector.load();
        DiscordTransmitter.restart();
    }

    public static void onServerStarting() {
        DiscordTransmitter.restart();
    }

    public static void onServerStarted() {
        LocalDateTime midnight = LocalDateTime.of(LocalDate.now(ZoneOffset.systemDefault()), LocalTime.MIDNIGHT);
        long mid = midnight.toInstant(ZoneOffset.UTC).toEpochMilli();
        LDN.setupTaxTimer(mid);
        LDN.setupGenericTimer(mid);
        Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.SERVER, null, String.format(LDConfig.SERVLANG_STARTED, LandDev.VERSION), new Object[0]);
    }

    private static void setupTaxTimer(long mid) {
        long date = Time.getDate();
        while ((mid += LDConfig.TAX_INTERVAL) < date) {
        }
        if (TAX_TIMER == null && LDConfig.TAX_ENABLED) {
            TAX_TIMER = new Timer();
            TAX_TIMER.schedule((TimerTask)new TaxSystem().load(), new Date(mid), LDConfig.TAX_INTERVAL);
        }
    }

    private static void setupGenericTimer(long mid) {
        if (GENERIC_TIMER != null) {
            return;
        }
        long date = Time.getDate();
        long offset = 360000L;
        while ((mid += offset) < date) {
        }
        GENERIC_TIMER = new Timer();
        GENERIC_TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                ChunkRegion.saveRegions();
            }
        }, new Date(mid), offset);
    }

    public static void onServerStopping() {
        Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.SERVER, null, LDConfig.SERVLANG_STOPPING, new Object[0]);
        if (TAX_TIMER != null) {
            TAX_TIMER.cancel();
        }
        if (GENERIC_TIMER != null) {
            GENERIC_TIMER.cancel();
        }
    }

    public static void onServerStop() {
        DiscordTransmitter.exit();
    }
}

