/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.fcl.util.PacketTag21;
import net.fexcraft.mod.fsmm.FSMM;
import net.fexcraft.mod.fsmm.local.FsmmCmd;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.LDN;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.util.InteractHandler;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.PolyClaim;
import net.fexcraft.mod.landdev.util.Protector;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.TaxSystem;
import net.fexcraft.mod.landdev.util.TranslationUtil;
import net.fexcraft.mod.landdev.util.broad.BroadcastChannel;
import net.fexcraft.mod.landdev.util.broad.Broadcaster;
import net.fexcraft.mod.landdev.util.broad.DiscordTransmitter;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandDev
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"landdev");
    public static final Object VERSION = "1.5.0";
    public static File SAVE_DIR;

    public void onInitialize() {
        LDN.preinit(FabricLoader.getInstance().getConfigDir().toAbsolutePath().toFile());
        LDN.init(this);
        LDN.postinit();
        UniFCL.regTagPacketListener((String)"landdev", (boolean)false, (com, player) -> {});
        ServerLifecycleEvents.SERVER_STARTING.register(server -> LDN.onServerStarting());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> LDN.onServerStarted());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> LDN.onServerStopping());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> LDN.onServerStop());
        ServerChunkEvents.CHUNK_UNLOAD.register((level, lvlck) -> {
            if (level != ((MinecraftServer)FCL.SERVER.get()).method_30002()) {
                return;
            }
            Chunk_ chunk = ResManager.getChunk(lvlck.method_12004().field_9181, lvlck.method_12004().field_9180);
            if (chunk != null) {
                ResManager.remChunk(lvlck.method_12004().field_9181, lvlck.method_12004().field_9180);
            }
        });
        ServerWorldEvents.LOAD.register((server, world) -> this.loadResManager());
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (world != server.method_30002()) {
                return;
            }
            LandDev.log("Unloading LandDev World Data...");
            ResManager.saveAll();
            ResManager.clear();
            LandDev.log("Unloaded LandDev World Data.");
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            LDPlayer player = ResManager.getPlayer(handler.field_14140.method_7334().getId(), true);
            player.entity = UniEntity.getEntity((Object)handler.field_14140);
            player.offline = false;
            player.login = Time.getDate();
            player.chunk_last = ResManager.getChunkP(handler.field_14140);
            TaxSystem.taxPlayer(player, null, false);
            Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.SERVER, null, LDConfig.SERVLANG_JOINED.formatted(player.name_raw()), new Object[0]);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            LDPlayer player = ResManager.getPlayer(handler.field_14140.method_7334().getId(), false);
            if (player != null) {
                Broadcaster.send(Broadcaster.TargetTransmitter.NO_INTERNAL, BroadcastChannel.SERVER, null, LDConfig.SERVLANG_LEFT.formatted(player.name_raw()), new Object[0]);
                player.save();
                player.last_login = player.login;
                player.last_logout = Time.getDate();
                player.login = 0L;
                player.offline = true;
                player.entity = null;
            }
        });
        ServerPlayerEvents.COPY_FROM.register((old, nw, al) -> {
            LDPlayer player = ResManager.getPlayer(nw.method_7334().getId(), false);
            if (player != null) {
                player.entity = UniEntity.getEntity((Object)nw);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((old, nw, al) -> {
            LDPlayer player = ResManager.getPlayer(nw.method_7334().getId(), false);
            if (player != null) {
                player.entity = UniEntity.getEntity((Object)nw);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 servplay : server.method_3760().method_14571()) {
                boolean label;
                if (servplay.method_37908() != server.method_30002()) {
                    return;
                }
                LDPlayer player = ResManager.getPlayer(servplay);
                if (player == null) {
                    return;
                }
                long time = Time.getDate();
                if (time <= player.last_pos_update) continue;
                player.last_pos_update = time;
                player.chunk_last = player.chunk_current;
                player.chunk_current = ResManager.getChunkP(servplay);
                if (player.chunk_current == null) {
                    return;
                }
                if (player.chunk_last == null) {
                    player.chunk_last = player.chunk_current;
                }
                boolean moved = player.chunk_current.district.id != player.chunk_last.district.id;
                boolean bl = label = player.chunk_current.label.present && player.chunk_current != player.chunk_last;
                if (!moved && !label) continue;
                player.sendLocationUpdate(moved, label, 0);
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((level, player, pos, state, ent) -> {
            if (level != ((MinecraftServer)FCL.SERVER.get()).method_30002()) {
                return false;
            }
            if (!InteractHandler.control(pos.method_10263(), pos.method_10264(), pos.method_10260(), player, false)) {
                UniEntity.getEntity((Object)player).bar("interact.break.noperm");
                return false;
            }
            return true;
        });
        CommandRegistrationCallback.EVENT.register((dis, ctx, sel) -> this.regCmd((CommandDispatcher<class_2168>)dis));
    }

    private void loadResManager() {
        if (ResManager.INSTANCE.LOADED) {
            return;
        }
        if (!FSMM.isDataManagerLoaded()) {
            FSMM.loadDataManager();
        }
        SAVE_DIR = new File(((MinecraftServer)FCL.SERVER.get()).method_3831().toAbsolutePath().toFile(), "landdev/");
        ResManager.INSTANCE.load();
    }

    private void regCmd(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ld").then(class_2170.method_9247((String)"admin").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (((class_2168)cmd.getSource()).method_9211().method_3724() || FsmmCmd.isOp((class_2168)((class_2168)cmd.getSource()))) {
                player.adm = !player.adm;
                player.entity.send(TranslationUtil.translateCmd("adminmode." + player.adm, new Object[0]));
            } else {
                player.entity.send("\u00a7cno.permission");
            }
            return 0;
        }))).then(class_2170.method_9247((String)"uuid").executes(cmd -> {
            ((class_2168)cmd.getSource()).method_45068((class_2561)class_2561.method_43470((String)((class_2168)cmd.getSource()).method_9207().method_7334().getId().toString()));
            return 0;
        }))).then(class_2170.method_9247((String)"reload").executes(cmd -> {
            Protector.load();
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            ((class_2168)cmd.getSource()).method_45068((class_2561)class_2561.method_43469((String)"landdev.cmd.reload", (Object[])new Object[]{"landdev-interaction.json"}));
            DiscordTransmitter.restart();
            ((class_2168)cmd.getSource()).method_45068((class_2561)class_2561.method_43469((String)"landdev.cmd.reload", (Object[])new Object[]{"discord-bot-integration"}));
            ((class_2168)cmd.getSource()).method_45068((class_2561)class_2561.method_43471((String)"landdev.cmd.reload.complete"));
            return 0;
        }))).then(class_2170.method_9247((String)"force-tax").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (!player.adm) {
                return -1;
            }
            TaxSystem.INSTANCE.collect(Time.getDate(), true);
            return 0;
        }))).then(class_2170.method_9247((String)"fees").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.send(TranslationUtil.translateCmd("fees", new Object[0]));
            long sf = LDConfig.MUNICIPALITY_CREATION_FEE;
            long cf = chunk.district.county().norms.get("new-municipality-fee").integer();
            player.entity.send(TranslationUtil.translateCmd("fees_municipality", new Object[0]));
            player.entity.send(TranslationUtil.translateCmd("fees_mun_server", new Object[0]), new Object[]{Config.getWorthAsString((long)sf)});
            player.entity.send(TranslationUtil.translateCmd("fees_mun_county", new Object[0]), new Object[]{Config.getWorthAsString((long)cf)});
            player.entity.send(TranslationUtil.translateCmd("fees_mun_total", new Object[0]), new Object[]{Config.getWorthAsString((long)(sf + cf))});
            sf = LDConfig.COUNTY_CREATION_FEE;
            cf = chunk.district.region().norms.get("new-county-fee").integer();
            player.entity.send(TranslationUtil.translateCmd("fees_county", new Object[0]));
            player.entity.send(TranslationUtil.translateCmd("fees_ct_server", new Object[0]), new Object[]{Config.getWorthAsString((long)sf)});
            player.entity.send(TranslationUtil.translateCmd("fees_ct_region", new Object[0]), new Object[]{Config.getWorthAsString((long)cf)});
            player.entity.send(TranslationUtil.translateCmd("fees_ct_total", new Object[0]), new Object[]{Config.getWorthAsString((long)(sf + cf))});
            sf = LDConfig.REGION_CREATION_FEE;
            player.entity.send(TranslationUtil.translateCmd("fees_region", new Object[0]));
            player.entity.send(TranslationUtil.translateCmd("fees_rg_server", new Object[0]), new Object[]{Config.getWorthAsString((long)sf)});
            player.entity.send(TranslationUtil.translateCmd("fees_rg_total", new Object[0]), new Object[]{Config.getWorthAsString((long)sf)});
            return 0;
        }))).then(class_2170.method_9247((String)"help").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            player.entity.send("\u00a70[\u00a7bLD\u00a70]\u00a76>>\u00a72===========");
            player.entity.send("/ld (UI)");
            player.entity.send("/ld help");
            player.entity.send("/ld admin");
            player.entity.send("/ld fees");
            player.entity.send("/ld reload");
            player.entity.send("/ld force-tax");
            player.entity.send("PolyClaim (Admin)");
            player.entity.send("/ld polyclaim district <dis-id>");
            player.entity.send("/ld polyclaim select");
            player.entity.send("/ld polyclaim status");
            player.entity.send("/ld polyclaim clear");
            player.entity.send("/ld polyclaim start");
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"polyclaim").then(class_2170.method_9247((String)"district").then(class_2170.method_9244((String)"district", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (!player.adm) {
                return 0;
            }
            int did = IntegerArgumentType.getInteger((CommandContext)cmd, (String)"district");
            PolyClaim.setDis(player, did);
            return 0;
        })))).then(class_2170.method_9247((String)"select").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.selCnk(player, ResManager.getChunk(player.entity.getPos()));
            return 0;
        }))).then(class_2170.method_9247((String)"start").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.process(player);
            return 0;
        }))).then(class_2170.method_9247((String)"status").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.status(player);
            return 0;
        }))).then(class_2170.method_9247((String)"clear").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.clear(player);
            return 0;
        })))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
                player.entity.openUI(LDKeys.MAIN, new V3I(0, (int)player.entity.getPos().x >> 4, (int)player.entity.getPos().z >> 4));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ck").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"claim").then(class_2170.method_9244((String)"district", (ArgumentType)IntegerArgumentType.integer((int)-2)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, ((Integer)cmd.getArgument("district", Integer.class)).intValue(), chunk.key.z));
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, chunk.district.id, chunk.key.z));
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transfer").then(class_2170.method_9244((String)"district", (ArgumentType)IntegerArgumentType.integer((int)-2)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_TRANSFER, new V3I(chunk.key.x, ((Integer)cmd.getArgument("district", Integer.class)).intValue(), chunk.key.z));
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, chunk.district.id, chunk.key.z));
            return 0;
        }))).then(class_2170.method_9247((String)"sell").then(class_2170.method_9244((String)"price", (ArgumentType)IntegerArgumentType.integer((int)-2)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, ((Integer)cmd.getArgument("price", Integer.class)).intValue(), chunk.key.z));
            return 0;
        })))).then(class_2170.method_9247((String)"buy").then(class_2170.method_9244((String)"for", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            String arg = (String)cmd.getArgument("for", String.class);
            int dis = chunk.district.id;
            switch (arg) {
                case "self": 
                case "player": {
                    dis = -1;
                    break;
                }
                case "company": 
                case "com": {
                    dis = -2;
                    break;
                }
                case "region": 
                case "reg": {
                    dis = -3;
                    break;
                }
                case "here": {
                    dis = chunk.district.id;
                }
            }
            if (arg.startsWith("municipality:")) {
                dis = Integer.parseInt(arg.replace("municipality:", ""));
            }
            if (arg.startsWith("county:")) {
                dis = Integer.parseInt(arg.replace("county:", ""));
            }
            player.entity.openUI(LDKeys.CHUNK_TRANSFER, new V3I(chunk.key.x, dis, chunk.key.z));
            return 0;
        })))).then(class_2170.method_9247((String)"map").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            String marker = null;
            Chunk_ ck = null;
            int r = 9;
            int rm = 4;
            for (int i = 0; i < r; ++i) {
                Object str = "\u00a70|";
                for (int j = 0; j < r; ++j) {
                    int x = chunk.key.x - rm + j;
                    int z = chunk.key.z - rm + i;
                    marker = x == chunk.key.x && z == chunk.key.z ? "+" : "#";
                    ck = ResManager.getChunk(x, z);
                    str = (String)str + (ck == null ? "\u00a74" : (ck.district.id >= 0 ? "\u00a79" : "\u00a72")) + marker;
                }
                player.entity.send((String)str + "\u00a70|");
            }
            player.entity.send(TranslationUtil.translateCmd("chunk.mapdesc", new Object[0]));
            return 0;
        }))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
                Chunk_ chunk = ResManager.getChunk(player.entity);
                player.entity.openUI(LDKeys.CHUNK, new V3I(0, chunk.key.x, chunk.key.z));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dis").then(class_2170.method_9247((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            player.entity.openUI(LDKeys.DISTRICT, -1, 0, 0);
            return 0;
        }))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
                Chunk_ chunk = ResManager.getChunk(player.entity);
                player.entity.openUI(LDKeys.DISTRICT, new V3I(0, chunk.district.id, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mun").then(class_2170.method_9247((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            County county = chunk.district.county();
            boolean cn = county.norms.get("new-municipalities").bool();
            boolean pp = player.hasPermit(PermAction.CREATE_MUNICIPALITY, county.getLayer(), county.id);
            if (!cn && !pp) {
                player.entity.send(TranslationUtil.translateCmd("mun.no_new_municipalities", new Object[0]));
                player.entity.send(TranslationUtil.translateCmd("mun.no_create_permit", new Object[0]));
            } else {
                player.entity.openUI(LDKeys.MUNICIPALITY, -1, 0, 0);
            }
            return 0;
        }))).then(class_2170.method_9247((String)"center").executes(cmd -> {
            Pair<Integer, Double> dis;
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            if (chunk.district.municipality() == null) {
                player.entity.send(TranslationUtil.translateCmd("mun.not_in_a_municipality", new Object[0]));
                return 0;
            }
            Municipality mun = chunk.district.municipality();
            if (!mun.manage.can(PermAction.MANAGE_MUNICIPALITY, player.uuid) && !player.adm) {
                player.entity.send("no perm");
                return 0;
            }
            int min = Math.max(LDConfig.MIN_MUN_DIS, mun.county.norms.get("min-municipality-distance").integer());
            if (min < LDConfig.MIN_MUN_DIS) {
                min = LDConfig.MIN_MUN_DIS;
            }
            if ((Integer)(dis = ResManager.disToNearestMun(chunk.key, mun.id)).getLeft() >= 0 && (Double)dis.getRight() < (double)min) {
                player.entity.send(TranslationUtil.translateCmd("mun.center_too_close", ResManager.getMunicipality((Integer)dis.getLeft(), true).name(), dis.getLeft()));
            } else {
                ResManager.MUN_CENTERS.put((Integer)dis.getLeft(), chunk.key);
                player.entity.openUI(LDKeys.MUNICIPALITY, 0, mun.id, 0);
            }
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            if (chunk.district.municipality() == null) {
                player.entity.send(TranslationUtil.translateCmd("mun.not_in_a_municipality", new Object[0]));
                return 0;
            }
            player.entity.openUI(LDKeys.MUNICIPALITY, new V3I(0, chunk.district.municipality().id, 0));
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ct").then(class_2170.method_9247((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            Region region = chunk.district.region();
            boolean cn = region.norms.get("new-counties").bool();
            boolean pp = player.hasPermit(PermAction.CREATE_COUNTY, region.getLayer(), region.id);
            if (!cn && !pp) {
                player.entity.send(TranslationUtil.translateCmd("ct.no_new_county", new Object[0]));
                player.entity.send(TranslationUtil.translateCmd("ct.no_create_permit", new Object[0]));
            } else {
                player.entity.openUI(LDKeys.COUNTY, -1, 0, 0);
            }
            return 0;
        }))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
                Chunk_ chunk = ResManager.getChunk(player.entity);
                player.entity.openUI(LDKeys.COUNTY, new V3I(0, chunk.district.county().id, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reg").then(class_2170.method_9247((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            if (!LDConfig.NEW_REGIONS && !player.adm) {
                player.entity.send(TranslationUtil.translateCmd("rg.no_new_region", new Object[0]));
                player.entity.send(TranslationUtil.translateCmd("rg.no_create_permit", new Object[0]));
            } else {
                player.entity.openUI(LDKeys.REGION, -1, 0, 0);
            }
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((class_2168)cmd.getSource()).method_44023());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.REGION, new V3I(0, chunk.district.region().id, 0));
            return 0;
        }));
    }

    public static void log(String str) {
        LOGGER.info(str);
    }

    public static void sendLocationPacket(EntityW entity, TagCW com) {
        ServerPlayNetworking.getSender((class_3222)((class_3222)entity.direct())).sendPacket((class_8710)new PacketTag21("landdev", com));
    }

    public static void sendToAll(TagCW com) {
        for (class_3222 player : ((MinecraftServer)FCL.SERVER.get()).method_3760().method_14571()) {
            ServerPlayNetworking.getSender((class_3222)player).sendPacket((class_8710)new PacketTag21("landdev", com));
        }
    }
}

