/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.PermInteractive;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.util.ResManager;

public class Manageable
implements Saveable,
PermInteractive {
    protected UUID manager;
    public ArrayList<Staff> staff = null;
    protected PermAction.PermActions actions;
    protected String manager_name;

    public Manageable(boolean hasstaff, PermAction.PermActions actions) {
        if (hasstaff) {
            this.staff = new ArrayList();
        }
        this.actions = actions;
    }

    @Override
    public void save(JsonMap map) {
        if (this.manager != null) {
            map.add("manager", this.manager.toString());
        }
        if (this.staff != null) {
            JsonMap sta = map.getMap("staff");
            this.staff.forEach(staff -> {
                JsonMap stf = new JsonMap();
                staff.save(stf);
                sta.add(staff.uuid.toString(), (JsonValue)stf);
            });
        }
    }

    @Override
    public void load(JsonMap map) {
        this.manager = map.getUUID("manager", null);
        if (this.staff != null && map.has("staff")) {
            this.staff.clear();
            ((Map)map.getMap((String)"staff").value).forEach((key, val) -> {
                Staff stf = new Staff(UUID.fromString(key), this.actions);
                stf.load(val.asMap());
                this.staff.add(stf);
            });
        }
    }

    public boolean isManager(UUID uuid) {
        return uuid.equals(this.manager);
    }

    public boolean isManager(Staff staff) {
        return staff.uuid.equals(this.manager);
    }

    public boolean isStaff(UUID uuid) {
        for (Staff stf : this.staff) {
            if (!stf.uuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public Staff getStaff(UUID uuid) {
        for (Staff stf : this.staff) {
            if (!stf.uuid.equals(uuid)) continue;
            return stf;
        }
        return null;
    }

    public void removeStaff(UUID uuid) {
        this.staff.removeIf(stf -> stf.uuid.equals(uuid));
    }

    @Override
    public boolean can(PermAction act, UUID uuid) {
        if (!this.actions.isValid(act)) {
            return false;
        }
        if (this.manager != null && this.manager.equals(uuid)) {
            return true;
        }
        Staff sta = this.getStaff(uuid);
        return sta != null && sta.actions.get((Object)act) != false;
    }

    @Override
    public boolean can(UUID uuid, PermAction ... acts) {
        for (PermAction act : acts) {
            if (!this.actions.isValid(act)) continue;
            if (this.manager != null && this.manager.equals(uuid)) {
                return true;
            }
            Staff sta = this.getStaff(uuid);
            if (sta == null || !sta.actions.get((Object)act).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.manager = null;
        if (this.staff != null) {
            this.staff.clear();
        }
    }

    public void add(LDPlayer player) {
        if (this.staff == null) {
            return;
        }
        this.staff.add(new Staff(player.uuid, this.actions));
    }

    public void add(UUID uuid) {
        if (this.staff == null) {
            return;
        }
        this.staff.add(new Staff(uuid, this.actions));
    }

    public void setManager(LDPlayer player) {
        this.manager = player.uuid;
    }

    public void setManager(UUID uuid) {
        this.manager = uuid;
    }

    public String getManagerName() {
        if (this.manager == null) {
            return "none";
        }
        return ResManager.getPlayerName(this.manager);
    }

    public boolean hasManager() {
        return this.manager != null;
    }

    public UUID getManager() {
        return this.manager;
    }

    public void setNoManager() {
        this.manager = null;
    }

    public PermAction[] actions() {
        return this.actions.actions;
    }

    public static class Staff
    implements Saveable {
        public Map<PermAction, Boolean> actions = new LinkedHashMap<PermAction, Boolean>();
        public final UUID uuid;

        public Staff(UUID uiid, PermAction.PermActions pacts) {
            this.uuid = uiid;
            for (PermAction action : pacts.actions) {
                this.actions.put(action, false);
            }
        }

        @Override
        public void save(JsonMap map) {
            this.actions.forEach((key, val) -> map.add(key.name(), val.booleanValue()));
        }

        @Override
        public void load(JsonMap map) {
            map.entries().forEach(entry -> {
                PermAction act = PermAction.get((String)entry.getKey());
                if (this.actions.containsKey((Object)act)) {
                    this.actions.put(act, ((JsonValue)entry.getValue()).bool());
                }
            });
        }

        public String getPlayerName() {
            return ResManager.getPlayerName(this.uuid);
        }
    }
}

