/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.chunk;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.landdev.LandDev;
import net.fexcraft.mod.landdev.data.chunk.ChunkKey;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.db.JsonTagConverter;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.UniChunk;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class ChunkRegion {
    public static ConcurrentHashMap<ChunkKey, ChunkRegion> REGIONS = new ConcurrentHashMap();
    public ConcurrentHashMap<ChunkKey, Chunk_> chunks = new ConcurrentHashMap();
    private TagCW compound;
    private ChunkKey key;
    private File file;
    public long last_access;

    public ChunkRegion(ChunkKey rkey) {
        this.key = rkey;
        this.file = new File(String.valueOf(LandDev.SAVE_DIR) + "/chunks/" + this.key.toString() + ".nbt");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        this.compound = WrapperHolder.read((File)this.file);
        this.setLastAccess();
    }

    public static void save(Chunk_ ck) {
        ChunkRegion.getRegion(ck.region).saveChunk(ck);
    }

    private void saveChunk(Chunk_ ck) {
        this.chunks.put(ck.key, ck);
        JsonMap map = new JsonMap();
        ck.save(map);
        LandDev.log(map.toString());
        this.compound.set(ck.key.toString(), JsonTagConverter.map(TagCW.create(), map));
        this.setLastAccess();
    }

    private void loadChunk(Chunk_ ck) {
        this.chunks.put(ck.key, ck);
        TagCW tag = this.compound.getCompound(ck.key.toString());
        if (tag.empty()) {
            ck.gendef();
        }
        ck.load(JsonTagConverter.demap(tag));
        ResManager.CHUNKS.put(ck.key, ck);
        this.setLastAccess();
    }

    private void setLastAccess() {
        this.last_access = Time.getDate();
    }

    public static Chunk_ getFor(UniChunk uck) {
        ChunkKey key = new ChunkKey(uck.chunk.getX(), uck.chunk.getZ());
        ChunkRegion region = ChunkRegion.getRegion(key.asRegion());
        if (region.chunks.containsKey(key)) {
            Chunk_ ck = region.chunks.get(key);
            ck.uck = uck;
            ck.loaded = Time.getDate();
            region.setLastAccess();
            return ck;
        }
        Chunk_ ck = new Chunk_(uck);
        region.loadChunk(ck);
        region.setLastAccess();
        return ck;
    }

    public static void saveAll() {
        for (ChunkRegion value : REGIONS.values()) {
            value.save();
        }
    }

    private void save() {
        WrapperHolder.write((TagCW)this.compound, (File)this.file);
    }

    public static void saveRegions() {
        long offset = 300000L;
        long date = Time.getDate();
        ArrayList<ChunkKey> remreg = new ArrayList<ChunkKey>();
        for (ChunkRegion region : REGIONS.values()) {
            if (region.last_access + offset >= date) continue;
            region.chunks.values().removeIf(ck -> {
                if (ck.uck == null && ck.loaded + offset < date) {
                    region.saveChunk((Chunk_)ck);
                    return true;
                }
                return false;
            });
            region.save();
            if (!region.chunks.isEmpty()) continue;
            remreg.add(region.key);
        }
        for (ChunkKey key : remreg) {
            REGIONS.remove(key);
        }
    }

    public static void unload(Chunk_ ck) {
        ChunkRegion region = REGIONS.get(ck);
        if (region != null) {
            region.saveChunk(ck);
            ck.uck = null;
            ck.loaded = Time.getDate();
        }
    }

    public static Chunk_ get(int x, int z) {
        return ChunkRegion.get(new ChunkKey(x, z));
    }

    public static Chunk_ get(ChunkKey key) {
        ChunkRegion region = ChunkRegion.getRegion(key.asRegion());
        if (region.chunks.containsKey(key)) {
            region.setLastAccess();
            return region.chunks.get(key);
        }
        Chunk_ ck = new Chunk_(key);
        region.loadChunk(ck);
        return ck;
    }

    private static ChunkRegion getRegion(ChunkKey key) {
        ChunkRegion region = REGIONS.get(key);
        if (region == null) {
            region = new ChunkRegion(key);
            REGIONS.put(key, region);
        }
        return region;
    }
}

