/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.county;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.landdev.data.Citizens;
import net.fexcraft.mod.landdev.data.ColorData;
import net.fexcraft.mod.landdev.data.Createable;
import net.fexcraft.mod.landdev.data.IconHolder;
import net.fexcraft.mod.landdev.data.Joinable;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.data.Manageable;
import net.fexcraft.mod.landdev.data.NeighborData;
import net.fexcraft.mod.landdev.data.Norms;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.Sellable;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.hooks.ExternalData;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.norm.BoolNorm;
import net.fexcraft.mod.landdev.data.norm.FloatNorm;
import net.fexcraft.mod.landdev.data.norm.IntegerNorm;
import net.fexcraft.mod.landdev.data.norm.StringNorm;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.player.Permit;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.AppearModule;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.ui.modules.NormModule;
import net.fexcraft.mod.landdev.util.Announcer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.TranslationUtil;
import net.fexcraft.mod.uni.world.MessageSender;

public class County
implements Saveable,
Layer,
LDUIModule {
    public final int id;
    public Createable created = new Createable();
    public Sellable sell = new Sellable(this);
    public IconHolder icon = new IconHolder();
    public ColorData color = new ColorData();
    public NeighborData neighbors = new NeighborData();
    public MailData mail;
    public Manageable manage = new Manageable(true, PermAction.COUNTY_STAFF);
    public Norms norms = new Norms();
    public ArrayList<Integer> districts = new ArrayList();
    public ArrayList<Integer> municipalities = new ArrayList();
    public Citizens citizens = new Citizens(PermAction.COUNTY_CITIZEN);
    public Joinable requests = new Joinable();
    public ExternalData external = new ExternalData(this);
    public long tax_collected;
    public Account account;
    public Region region;
    public int seat = -1;
    public static final int UI_CREATE = -1;
    public static final int UI_STAFF_LIST = 1;
    public static final int UI_STAFF_EDIT = 2;
    public static final int UI_STAFF_ADD = 3;
    public static final int UI_CITIZEN_LIST = 4;
    public static final int UI_CITIZEN_EDIT = 5;
    public static final int UI_CITIZEN_INVITE = 6;
    public static final int UI_DISTRICTS = 7;
    public static final int UI_MUNICIPALITY_LIST = 8;
    public static final int UI_MUNICIPALITY_EDIT = 9;
    public static final int UI_MUNICIPALITY_INVITE = 10;
    public static final int UI_PRICE = 11;
    public static final int UI_SET_PRICE = 12;
    public static final int UI_NORMS = 13;
    public static final int UI_NORM_EDIT = 14;
    public static final int UI_APPREARANCE = 15;

    public County(int id) {
        this.id = id;
        this.mail = new MailData(this.getLayer(), id);
        this.account = DataManager.getAccount((String)("county:" + id), (boolean)false, (boolean)true);
        this.norms.add(new StringNorm("name", "Unnamed County"));
        this.norms.add(new BoolNorm("new-municipalities", false));
        this.norms.add(new IntegerNorm("new-municipality-fee", 100000));
        this.norms.add(new BoolNorm("open-to-join", true));
        this.norms.add(new FloatNorm("municipality-tax-percent", 10.0f));
        this.norms.add(new IntegerNorm("citizen-tax", 1000));
        this.norms.add(new BoolNorm("kick-bankrupt", false));
        this.norms.add(new IntegerNorm("min-municipality-distance", LDConfig.MIN_MUN_DIS));
    }

    @Override
    public void save(JsonMap map) {
        map.add("id", this.id);
        this.created.save(map);
        this.sell.save(map);
        this.icon.save(map);
        this.color.save(map);
        this.neighbors.save(map);
        this.mail.save(map);
        this.manage.save(map);
        this.citizens.save(map);
        this.requests.save(map);
        this.norms.save(map);
        JsonArray darray = new JsonArray();
        this.districts.forEach(dis -> darray.add(dis.intValue()));
        map.add("districts", (JsonValue)darray);
        JsonArray marray = new JsonArray();
        this.municipalities.forEach(mun -> marray.add(mun.intValue()));
        map.add("municipalities", (JsonValue)marray);
        map.add("region", this.region.id);
        map.add("tax_collected", this.tax_collected);
        if (this.seat >= 0) {
            map.add("seat", this.seat);
        }
        this.external.save(map);
        DataManager.save((Account)this.account);
    }

    @Override
    public void load(JsonMap map) {
        JsonArray array;
        this.created.load(map);
        this.sell.load(map);
        this.icon.load(map);
        this.color.load(map);
        this.neighbors.load(map);
        this.mail.load(map);
        this.manage.load(map);
        this.citizens.load(map);
        this.requests.load(map);
        this.norms.load(map);
        this.account.setName(this.name());
        if (map.has("districts")) {
            array = map.getArray("districts");
            this.districts.clear();
            ((List)array.value).forEach(elm -> this.districts.add(elm.integer_value()));
        }
        if (map.has("municipalities")) {
            array = map.getArray("municipalities");
            this.municipalities.clear();
            ((List)array.value).forEach(elm -> this.municipalities.add(elm.integer_value()));
        }
        this.region = ResManager.getRegion(map.getInteger("region", -1), true);
        this.tax_collected = map.getLong("tax_collected", 0L);
        this.seat = map.getInteger("seat", this.seat);
        this.external.load(map);
    }

    @Override
    public void gendef() {
        this.region = ResManager.getRegion(-1, true);
        if (this.id == -1) {
            this.norms.get("name").set("Wilderness");
            this.norms.get("new-municipalities").set(true);
            this.districts.clear();
            if (!this.region.counties.contains(this.id)) {
                this.region.counties.add(this.id);
            }
            this.color.set(39168);
        } else if (this.id == 0) {
            this.norms.get("name").set("Spawn County");
            this.districts.clear();
            this.districts.add(0);
            this.region = ResManager.getRegion(0, true);
            if (!this.region.counties.contains(this.id)) {
                this.region.counties.add(this.id);
            }
            this.color.set(0xFF9900);
            this.seat = 0;
        }
        this.external.gendef();
    }

    @Override
    public String saveId() {
        return "" + this.id;
    }

    @Override
    public String saveTable() {
        return "counties";
    }

    @Override
    public Layers getLayer() {
        return Layers.COUNTY;
    }

    @Override
    public Layers getParentLayer() {
        return Layers.REGION;
    }

    @Override
    public int lid() {
        return this.id;
    }

    public String name() {
        return this.norms.get("name").string();
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("county.title");
        LDPlayer player = container.ldp;
        boolean canman = this.manage.can(PermAction.MANAGE_COUNTY, container.ldp.uuid) || player.adm;
        switch (container.pos.x) {
            case 0: {
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("name", LDUIRow.ELM_GENERIC, canman ? LDUIButton.OPEN : LDUIButton.EMPTY, canman, this.name());
                if (this.seat >= 0) {
                    resp.addButton("seat", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, ResManager.getMunicipalityName(this.seat));
                }
                resp.addButton("region", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.region.name());
                resp.addButton("municipalities", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.municipalities.size());
                resp.addButton("districts", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.districts.size());
                resp.addButton("citizen", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.citizens.size());
                resp.addRow("manager", LDUIRow.ELM_GENERIC, this.manage.getManagerName());
                resp.addButton("staff", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.manage.staff.size());
                if (canman) {
                    resp.addRow("balance", LDUIRow.ELM_GENERIC, Config.getWorthAsString((long)this.account.getBalance()));
                }
                resp.addBlank();
                if (this.sell.price > 0L) {
                    resp.addButton("price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.sell.price_formatted());
                }
                if (canman) {
                    resp.addButton("set_price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                }
                if (this.sell.price > 0L) {
                    resp.addBlank();
                }
                if (canman) {
                    resp.addButton("mailbox", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.mail.unread());
                }
                resp.addButton("norms", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                resp.addButton("appearance", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                return;
            }
            case 7: {
                resp.setTitle("county.districts.title");
                for (int id : this.districts) {
                    resp.addButton("district." + id, LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!" + ResManager.getDistrictName(id));
                }
                return;
            }
            case 8: {
                resp.setTitle("county.municipality.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("seat", LDUIRow.ELM_GENERIC, this.seat >= 0 ? ResManager.getMunicipalityName(this.seat) : "");
                resp.addBlank();
                resp.addRow("municipality.list", LDUIRow.ELM_YELLOW);
                for (int id : this.municipalities) {
                    resp.addButton("municipality.edit." + id, LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!" + ResManager.getMunicipalityName(id));
                }
                return;
            }
            case 9: {
                resp.setTitle("county.municipality.edit.title");
                Municipality mun = ResManager.getMunicipality(this.municipalities.get(container.pos.z), true);
                resp.addRow("municipality.name", LDUIRow.ELM_GENERIC, mun.name());
                resp.addRow("municipality.id", LDUIRow.ELM_GENERIC, mun.id);
                resp.addButton("municipality.goto", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, mun.id);
                resp.addHiddenField("mun-id", mun.id);
                if (canman) {
                    resp.addBlank();
                    resp.addButton("municipality.setmain", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                    resp.addBlank();
                    resp.addButton("municipality.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                }
                resp.setNoSubmit();
                return;
            }
            case 4: {
                resp.setTitle("county.citizen.title");
                if (this.opentojoin()) {
                    resp.addRow("citizen.open", LDUIRow.ELM_GREEN);
                } else {
                    resp.addRow("citizen.closed", LDUIRow.ELM_RED);
                }
                if (this.manage.can(PermAction.PLAYER_INVITE, container.ldp.uuid) || player.adm) {
                    resp.addButton("citizen.invite", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                }
                if (container.ldp.county.id != this.id) {
                    long to = this.requests.get(container.ldp);
                    if (to > -1L) {
                        if (to > 0L) {
                            resp.addRow("citizen.rejected", LDUIRow.ELM_RED);
                            resp.addRow("citizen.timeout", LDUIRow.ELM_GREEN, Time.getAsString((long)to));
                        } else {
                            resp.addRow("citizen.pending", LDUIRow.ELM_GREEN);
                        }
                    } else if (this.opentojoin()) {
                        resp.addButton("citizen.join", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                    } else {
                        resp.addButton("citizen.request", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                    }
                } else {
                    resp.addButton("citizen.leave", LDUIRow.ELM_RED, LDUIButton.REM);
                }
                resp.addBlank();
                resp.addRow("citizen.list", LDUIRow.ELM_YELLOW);
                for (UUID uuid : this.citizens.map().keySet()) {
                    resp.addButton("citizen.edit." + String.valueOf(uuid), LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!- " + ResManager.getPlayerName(uuid));
                }
                return;
            }
            case 5: {
                resp.setTitle("county.citizen.edit.title");
                Citizens.Citizen cit = this.citizens.get(container.pos.z);
                resp.addRow("citizen.name", LDUIRow.ELM_GENERIC, cit.getPlayerName());
                resp.addRow("citizen.uuid", LDUIRow.ELM_GENERIC, cit.uuid);
                if (player.adm) {
                    resp.addButton("citizen.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                }
                resp.addHiddenField("uuid", cit.uuid);
                resp.addBlank();
                resp.addRow("citizen.permissions", LDUIRow.ELM_YELLOW);
                for (Map.Entry<PermAction, Boolean> entry : cit.actions.entrySet()) {
                    resp.addButton("citizen.permission." + entry.getKey().name().toLowerCase(), LDUIRow.ELM_GENERIC, LDUIButton.enabled(entry.getValue()));
                }
                resp.setNoSubmit();
                return;
            }
            case 6: {
                resp.setTitle("county.citizen.invite.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("citizen.invite.info", LDUIRow.ELM_YELLOW);
                resp.addField("citizen.invite.field");
                resp.addButton("citizen.invite.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                return;
            }
            case 2: {
                resp.setTitle("county.staff.edit.title");
                Manageable.Staff staff = this.manage.staff.get(container.pos.z);
                resp.addRow("staff.name", LDUIRow.ELM_GENERIC, staff.getPlayerName());
                resp.addRow("staff.uuid", LDUIRow.ELM_GENERIC, staff.uuid);
                if (player.adm || !this.manage.isManager(staff)) {
                    resp.addButton("staff.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                    resp.addButton("staff.setmanager", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                }
                resp.addHiddenField("uuid", staff.uuid);
                resp.addBlank();
                resp.addRow("staff.permissions", LDUIRow.ELM_YELLOW);
                for (Map.Entry<PermAction, Boolean> entry : staff.actions.entrySet()) {
                    resp.addButton("staff.permission." + entry.getKey().name().toLowerCase(), LDUIRow.ELM_GENERIC, LDUIButton.enabled(entry.getValue()));
                }
                resp.setNoSubmit();
                return;
            }
            case 1: {
                resp.setTitle("county.staff.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("manager", LDUIRow.ELM_GENERIC, this.manage.getManagerName());
                resp.addButton("staff.add", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                resp.addBlank();
                resp.addRow("staff.list", LDUIRow.ELM_YELLOW);
                for (Manageable.Staff staff : this.manage.staff) {
                    resp.addButton("staff.edit." + String.valueOf(staff.uuid), LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!- " + staff.getPlayerName());
                }
                return;
            }
            case 3: {
                resp.setTitle("county.staff.add.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("staff.add.info", LDUIRow.ELM_YELLOW);
                resp.addField("staff.add.field");
                resp.addButton("staff.add.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                return;
            }
            case 15: {
                AppearModule.resp(container, resp, "county", this.icon, this.color, canman);
                return;
            }
            case 13: {
                NormModule.respNormList(this.norms, container, resp, "county", canman);
                return;
            }
            case 14: {
                NormModule.respNormEdit(this.norms, container, resp, "county", canman);
                return;
            }
            case -1: {
                resp.setTitle("county.create.title");
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                Region region = chunk.district.region();
                boolean rn = region.norms.get("new-counties").bool();
                boolean pp = container.ldp.hasPermit(PermAction.CREATE_COUNTY, region.getLayer(), region.id);
                if (!rn && !pp) {
                    resp.addRow("create.no_perm", LDUIRow.ELM_GENERIC, LDUIButton.BLANK);
                    return;
                }
                resp.addRow("create.name", LDUIRow.ELM_GENERIC);
                resp.addField("create.name_field");
                resp.addCheck("create.region_funded", LDUIRow.ELM_GENERIC, pp);
                if (chunk.district.id >= 0) {
                    resp.addCheck("create.integrate_district", LDUIRow.ELM_GENERIC, pp);
                }
                if (chunk.district.municipality() != null) {
                    resp.addCheck("create.municipality_funded", LDUIRow.ELM_GENERIC, pp);
                    resp.addCheck("create.integrate_municipality", LDUIRow.ELM_GENERIC, pp);
                }
                resp.addButton("create.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
                resp.setFormular();
                resp.setNoBack();
                return;
            }
        }
        this.external.sync_packet(container, resp);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        Manageable.Staff staff;
        LDPlayer player = container.ldp;
        boolean canman = this.manage.can(PermAction.MANAGE_MUNICIPALITY, container.ldp.uuid) || player.adm;
        switch (req.event()) {
            case "name": {
                if (!canman) {
                    return;
                }
                container.open(14, this.id, this.norms.index(this.norms.get("name")));
                return;
            }
            case "seat": {
                if (this.seat >= 0) {
                    container.open(LDKeys.MUNICIPALITY, 0, this.seat, 0);
                }
                return;
            }
            case "region": {
                container.open(LDKeys.REGION, 0, this.region.id, 0);
                return;
            }
            case "citizen": {
                container.open(4);
                return;
            }
            case "municipalities": {
                container.open(8);
                return;
            }
            case "districts": {
                container.open(7);
                return;
            }
            case "staff": {
                container.open(1);
                return;
            }
            case "price": {
                container.open(11);
                return;
            }
            case "set_price": {
                if (canman) {
                    container.open(12);
                }
                return;
            }
            case "mailbox": {
                if (canman) {
                    container.open(LDKeys.MAILBOX, this.getLayer().ordinal(), this.id, 0);
                }
                return;
            }
            case "norms": {
                container.open(13);
                return;
            }
            case "appearance": {
                container.open(15);
                return;
            }
            case "municipality.goto": {
                int mun = req.getFieldInt("mun-id");
                if (!this.municipalities.contains(mun)) {
                    return;
                }
                container.open(LDKeys.MUNICIPALITY, 0, mun, 0);
                return;
            }
            case "municipality.setmain": {
                if (!canman) {
                    return;
                }
                int mun = req.getFieldInt("mun-id");
                if (!this.municipalities.contains(mun)) {
                    return;
                }
                Municipality muni = ResManager.getMunicipality(mun, true);
                if (muni.county.id != this.id) {
                    return;
                }
                this.seat = muni.id;
                container.open(8);
                return;
            }
            case "municipality.remove": {
                if (!canman) {
                    return;
                }
                int mun = req.getFieldInt("mun-id");
                if (!this.municipalities.contains(mun)) {
                    return;
                }
                if (this.municipalities.size() < 2) {
                    container.msg("municipality.only_one");
                    return;
                }
                if (this.seat == mun) {
                    container.msg("municipality.setnew");
                    return;
                }
                Municipality muni = ResManager.getMunicipality(mun, true);
                muni.county = ResManager.getCounty(-1, true);
                for (UUID uuid : muni.citizens.map().keySet()) {
                    this.manage.removeStaff(uuid);
                    this.citizens.remove(uuid);
                }
                muni.save();
                this.save();
                Announcer.announce(Announcer.Target.MUNICIPALITY, this.id, "announce.county.municipality.removed", muni.name(), this.name(), this.id);
                container.open(8);
                return;
            }
            case "citizen.invite": {
                container.open(6);
                return;
            }
            case "citizen.join": {
                if (!this.opentojoin()) {
                    return;
                }
                if (player.isMunicipalityManager() && player.municipality.county.id != this.id) {
                    container.msg("landdev.mail.municipality.citizen.ismanager", false);
                    return;
                }
                if (player.isCountyManager() && this.id != player.county.id) {
                    container.msg("landdev.mail.county.citizen.ismanager", false);
                    return;
                }
                player.setCitizenOf(this);
                container.open(0);
                return;
            }
            case "citizen.leave": {
                if (player.isCountyManager() && !player.adm) {
                    container.msg("landdev.mail.county.citizen.ismanager", false);
                    return;
                }
                if (player.municipality.county.id == this.id) {
                    container.msg("landdev.mail.county.citizen.isinsame", false);
                    return;
                }
                if (player.isCountyManager()) {
                    this.manage.setManager((UUID)null);
                }
                player.leaveCounty();
                container.open(0);
                return;
            }
            case "citizen.request": {
                if (this.opentojoin()) {
                    return;
                }
                Mail mail = new Mail(MailType.REQUEST, Layers.PLAYER, player.uuid, Layers.COUNTY, this.id);
                mail.setTitle(player.name_raw()).expireInDays(7);
                mail.addMessage(TranslationUtil.translate("mail.player.county.join_request0", player.name_raw()));
                mail.addMessage(TranslationUtil.translate("mail.player.county.join_request1", new Object[0]));
                this.mail.mails.add(mail);
                this.requests.timeouts.put(player.uuid, 0L);
                container.open(4);
                return;
            }
            case "citizen.invite.submit": {
                if (!this.manage.can(PermAction.PLAYER_INVITE, player.uuid) && !player.adm) {
                    return;
                }
                LDPlayer ply = req.getPlayerField("citizen.invite.field");
                if (ply == null) {
                    container.msg("citizen.invite.notfound");
                    return;
                }
                Mail mail = new Mail(MailType.INVITE, Layers.COUNTY, this.id, Layers.PLAYER, ply.uuid);
                mail.setTitle(this.name()).expireInDays(7);
                mail.addMessage(TranslationUtil.translate("mail.county.citizen.invite0", new Object[0]));
                mail.addMessage(TranslationUtil.translate("mail.county.citizen.invite1", this.name()));
                ply.addMailAndSave(mail);
                player.entity.send(TranslationUtil.translate("gui.county.citizen.invite.success", new Object[0]));
                player.entity.closeUI();
                return;
            }
            case "citizen.remove": {
                if (!canman) {
                    return;
                }
                Citizens.Citizen cit = this.citizens.get(req.getUUIDField());
                if (cit != null && !this.manage.isManager(cit.uuid)) {
                    LDPlayer ply = ResManager.getPlayer(cit.uuid, true);
                    if (ply.municipality.county.id == this.id) {
                        container.msg("citizen.remove.isinsame");
                        return;
                    }
                    ply.setCitizenOf(ResManager.getCounty(-1, true));
                    Mail mail = new Mail(MailType.SYSTEM, Layers.COUNTY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.county.citizen.nolonger", new Object[0]));
                    ply.addMailAndSave(mail);
                    mail = new Mail(MailType.SYSTEM, Layers.COUNTY, this.id, Layers.COUNTY, this.id).expireInDays(7);
                    mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.county.citizen.removed", cit.getPlayerName()));
                    this.mail.mails.add(mail);
                    Announcer.announce(Announcer.Target.COUNTY, this.id, "announce.county.citizen.removed", cit.getPlayerName(), this.name(), this.id);
                }
                container.open(4);
                return;
            }
            case "staff.add": {
                container.open(3);
                return;
            }
            case "staff.add.submit": {
                if (!canman) {
                    return;
                }
                LDPlayer ply = req.getPlayerField("staff.add.field");
                if (ply == null) {
                    container.msg("staff.add.notfound");
                    return;
                }
                if (!this.citizens.isCitizen(ply.uuid)) {
                    container.msg("staff.add.notmember");
                    return;
                }
                Mail mail = new Mail(MailType.INVITE, Layers.COUNTY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                mail.setTitle(this.name()).setStaffInvite();
                mail.addMessage(TranslationUtil.translate("mail.county.staff.invite0", new Object[0]));
                mail.addMessage(TranslationUtil.translate("mail.county.staff.invite1", new Object[0]));
                ply.addMailAndSave(mail);
                player.entity.send(TranslationUtil.translate("gui.county.staff.add.success", new Object[0]));
                player.entity.closeUI();
                return;
            }
            case "staff.remove": {
                if (!canman) {
                    return;
                }
                Manageable.Staff staff2 = this.manage.getStaff(req.getUUIDField());
                if (staff2 != null && !this.manage.isManager(staff2)) {
                    this.manage.removeStaff(staff2.uuid);
                    LDPlayer ply = ResManager.getPlayer(staff2.uuid, true);
                    Mail mail = new Mail(MailType.SYSTEM, Layers.COUNTY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.county.staff.nolonger", new Object[0]));
                    ply.addMailAndSave(mail);
                    for (Manageable.Staff stf : this.manage.staff) {
                        LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                        mail = new Mail(MailType.SYSTEM, Layers.COUNTY, this.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                        mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.county.staff.removed", staff2.getPlayerName()));
                        stp.addMailAndSave(mail);
                    }
                    Announcer.announce(Announcer.Target.COUNTY, this.id, "announce.county.staff.removed", staff2.getPlayerName(), this.name(), this.id);
                }
                container.open(1);
                return;
            }
            case "staff.setmanager": {
                if (!player.adm && !canman) {
                    return;
                }
                Manageable.Staff staff3 = this.manage.getStaff(req.getUUIDField());
                if (staff3 != null) {
                    this.manage.setManager(staff3.uuid);
                    LDPlayer ply = ResManager.getPlayer(staff3.uuid, true);
                    Mail mail = new Mail(MailType.SYSTEM, Layers.COUNTY, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.county.manager_now", new Object[0]));
                    ply.addMailAndSave(mail);
                    this.save();
                    for (Manageable.Staff stf : this.manage.staff) {
                        LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                        mail = new Mail(MailType.SYSTEM, Layers.COUNTY, this.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                        mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.county.manager_set", staff3.getPlayerName()));
                        stp.addMailAndSave(mail);
                    }
                    Announcer.announce(Announcer.Target.COUNTY, this.id, "announce.county.manager_set", staff3.getPlayerName(), this.name(), this.id);
                }
                container.open(0);
                return;
            }
            case "create.submit": {
                Account acc;
                Permit perm;
                Municipality mun;
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                Region region = chunk.district.region();
                long sum = LDConfig.COUNTY_CREATION_FEE;
                boolean rn = region.norms.get("new-counties").bool();
                boolean pp = player.hasPermit(PermAction.CREATE_COUNTY, region.getLayer(), region.id);
                if (!rn && !pp) {
                    player.entity.send(TranslationUtil.translateCmd("ct.no_new_counties", new Object[0]));
                    player.entity.send(TranslationUtil.translateCmd("ct.no_create_permit", new Object[0]));
                    player.entity.closeUI();
                    return;
                }
                boolean cd = req.getCheck("create.integrate_district");
                boolean cm = req.getCheck("create.integrate_municipality");
                boolean fm = req.getCheck("create.municipality_funded");
                Municipality municipality = mun = cm ? chunk.district.municipality() : null;
                if (cm && mun == null) {
                    return;
                }
                if (!cm && player.isInManagement(Layers.MUNICIPALITY)) {
                    container.msg("create.leave_municipality_management");
                    return;
                }
                if (player.isInManagement(Layers.COUNTY)) {
                    container.msg("create.leave_county_management");
                    return;
                }
                if (player.isInManagement(Layers.REGION) && player.county.region.id != region.id) {
                    container.msg("create.leave_region_management");
                    return;
                }
                String name = req.getField("create.name_field");
                if (!this.validateName(container, name)) {
                    return;
                }
                boolean ura = req.getCheck("create.region_funded");
                if (!pp && !ura) {
                    sum += (long)region.norms.get("new-county-fee").integer();
                }
                Permit permit = perm = pp ? player.getPermit(PermAction.CREATE_COUNTY_FUND, region.getLayer(), region.id) : null;
                if (!pp && ura) {
                    container.msg("create.no_fund_permit");
                    return;
                }
                Account account = pp && ura ? perm.getAccount() : (acc = cm && fm ? mun.account : player.account);
                if (acc.getBalance() < sum) {
                    container.msg("create.not_enough_money");
                    return;
                }
                if (cd && !chunk.district.norms.get("county-can-form").bool()) {
                    container.msg("create.district_no_forming");
                    return;
                }
                if (cd && chunk.district.municipality() != null && chunk.district.municipality().districts.size() == 1) {
                    container.msg("create.only_district");
                    return;
                }
                if (!cd && !cm && chunk.district.id >= 0) {
                    container.msg("create.chunk_is_claimed");
                    return;
                }
                if (cm && !mun.manage.isManager(player.uuid)) {
                    container.msg("create.municipality_not_manager");
                    return;
                }
                int newid = ResManager.getNewIdFor(this.saveTable());
                int ndid = -2;
                if (newid < 0) {
                    player.entity.send("DB ERROR, INVALID NEW ID '" + newid + "'!");
                    return;
                }
                if (!cd && (ndid = ResManager.getNewIdFor(chunk.district.saveTable())) < 0) {
                    player.entity.send("DB ERROR, INVALID NEW DISTRICT ID '" + newid + "'!");
                    return;
                }
                if (!acc.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)player.entity, acc, sum, ResManager.SERVER_ACCOUNT)) {
                    return;
                }
                if (!ura) {
                    ResManager.SERVER_ACCOUNT.getBank().processAction(Bank.Action.TRANSFER, null, ResManager.SERVER_ACCOUNT, (long)region.norms.get("new-county-fee").integer(), region.account);
                }
                County nct = new County(newid);
                nct.created.create(player.uuid);
                ResManager.CT_CENTERS.put(nct.id, chunk.key);
                nct.gendef();
                ResManager.COUNTIES.put(nct.id, nct);
                nct.norms.get("name").set(name);
                nct.region = region;
                region.counties.add(nct.id);
                nct.manage.add(player);
                nct.manage.setManager(player);
                nct.citizens.add(player);
                if (!cm) {
                    if (cd) {
                        nct.districts.add(chunk.district.id);
                        chunk.district.owner.set(nct);
                        chunk.district.manage.clear();
                        chunk.district.save();
                    } else {
                        District dis = new District(ndid);
                        dis.created.create(player.uuid);
                        ResManager.DISTRICTS.put(dis.id, dis);
                        nct.districts.add(dis.id);
                        chunk.district = dis;
                        chunk.owner.set(Layers.COUNTY, null, nct.id);
                        chunk.sell.price = 0L;
                        chunk.save();
                        dis.owner.set(nct);
                        dis.save();
                    }
                } else {
                    for (UUID uuid : mun.county.citizens.get().keySet()) {
                        mun.county.citizens.remove(uuid);
                        nct.citizens.add(uuid);
                    }
                    mun.county = nct;
                    nct.municipalities.add(mun.id);
                    nct.seat = mun.id;
                    mun.save();
                }
                ResManager.SERVER_ACCOUNT.getBank().processAction(Bank.Action.TRANSFER, null, ResManager.SERVER_ACCOUNT, LDConfig.COUNTY_CREATION_FEE / 2L, nct.account);
                ResManager.bulkSave(nct, region, player);
                player.entity.closeUI();
                player.entity.send(TranslationUtil.translate("gui.county.create.complete", new Object[0]));
                Announcer.announce(Announcer.Target.GLOBAL, 0, "announce.county.created", name, newid);
                return;
            }
            case "norm_submit": {
                if (!canman) {
                    return;
                }
                NormModule.processNorm(this.norms, container, req, 14);
                return;
            }
            case "norm_bool": {
                if (!canman) {
                    return;
                }
                NormModule.processBool(this.norms, container, req, 14);
                return;
            }
            case "appearance.submit": {
                if (!canman) {
                    return;
                }
                if (AppearModule.req(container, req, this.icon, this.color)) {
                    container.open(0);
                }
                return;
            }
        }
        if (NormModule.isNormReq(this.norms, container, req, 14, this.id)) {
            return;
        }
        if (req.event().startsWith("district.")) {
            int id = Integer.parseInt(req.event().substring("district.".length()));
            container.open(LDKeys.DISTRICT, 0, id, 0);
            return;
        }
        if (req.event().startsWith("staff.edit.")) {
            staff = this.manage.getStaff(UUID.fromString(req.event().substring("staff.edit.".length())));
            if (staff == null) {
                return;
            }
            container.open(2, this.id, this.manage.staff.indexOf(staff));
            return;
        }
        if (req.event().startsWith("staff.permission.")) {
            if (!canman) {
                return;
            }
            staff = this.manage.getStaff(req.getUUIDField());
            if (this.manage.isManager(staff)) {
                container.msg("staff.permissions.ismanager");
                return;
            }
            PermAction action = PermAction.get(req.event().substring("staff.permission.".length()).toUpperCase());
            if (action == null) {
                return;
            }
            staff.actions.put(action, staff.actions.get((Object)action) == false);
            container.open(2);
            return;
        }
        if (req.event().startsWith("citizen.edit.")) {
            UUID uuid = UUID.fromString(req.event().substring("citizen.edit.".length()));
            if (!this.citizens.isCitizen(uuid)) {
                return;
            }
            container.open(5, this.id, this.citizens.indexOf(uuid));
            return;
        }
        if (req.event().startsWith("citizen.permission.")) {
            if (!canman) {
                return;
            }
            Citizens.Citizen cit = this.citizens.get(req.getUUIDField());
            PermAction action = PermAction.get(req.event().substring("citizen.permission.".length()).toUpperCase());
            if (action == null) {
                return;
            }
            cit.actions.put(action, cit.actions.get((Object)action) == false);
            container.open(5);
            return;
        }
        if (req.event().startsWith("municipality.edit.")) {
            int mun = Integer.parseInt(req.event().substring("municipality.edit.".length()));
            if (!this.municipalities.contains(mun)) {
                return;
            }
            container.open(9, this.id, this.municipalities.indexOf(mun));
            return;
        }
        this.external.on_interact(container, req);
    }

    public boolean opentojoin() {
        return this.norms.get("open-to-join").bool();
    }
}

