/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.hooks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.hooks.ExternalSaveable;
import net.fexcraft.mod.landdev.data.hooks.LDUISubModule;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;

public class ExternalData
implements Saveable,
LDUIModule {
    public static final HashMap<Layers, ArrayList<Class<? extends ExternalSaveable>>> REGISTRY = new HashMap();
    public List<ExternalSaveable> saveables = new ArrayList<ExternalSaveable>();
    public List<LDUISubModule> modules = new ArrayList<LDUISubModule>();
    public final LDUIModule module;

    public ExternalData(LDUIModule module) {
        this.module = module;
        for (Class<? extends ExternalSaveable> clazz : REGISTRY.get((Object)((Layer)((Object)module)).getLayer())) {
            try {
                ExternalSaveable save = clazz.newInstance();
                this.saveables.add(save);
                if (save instanceof LDUISubModule) {
                    this.modules.add((LDUISubModule)((Object)save));
                }
                save.setup((Layer)((Object)module));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void save(JsonMap map) {
        JsonMap exdata = new JsonMap();
        for (Saveable saveable : this.saveables) {
            saveable.save(exdata);
        }
        if (!((Map)exdata.value).isEmpty()) {
            map.add("external", (JsonValue)map);
        }
    }

    @Override
    public void load(JsonMap map) {
        if (!map.has("external")) {
            return;
        }
        JsonMap exdata = map.getMap("external");
        for (Saveable saveable : this.saveables) {
            saveable.load(exdata);
        }
    }

    @Override
    public void gendef() {
        for (Saveable saveable : this.saveables) {
            saveable.gendef();
        }
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        for (LDUISubModule submod : this.modules) {
            if (!submod.sync_packet(this.module, container, resp)) continue;
            return;
        }
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        for (LDUISubModule submod : this.modules) {
            if (!submod.on_interact(this.module, container, req)) continue;
            return;
        }
    }

    public ExternalSaveable get(String id) {
        for (ExternalSaveable save : this.saveables) {
            if (!save.id().equals(id)) continue;
            return save;
        }
        return null;
    }

    public <ES> ES getCasted(String id) {
        for (ExternalSaveable save : this.saveables) {
            if (!save.id().equals(id)) continue;
            return (ES)save;
        }
        return null;
    }

    static {
        for (Layers layer : Layers.values()) {
            REGISTRY.put(layer, new ArrayList());
        }
    }
}

