/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.norm;

import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.data.norm.Norm;
import net.fexcraft.mod.landdev.data.norm.NormType;

public class BoolNorm
extends Norm {
    private boolean value;

    public BoolNorm(String id, boolean def) {
        super(id, NormType.BOOLEAN);
        this.value = def;
    }

    @Override
    public String string() {
        return "" + this.value;
    }

    @Override
    public int integer() {
        return this.value ? 1 : 0;
    }

    @Override
    public float decimal() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public boolean bool() {
        return this.value;
    }

    @Override
    public JsonValue save() {
        return new JsonValue((Object)this.value);
    }

    @Override
    public void load(JsonValue obj) {
        this.value = obj.bool();
    }

    @Override
    public void set(Object val) {
        if (val instanceof Boolean) {
            this.value = (Boolean)val;
        }
        if (val instanceof String) {
            this.value = val.toString().toLowerCase().equals("true");
        }
        if (val instanceof Number) {
            this.value = ((Number)val).intValue() > 0;
        }
    }

    @Override
    public Norm copy() {
        return new BoolNorm(this.id, this.value);
    }

    @Override
    public void toggle() {
        this.value = !this.value;
    }
}

