/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.player;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.util.ResManager;

public class Permit
implements Saveable {
    public PermAction action;
    public long expiry;
    public long issued;
    public int uses;
    public int used;
    public int origin_id;
    public Layers origin_layer;
    public Layers account;

    @Override
    public void save(JsonMap map) {
        map.add("action", this.action.name());
        map.add("expiry", this.expiry);
        map.add("issued", this.issued);
        map.add("uses", this.uses);
        map.add("used", this.used);
        map.add("from_id", this.origin_id);
        map.add("from_layer", this.origin_layer.name());
    }

    @Override
    public void load(JsonMap map) {
        this.action = PermAction.valueOf(map.getString("action", null));
        this.expiry = map.getLong("expiry", 0L);
        this.issued = map.getLong("issued", 0L);
        this.uses = map.getInteger("uses", 0);
        this.used = map.getInteger("used", 0);
        this.origin_id = map.getInteger("origin_id", -1);
        this.origin_layer = Layers.valueOf(map.getString("from_layer", "NONE"));
    }

    public Account getAccount() {
        switch (this.origin_layer) {
            case DISTRICT: {
                District dis = ResManager.getDistrict(this.origin_id);
                if (dis == null) break;
                return dis.account();
            }
            case MUNICIPALITY: {
                Municipality mun = ResManager.getMunicipality(this.origin_id, false);
                if (mun == null) break;
                return mun.account;
            }
            case COUNTY: {
                County ct = ResManager.getCounty(this.origin_id, false);
                if (ct == null) break;
                return ct.account;
            }
            case REGION: {
                Region st = ResManager.getRegion(this.origin_id, false);
                if (st == null) break;
                return st.account;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public boolean expired() {
        return this.used >= this.uses || Time.getDate() > this.expiry;
    }
}

