/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data.region;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fsmm.data.Account;
import net.fexcraft.mod.fsmm.data.Bank;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.fsmm.util.DataManager;
import net.fexcraft.mod.landdev.data.ColorData;
import net.fexcraft.mod.landdev.data.Createable;
import net.fexcraft.mod.landdev.data.IconHolder;
import net.fexcraft.mod.landdev.data.Layer;
import net.fexcraft.mod.landdev.data.Layers;
import net.fexcraft.mod.landdev.data.Mail;
import net.fexcraft.mod.landdev.data.MailData;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.data.Manageable;
import net.fexcraft.mod.landdev.data.NeighborData;
import net.fexcraft.mod.landdev.data.Norms;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.data.Sellable;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.hooks.ExternalData;
import net.fexcraft.mod.landdev.data.norm.BoolNorm;
import net.fexcraft.mod.landdev.data.norm.FloatNorm;
import net.fexcraft.mod.landdev.data.norm.IntegerNorm;
import net.fexcraft.mod.landdev.data.norm.StringNorm;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.ui.BaseCon;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.AppearModule;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.ui.modules.NormModule;
import net.fexcraft.mod.landdev.util.Announcer;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.TranslationUtil;
import net.fexcraft.mod.uni.world.MessageSender;

public class Region
implements Saveable,
Layer,
LDUIModule {
    public final int id;
    public Createable created = new Createable();
    public Sellable sell = new Sellable(this);
    public IconHolder icon = new IconHolder();
    public ColorData color = new ColorData();
    public NeighborData neighbors = new NeighborData();
    public MailData mail;
    public Manageable manage = new Manageable(true, PermAction.REGION_STAFF);
    public Norms norms = new Norms();
    public ArrayList<Integer> counties = new ArrayList();
    public ExternalData external = new ExternalData(this);
    public long tax_collected;
    public Account account;
    public int seat = -1;
    public static final int UI_CREATE = -1;
    public static final int UI_STAFF_LIST = 1;
    public static final int UI_STAFF_EDIT = 2;
    public static final int UI_STAFF_ADD = 3;
    public static final int UI_COUNTY_LIST = 4;
    public static final int UI_COUNTY_EDIT = 5;
    public static final int UI_COUNTY_INVITE = 6;
    public static final int UI_PRICE = 7;
    public static final int UI_SET_PRICE = 8;
    public static final int UI_NORMS = 9;
    public static final int UI_NORM_EDIT = 10;
    public static final int UI_APPREARANCE = 11;

    public Region(int id) {
        this.id = id;
        this.mail = new MailData(this.getLayer(), id);
        this.account = DataManager.getAccount((String)("region:" + id), (boolean)false, (boolean)true);
        this.norms.add(new StringNorm("name", "Unnamed Region"));
        this.norms.add(new BoolNorm("new-counties", false));
        this.norms.add(new IntegerNorm("new-county-fee", 1000000));
        this.norms.add(new FloatNorm("county-tax-percent", 10.0f));
    }

    @Override
    public void save(JsonMap map) {
        map.add("id", this.id);
        this.created.save(map);
        this.sell.save(map);
        this.icon.save(map);
        this.color.save(map);
        this.neighbors.save(map);
        this.mail.save(map);
        this.manage.save(map);
        this.norms.save(map);
        this.account.setName(this.name());
        JsonArray array = new JsonArray();
        this.counties.forEach(mun -> array.add(mun.intValue()));
        map.add("counties", (JsonValue)array);
        map.add("tax_collected", this.tax_collected);
        if (this.seat >= 0) {
            map.add("seat", this.seat);
        }
        this.external.save(map);
        DataManager.save((Account)this.account);
    }

    @Override
    public void load(JsonMap map) {
        this.created.load(map);
        this.sell.load(map);
        this.icon.load(map);
        this.color.load(map);
        this.neighbors.load(map);
        this.mail.load(map);
        this.manage.load(map);
        this.norms.load(map);
        if (map.has("counties")) {
            JsonArray array = map.getArray("counties");
            this.counties.clear();
            ((List)array.value).forEach(elm -> this.counties.add(elm.integer_value()));
        }
        this.tax_collected = map.getLong("tax_collected", 0L);
        this.seat = map.getInteger("seat", -1);
        this.external.load(map);
    }

    @Override
    public void gendef() {
        if (this.id == -1) {
            this.norms.get("name").set("Wilderness");
            this.norms.get("new-counties").set(true);
            this.counties.clear();
            this.counties.add(-1);
            this.color.set(39168);
            this.seat = -1;
        } else if (this.id == 0) {
            this.norms.get("name").set("Spawn Region");
            this.counties.clear();
            this.counties.add(0);
            this.color.set(0xFF9900);
            this.seat = 0;
        }
        this.external.gendef();
    }

    @Override
    public String saveId() {
        return "" + this.id;
    }

    @Override
    public String saveTable() {
        return "regions";
    }

    @Override
    public Layers getLayer() {
        return Layers.REGION;
    }

    @Override
    public Layers getParentLayer() {
        return Layers.INTER;
    }

    @Override
    public int lid() {
        return this.id;
    }

    public String name() {
        return this.norms.get("name").string();
    }

    @Override
    public void sync_packet(BaseCon container, ModuleResponse resp) {
        resp.setTitle("region.title");
        LDPlayer player = container.ldp;
        boolean canman = this.manage.can(PermAction.MANAGE_REGION, container.ldp.uuid) || player.adm;
        switch (container.pos.x) {
            case 0: {
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("name", LDUIRow.ELM_GENERIC, canman ? LDUIButton.OPEN : LDUIButton.EMPTY, canman, this.name());
                if (this.seat >= 0) {
                    resp.addButton("seat", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, ResManager.getCountyName(this.seat));
                }
                resp.addButton("counties", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.counties.size());
                resp.addRow("manager", LDUIRow.ELM_GENERIC, this.manage.getManagerName());
                resp.addButton("staff", LDUIRow.ELM_GENERIC, LDUIButton.LIST, this.manage.staff.size());
                if (canman) {
                    resp.addRow("balance", LDUIRow.ELM_GENERIC, Config.getWorthAsString((long)this.account.getBalance()));
                }
                resp.addBlank();
                if (this.sell.price > 0L) {
                    resp.addButton("price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.sell.price_formatted());
                }
                if (canman) {
                    resp.addButton("set_price", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                }
                if (this.sell.price > 0L) {
                    resp.addBlank();
                }
                if (canman) {
                    resp.addButton("mailbox", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, this.mail.unread());
                }
                resp.addButton("norms", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                resp.addButton("appearance", LDUIRow.ELM_YELLOW, LDUIButton.OPEN);
                return;
            }
            case 4: {
                resp.setTitle("region.county.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("seat", LDUIRow.ELM_GENERIC, this.seat >= 0 ? ResManager.getMunicipalityName(this.seat) : "");
                resp.addBlank();
                resp.addRow("county.list", LDUIRow.ELM_YELLOW);
                for (int id : this.counties) {
                    resp.addButton("county.edit." + id, LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!" + ResManager.getCountyName(id));
                }
                return;
            }
            case 5: {
                resp.setTitle("region.county.edit.title");
                County ct = ResManager.getCounty(this.counties.get(container.pos.z), true);
                resp.addRow("county.name", LDUIRow.ELM_GENERIC, ct.name());
                resp.addRow("county.id", LDUIRow.ELM_GENERIC, ct.id);
                resp.addButton("county.goto", LDUIRow.ELM_GENERIC, LDUIButton.OPEN, ct.id);
                resp.addHiddenField("ct-id", ct.id);
                if (canman) {
                    resp.addBlank();
                    resp.addButton("county.setmain", LDUIRow.ELM_GREEN, LDUIButton.OPEN);
                    resp.addBlank();
                    resp.addButton("county.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                }
                resp.setNoSubmit();
                return;
            }
            case 2: {
                resp.setTitle("region.staff.edit.title");
                Manageable.Staff staff = this.manage.staff.get(container.pos.z);
                resp.addRow("staff.name", LDUIRow.ELM_GENERIC, staff.getPlayerName());
                resp.addRow("staff.uuid", LDUIRow.ELM_GENERIC, staff.uuid);
                if (player.adm || !this.manage.isManager(staff)) {
                    resp.addButton("staff.remove", LDUIRow.ELM_RED, LDUIButton.REM);
                    resp.addButton("staff.setmanager", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                }
                resp.addHiddenField("uuid", staff.uuid);
                resp.addBlank();
                resp.addRow("staff.permissions", LDUIRow.ELM_YELLOW);
                for (Map.Entry<PermAction, Boolean> entry : staff.actions.entrySet()) {
                    resp.addButton("staff.permission." + entry.getKey().name().toLowerCase(), LDUIRow.ELM_GENERIC, LDUIButton.enabled(entry.getValue()));
                }
                resp.setNoSubmit();
                return;
            }
            case 1: {
                resp.setTitle("region.staff.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("manager", LDUIRow.ELM_GENERIC, this.manage.getManagerName());
                resp.addButton("staff.add", LDUIRow.ELM_BLUE, LDUIButton.ADD);
                resp.addBlank();
                resp.addRow("staff.list", LDUIRow.ELM_YELLOW);
                for (Manageable.Staff staff : this.manage.staff) {
                    resp.addButton("staff.edit." + String.valueOf(staff.uuid), LDUIRow.ELM_GENERIC, LDUIButton.OPEN, "!!!- " + staff.getPlayerName());
                }
                return;
            }
            case 3: {
                resp.setTitle("region.staff.add.title");
                resp.addRow("id", LDUIRow.ELM_GENERIC, this.id);
                resp.addRow("staff.add.info", LDUIRow.ELM_YELLOW);
                resp.addField("staff.add.field");
                resp.addButton("staff.add.submit", LDUIRow.ELM_GENERIC, LDUIButton.OPEN);
                resp.setFormular();
                return;
            }
            case 11: {
                AppearModule.resp(container, resp, "region", this.icon, this.color, canman);
                return;
            }
            case 9: {
                NormModule.respNormList(this.norms, container, resp, "region", canman);
                return;
            }
            case 10: {
                NormModule.respNormEdit(this.norms, container, resp, "region", canman);
                return;
            }
            case -1: {
                resp.setTitle("region.create.title");
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                Region region = chunk.district.region();
                boolean rn = LDConfig.NEW_REGIONS;
                boolean pp = container.ldp.hasPermit(PermAction.CREATE_COUNTY, region.getLayer(), region.id);
                if (!rn && !pp) {
                    resp.addRow("create.no_perm", LDUIRow.ELM_GENERIC, LDUIButton.BLANK);
                    return;
                }
                resp.addRow("create.name", LDUIRow.ELM_GENERIC);
                resp.addField("create.name_field");
                resp.addButton("create.submit", LDUIRow.ELM_BLUE, LDUIButton.OPEN);
                resp.setFormular();
                resp.setNoBack();
                return;
            }
        }
        this.external.sync_packet(container, resp);
    }

    @Override
    public void on_interact(BaseCon container, ModuleRequest req) {
        Manageable.Staff staff;
        LDPlayer player = container.ldp;
        boolean canman = this.manage.can(PermAction.MANAGE_MUNICIPALITY, container.ldp.uuid) || player.adm;
        switch (req.event()) {
            case "name": {
                if (!canman) {
                    return;
                }
                container.open(10, this.id, this.norms.index(this.norms.get("name")));
                return;
            }
            case "seat": {
                if (this.seat >= 0) {
                    container.open(LDKeys.COUNTY, 0, this.seat, 0);
                }
                return;
            }
            case "counties": {
                container.open(4);
                return;
            }
            case "staff": {
                container.open(1);
                return;
            }
            case "price": {
                container.open(7);
                return;
            }
            case "set_price": {
                if (canman) {
                    container.open(8);
                }
                return;
            }
            case "mailbox": {
                if (canman) {
                    container.open(LDKeys.MAILBOX, this.getLayer().ordinal(), this.id, 0);
                }
                return;
            }
            case "norms": {
                container.open(9);
                return;
            }
            case "appearance": {
                container.open(11);
                return;
            }
            case "county.goto": {
                int ct = req.getFieldInt("ct-id");
                if (!this.counties.contains(ct)) {
                    return;
                }
                container.open(LDKeys.COUNTY, 0, ct, 0);
                return;
            }
            case "county.setmain": {
                if (!canman) {
                    return;
                }
                int ct = req.getFieldInt("ct-id");
                if (!this.counties.contains(ct)) {
                    return;
                }
                County cty = ResManager.getCounty(ct, true);
                if (cty.region.id != this.id) {
                    return;
                }
                this.seat = cty.id;
                container.open(4);
                return;
            }
            case "county.remove": {
                if (!canman) {
                    return;
                }
                int ct = req.getFieldInt("ct-id");
                if (!this.counties.contains(ct)) {
                    return;
                }
                if (this.counties.size() < 2) {
                    container.msg("county.only_one");
                    return;
                }
                if (this.seat == ct) {
                    container.msg("county.setnew");
                    return;
                }
                County cty = ResManager.getCounty(ct, true);
                cty.region = ResManager.getRegion(-1, true);
                cty.save();
                this.save();
                Announcer.announce(Announcer.Target.MUNICIPALITY, this.id, "announce.region.county.removed", cty.name(), this.name(), this.id);
                container.open(4);
                return;
            }
            case "staff.add": {
                container.open(3);
                return;
            }
            case "staff.add.submit": {
                if (!canman) {
                    return;
                }
                LDPlayer ply = req.getPlayerField("staff.add.field");
                if (ply == null) {
                    container.msg("staff.add.notfound");
                    return;
                }
                if (!this.isCitizen(ply.uuid)) {
                    container.msg("staff.add.notmember");
                    return;
                }
                Mail mail = new Mail(MailType.INVITE, Layers.REGION, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                mail.setTitle(this.name()).setStaffInvite();
                mail.addMessage(TranslationUtil.translate("mail.region.staff.invite0", new Object[0]));
                mail.addMessage(TranslationUtil.translate("mail.region.staff.invite1", new Object[0]));
                ply.addMailAndSave(mail);
                player.entity.send(TranslationUtil.translate("gui.region.staff.add.success", new Object[0]));
                player.entity.closeUI();
                return;
            }
            case "staff.remove": {
                if (!canman) {
                    return;
                }
                Manageable.Staff staff2 = this.manage.getStaff(req.getUUIDField());
                if (staff2 != null && !this.manage.isManager(staff2)) {
                    this.manage.removeStaff(staff2.uuid);
                    LDPlayer ply = ResManager.getPlayer(staff2.uuid, true);
                    Mail mail = new Mail(MailType.SYSTEM, Layers.REGION, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.region.staff.nolonger", new Object[0]));
                    ply.addMailAndSave(mail);
                    for (Manageable.Staff stf : this.manage.staff) {
                        LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                        mail = new Mail(MailType.SYSTEM, Layers.REGION, this.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                        mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.region.staff.removed", staff2.getPlayerName()));
                        stp.addMailAndSave(mail);
                    }
                    Announcer.announce(Announcer.Target.REGION, this.id, "announce.region.staff.removed", staff2.getPlayerName(), this.name(), this.id);
                }
                container.open(1);
                return;
            }
            case "staff.setmanager": {
                if (!player.adm && !canman) {
                    return;
                }
                Manageable.Staff staff3 = this.manage.getStaff(req.getUUIDField());
                if (staff3 != null) {
                    this.manage.setManager(staff3.uuid);
                    LDPlayer ply = ResManager.getPlayer(staff3.uuid, true);
                    Mail mail = new Mail(MailType.SYSTEM, Layers.REGION, this.id, Layers.PLAYER, ply.uuid).expireInDays(7);
                    mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.region.manager_now", new Object[0]));
                    ply.addMailAndSave(mail);
                    this.save();
                    for (Manageable.Staff stf : this.manage.staff) {
                        LDPlayer stp = ResManager.getPlayer(stf.uuid, true);
                        mail = new Mail(MailType.SYSTEM, Layers.REGION, this.id, Layers.PLAYER, stp.uuid).expireInDays(7);
                        mail.setTitle(this.name()).addMessage(TranslationUtil.translate("mail.region.manager_set", staff3.getPlayerName()));
                        stp.addMailAndSave(mail);
                    }
                    Announcer.announce(Announcer.Target.REGION, this.id, "announce.region.manager_set", staff3.getPlayerName(), this.name(), this.id);
                }
                container.open(0);
                return;
            }
            case "create.submit": {
                Chunk_ chunk = ResManager.getChunk(container.ldp.entity);
                Region region = chunk.district.region();
                County ct = chunk.district.county();
                boolean pp = player.hasPermit(PermAction.CREATE_REGION, region.getLayer(), region.id);
                if (!player.adm) {
                    if (ct.region.id >= 0) {
                        container.msg("create.already_in_region");
                        return;
                    }
                    if (!player.isCountyManager()) {
                        container.msg("create.not_county_manager");
                        return;
                    }
                    if (ct.id != player.county.id) {
                        container.msg("create.not_in_county");
                        return;
                    }
                    if (!LDConfig.NEW_REGIONS && !pp) {
                        container.msg("create.new_regions_disabled");
                        container.msg("create.no_perm");
                        return;
                    }
                }
                if (ct.id < 0) {
                    container.msg("create.invalid_county");
                    return;
                }
                long sum = LDConfig.REGION_CREATION_FEE;
                String name = req.getField("create.name_field");
                if (!this.validateName(container, name)) {
                    return;
                }
                if (!player.adm && ct.account.getBalance() < sum) {
                    container.msg("create.not_enough_money");
                    return;
                }
                int newid = ResManager.getNewIdFor(this.saveTable());
                int ndid = -2;
                if (newid < 0) {
                    player.entity.send("DB ERROR, INVALID NEW ID '" + newid + "'!");
                    return;
                }
                if (!player.adm && !ct.account.getBank().processAction(Bank.Action.TRANSFER, (MessageSender)player.entity, ct.account, sum, ResManager.SERVER_ACCOUNT)) {
                    return;
                }
                Region reg = new Region(newid);
                reg.created.create(player.uuid);
                ResManager.RG_CENTERS.put(reg.id, chunk.key);
                reg.gendef();
                ResManager.REGIONS.put(reg.id, reg);
                reg.norms.get("name").set(name);
                reg.counties.add(ct.id);
                reg.seat = ct.id;
                ct.region = reg;
                UUID uuid = ct.manage.getManager();
                if (player.adm && uuid != null) {
                    reg.manage.add(uuid);
                    reg.manage.setManager(uuid);
                } else {
                    reg.manage.add(player);
                    reg.manage.setManager(player);
                }
                if (!player.adm) {
                    ResManager.SERVER_ACCOUNT.getBank().processAction(Bank.Action.TRANSFER, null, ResManager.SERVER_ACCOUNT, LDConfig.COUNTY_CREATION_FEE / 2L, reg.account);
                }
                ResManager.bulkSave(reg, ct, player);
                player.entity.closeUI();
                player.entity.send(TranslationUtil.translate("gui.region.create.complete", new Object[0]));
                Announcer.announce(Announcer.Target.GLOBAL, 0, "announce.region.created", name, newid);
                return;
            }
            case "norm_submit": {
                if (!canman) {
                    return;
                }
                NormModule.processNorm(this.norms, container, req, 10);
                return;
            }
            case "norm_bool": {
                if (!canman) {
                    return;
                }
                NormModule.processBool(this.norms, container, req, 10);
                return;
            }
            case "appearance.submit": {
                if (!canman) {
                    return;
                }
                if (AppearModule.req(container, req, this.icon, this.color)) {
                    container.open(0);
                }
                return;
            }
        }
        if (NormModule.isNormReq(this.norms, container, req, 10, this.id)) {
            return;
        }
        if (req.event().startsWith("staff.edit.")) {
            staff = this.manage.getStaff(UUID.fromString(req.event().substring("staff.edit.".length())));
            if (staff == null) {
                return;
            }
            container.open(2, this.id, this.manage.staff.indexOf(staff));
            return;
        }
        if (req.event().startsWith("staff.permission.")) {
            if (!canman) {
                return;
            }
            staff = this.manage.getStaff(req.getUUIDField());
            if (this.manage.isManager(staff)) {
                container.msg("staff.permissions.ismanager");
                return;
            }
            PermAction action = PermAction.get(req.event().substring("staff.permission.".length()).toUpperCase());
            if (action == null) {
                return;
            }
            staff.actions.put(action, staff.actions.get((Object)action) == false);
            container.open(2);
            return;
        }
        if (req.event().startsWith("county.edit.")) {
            int ct = Integer.parseInt(req.event().substring("county.edit.".length()));
            if (!this.counties.contains(ct)) {
                return;
            }
            container.open(5, this.id, this.counties.indexOf(ct));
            return;
        }
        this.external.on_interact(container, req);
    }

    public boolean isCitizen(UUID uuid) {
        for (int i = 0; i < this.counties.size(); ++i) {
            County ct = ResManager.getCounty(i, true);
            if (!ct.citizens.isCitizen(uuid)) continue;
            return true;
        }
        return false;
    }
}

