/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.landdev.data.ColorData;
import net.fexcraft.mod.landdev.data.IconHolder;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.district.District;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.ui.BaseUI;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.ui.LDUIButton;
import net.fexcraft.mod.landdev.ui.LDUIModule;
import net.fexcraft.mod.landdev.ui.LDUIRow;
import net.fexcraft.mod.landdev.ui.modules.MailModule;
import net.fexcraft.mod.landdev.ui.modules.MainModule;
import net.fexcraft.mod.landdev.ui.modules.ModuleRequest;
import net.fexcraft.mod.landdev.ui.modules.ModuleResponse;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class BaseCon
extends ContainerInterface {
    protected Chunk_ chunk;
    public LDPlayer ldp;
    protected UIKey type;
    protected String prefix;
    protected int backto;
    protected BaseUI bui;
    protected LinkedHashMap<String, String> sfields = new LinkedHashMap();
    protected HashMap<String, Boolean> checkboxes = new HashMap();
    protected ArrayList<String> radioboxes = new ArrayList();
    protected String radiobox;
    public boolean nosubmit;
    public boolean form;

    public BaseCon(JsonMap map, UniEntity ply, V3I pos) {
        super(map, ply, pos);
        if (!ply.entity.isOnClient()) {
            this.ldp = ResManager.getPlayer(ply);
            this.chunk = this.ldp.chunk_current;
        }
        this.type = LDKeys.MAIN;
        this.prefix = "main";
    }

    public ContainerInterface set(UserInterface ui) {
        this.bui = (BaseUI)ui;
        return super.set(ui);
    }

    public void packet(TagCW com, boolean client) {
        if (client) {
            if (com.has("msg")) {
                this.bui.msg(com.getString("msg"));
                return;
            }
            if (!com.has("elements")) {
                return;
            }
            this.process_client_packet(com);
            return;
        }
        if (com.has("sync")) {
            this.sendResp();
        }
        if (com.has("interact")) {
            ModuleRequest req = new ModuleRequest(com);
            switch (this.type.id) {
                case -1: {
                    MainModule.INST.on_interact(this, req);
                    break;
                }
                case 11: {
                    MailModule.INST.on_interact(this, req);
                    break;
                }
                case 8: {
                    this.ldp.on_interact(this, req);
                    break;
                }
                case 1: {
                    Chunk_ chunk = ResManager.getChunk(this.pos.y, this.pos.z);
                    chunk.on_interact(this, req);
                    break;
                }
                case 3: {
                    District dis = ResManager.getDistrict(this.pos.y);
                    if (dis == null) break;
                    dis.on_interact(this, req);
                    break;
                }
                case 4: {
                    if (this.pos.x < 0) {
                        ResManager.getMunicipality(-1, true).on_interact(this, req);
                        break;
                    }
                    Municipality mun = ResManager.getMunicipality(this.pos.y, this.pos.y > -2);
                    if (mun == null) break;
                    mun.on_interact(this, req);
                    break;
                }
                case 5: {
                    if (this.pos.x < 0) {
                        ResManager.getCounty(-1, true).on_interact(this, req);
                        break;
                    }
                    County ct = ResManager.getCounty(this.pos.y, this.pos.y > -1);
                    if (ct == null) break;
                    ct.on_interact(this, req);
                    break;
                }
                case 6: {
                    if (this.pos.x < 0) {
                        ResManager.getRegion(-1, true).on_interact(this, req);
                        break;
                    }
                    Region rg = ResManager.getRegion(this.pos.y, this.pos.y > -1);
                    if (rg == null) break;
                    rg.on_interact(this, req);
                    break;
                }
                default: {
                    LDUIModule.Missing.INST.on_interact(this, req);
                }
            }
        }
        if (com.has("go_back")) {
            if (this.pos.x != 0) {
                this.open(this.backto);
            } else {
                Chunk_ chunk = ResManager.getChunk(this.player.entity);
                this.open(LDKeys.MAIN, 0, chunk.key.x, chunk.key.z);
            }
        }
    }

    private void process_client_packet(TagCW com) {
        TagLW list = com.getList("elements");
        this.sfields.clear();
        this.bui.clear();
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            TagLW li = list.getList(i);
            if (li.getString(3).charAt(2) == '2') continue;
            ++size;
        }
        this.bui.addscroll = size > 12;
        ((UITab)this.bui.tabs.get("scroll")).visible(this.bui.addscroll);
        ((UIText)this.bui.texts.get("title")).value("landdev.gui." + com.getString("title_lang"));
        if (com.has("title")) {
            ((UIText)this.bui.texts.get("title")).translate(new Object[]{com.getString("title")});
        } else {
            ((UIText)this.bui.texts.get("title")).translate();
        }
        if (this.type != LDKeys.MAIN && !com.has("noback")) {
            this.backto = com.has("backto") ? com.getInteger("backto") : 0;
            ((UITab)this.bui.tabs.get("back")).visible(true);
        } else {
            ((UITab)this.bui.tabs.get("back")).visible(false);
        }
        BaseUI.texttips.clear();
        this.bui.elements.clear();
        for (int li = 0; li < list.size(); ++li) {
            String val;
            TagLW lis = list.getList(li);
            String index = lis.getString(0);
            LDUIRow elm = LDUIRow.valueOf(lis.getString(1));
            LDUIButton icon = LDUIButton.valueOf(lis.getString(2));
            String bools = lis.getString(3);
            String string = val = lis.size() > 4 ? lis.getString(4) : null;
            if (bools.charAt(2) == '2') {
                this.sfields.put(index, val);
            } else {
                this.bui.addElm(index, elm, icon, bools.charAt(0) == '1', bools.charAt(1) == '1', bools.charAt(2) == '1', val);
            }
            if (icon.isCheck()) {
                this.checkboxes.put(index, icon.check());
            }
            if (!icon.isRadio()) continue;
            this.radioboxes.add(index);
            if (!icon.radio()) continue;
            this.radiobox = index;
        }
        ((UITab)this.bui.tabs.get((Object)"bottom")).y = (this.bui.elements.size() > 12 ? 12 : this.bui.elements.size()) * 14 + 19;
        this.form = com.getBoolean("form");
        this.nosubmit = com.getBoolean("nosubmit");
        if (com.has("gui_icon") && this.bui.elements.size() > 6) {
            ((UIButton)this.bui.buttons.get((Object)"color")).ecolor.packed = com.getInteger("gui_color");
            String icon = com.getString("gui_icon");
            this.bui.imgres = icon.startsWith("server:") ? UniFCL.requestServerFile(null, (String)icon) : (icon.startsWith("http") || icon.contains("://") ? this.bui.drawer.loadExternal(icon) : IDLManager.getIDLCached((String)icon));
            ((UITab)this.bui.tabs.get("icon")).visible(true);
        } else {
            ((UITab)this.bui.tabs.get("icon")).visible(false);
        }
        this.bui.scroll(0);
    }

    public void sendResp() {
        ModuleResponse resp = new ModuleResponse();
        IconHolder holder = null;
        ColorData color = null;
        switch (this.type.id) {
            case -1: {
                MainModule.INST.sync_packet(this, resp);
                break;
            }
            case 11: {
                MailModule.INST.sync_packet(this, resp);
                break;
            }
            case 8: {
                this.ldp.sync_packet(this, resp);
                break;
            }
            case 1: {
                this.chunk.sync_packet(this, resp);
                break;
            }
            case 3: {
                District dis = ResManager.getDistrict(this.pos.y);
                if (dis == null) break;
                dis.sync_packet(this, resp);
                holder = dis.icon;
                color = dis.color;
                break;
            }
            case 4: {
                if (this.pos.x < 0) {
                    ResManager.getMunicipality(-1, true).sync_packet(this, resp);
                    holder = this.chunk.district.county().icon;
                    color = this.chunk.district.county().color;
                    break;
                }
                Municipality mun = ResManager.getMunicipality(this.pos.y, this.pos.y > -2);
                if (mun == null) break;
                mun.sync_packet(this, resp);
                holder = mun.icon;
                color = mun.color;
                break;
            }
            case 5: {
                if (this.pos.x < 0) {
                    ResManager.getCounty(-1, true).sync_packet(this, resp);
                    holder = this.chunk.district.county().icon;
                    color = this.chunk.district.county().color;
                    break;
                }
                County ct = ResManager.getCounty(this.pos.y, this.pos.y > -1);
                if (ct == null) break;
                ct.sync_packet(this, resp);
                holder = ct.icon;
                color = ct.color;
                break;
            }
            case 6: {
                if (this.pos.x < 0) {
                    ResManager.getRegion(-1, true).sync_packet(this, resp);
                    holder = this.chunk.district.region().icon;
                    color = this.chunk.district.region().color;
                    break;
                }
                Region rg = ResManager.getRegion(this.pos.y, this.pos.y > -1);
                if (rg == null) break;
                rg.sync_packet(this, resp);
                holder = rg.icon;
                color = rg.color;
                break;
            }
            default: {
                LDUIModule.Missing.INST.sync_packet(this, resp);
            }
        }
        if (holder != null) {
            resp.getCompound().set("gui_icon", holder.getnn());
            resp.getCompound().set("gui_color", color.getInteger());
        }
        SEND_TO_CLIENT.accept(resp.build(), this.player);
    }

    public void open(int x) {
        this.player.entity.openUI(this.type, x, this.pos.y, this.pos.z);
    }

    public void open(int x, int y, int z) {
        this.player.entity.openUI(this.type, x, y, z);
    }

    public void open(UIKey type, int x, int y, int z) {
        this.player.entity.openUI(type, x, y, z);
    }

    public void msg(String string, boolean addprefix) {
        TagCW com = TagCW.create();
        com.set("msg", (String)(addprefix ? "landdev.gui." + this.prefix + "." + string : string));
        SEND_TO_CLIENT.accept(com, this.player);
    }

    public void msg(String string) {
        this.msg(string, true);
    }

    public static class MailBaseCon
    extends BaseCon {
        public MailBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.MAIL;
            this.prefix = "mail";
        }
    }

    public static class PollBaseCon
    extends BaseCon {
        public PollBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.POLL;
            this.prefix = "poll";
        }
    }

    public static class PlayerBaseCon
    extends BaseCon {
        public PlayerBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.PLAYER;
            this.prefix = "player";
        }
    }

    public static class RegBaseCon
    extends BaseCon {
        public RegBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.REGION;
            this.prefix = "region";
        }
    }

    public static class CouBaseCon
    extends BaseCon {
        public CouBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.COUNTY;
            this.prefix = "county";
        }
    }

    public static class MunBaseCon
    extends BaseCon {
        public MunBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.MUNICIPALITY;
            this.prefix = "municipality";
        }
    }

    public static class DisBaseCon
    extends BaseCon {
        public DisBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.DISTRICT;
            this.prefix = "district";
        }
    }

    public static class ChunkBaseCon
    extends BaseCon {
        public ChunkBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.CHUNK;
            this.prefix = "chunk";
        }
    }

    public static class PropBaseCon
    extends BaseCon {
        public PropBaseCon(JsonMap map, UniEntity ply, V3I pos) {
            super(map, ply, pos);
            this.type = LDKeys.PROPERTY;
            this.prefix = "property";
        }
    }
}

