/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.ui;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.landdev.data.MailType;
import net.fexcraft.mod.landdev.ui.MailboxCon;
import net.fexcraft.mod.landdev.util.TranslationUtil;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class MailboxUI
extends UserInterface {
    protected MailboxCon mon;
    protected int page;

    public MailboxUI(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.mon = (MailboxCon)container;
    }

    public void init() {
        TagCW com = TagCW.create();
        com.set("sync", true);
        ContainerInterface.SEND_TO_SERVER.accept(com);
        this.page(0);
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.mon.mailbox == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            boolean bool = i + this.page * 10 < this.mon.mailbox.mails.size();
            ((UIButton)this.buttons.get("open_" + i)).visible(bool);
            ((UIButton)this.buttons.get("del_" + i)).visible(bool);
            ((UIText)this.texts.get("mail_" + i)).visible(bool);
            if (!bool) continue;
            ((UIText)this.texts.get("mail_" + i)).value(this.mon.mailbox.mails.get((int)i).title);
        }
    }

    public void drawbackground(float ticks, int mx, int my) {
        int j;
        if (this.mon.mailbox == null) {
            return;
        }
        for (int i = 0; i < 10 && (j = i + this.page * 10) < this.mon.mailbox.mails.size(); ++i) {
            MailType type = this.mon.mailbox.mails.get((int)j).type;
            if (type == MailType.INVITE && this.mon.mailbox.mails.get(j).expired()) {
                type = MailType.EXPIRED;
            }
            if (this.mon.mailbox.mails.get((int)j).unread) {
                this.drawer.draw((float)(this.gLeft + 6), (float)(this.gTop + 21 + i * 14), type.u_unread, type.v_unread, 16, 10);
                continue;
            }
            this.drawer.draw((float)(this.gLeft + 6), (float)(this.gTop + 21 + i * 14), type.u_read, type.v_read, 16, 10);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.startsWith("open")) {
            int idx = Integer.parseInt(id.substring(5));
            TagCW com = TagCW.create();
            com.set("read", idx + this.page * 10);
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        if (id.startsWith("del")) {
            int idx = Integer.parseInt(id.substring(4));
            TagCW com = TagCW.create();
            com.set("delete", idx + this.page * 10);
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        switch (id) {
            case "prev": {
                this.page(-1);
                return true;
            }
            case "next": {
                this.page(1);
                return true;
            }
        }
        return false;
    }

    private void page(int i) {
        this.page += i;
        if (this.page < 0) {
            this.page = 0;
        }
        ((UIText)this.texts.get("title")).value("landdev.gui.mailbox.title");
        ((UIText)this.texts.get("title")).translate(new Object[]{this.page + 1});
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.page(am > 0 ? 1 : -1);
        return true;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        if (this.mon.mailbox == null) {
            return;
        }
        if (((UIButton)this.buttons.get("prev")).hovered()) {
            list.add(TranslationUtil.translate("gui.mailbox.prev", new Object[0]));
        }
        if (((UIButton)this.buttons.get("next")).hovered()) {
            list.add(TranslationUtil.translate("gui.mailbox.next", new Object[0]));
        }
        for (int i = 0; i < 10 && i + this.page * 10 < this.mon.mailbox.mails.size(); ++i) {
            if (((UIButton)this.buttons.get("open_" + i)).hovered()) {
                list.add(TranslationUtil.translate("gui.mailbox.read", new Object[0]));
            }
            if (((UIButton)this.buttons.get("del_" + i)).hovered()) {
                list.add(TranslationUtil.translate("gui.mailbox.delete", new Object[0]));
            }
            if (!((UIText)this.texts.get("mail_1")).hovered()) continue;
            list.add(((UIText)this.texts.get("mail_" + i)).value());
        }
    }
}

