/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.landdev.util.LDConfig;

public class AliasLoader {
    public static final HashMap<String, ArrayList<String>> ALIASES = new HashMap();
    public static final HashMap<String, String> OVERRIDES = new HashMap();
    private static final ArrayList<String> NONE = new ArrayList();

    public static void load() {
        JsonMap map;
        File file = new File(LDConfig.CONFIG_PATH, "landdev-cmds.json");
        if (!file.exists()) {
            AliasLoader.generate(file);
        }
        if ((map = JsonHandler.parse((File)file)).has("aliases")) {
            map.getMap("aliases").entries().forEach(entry -> {
                ArrayList list = new ArrayList();
                ((JsonValue)entry.getValue()).asArray().elements().forEach(elm -> list.add(elm.string_value()));
                ALIASES.put((String)entry.getKey(), list);
            });
        }
        if (map.has("override")) {
            map.getMap("override").entries().forEach(entry -> OVERRIDES.put((String)entry.getKey(), ((JsonValue)entry.getValue()).string_value()));
        }
    }

    private static void generate(File file) {
        JsonMap map = new JsonMap();
        map.add("__comment", "In this file you can define custom aliases for LandDev's Commands.");
        JsonMap als = new JsonMap();
        als.add("ld-admin", (JsonValue)new JsonArray());
        als.add("ld-debug", (JsonValue)new JsonArray());
        als.add("ld-self", (JsonValue)new JsonArray());
        JsonArray ldgui = new JsonArray();
        ldgui.add("land-developer");
        ldgui.add("/landdev");
        ldgui.add("ld");
        als.add("landdev", (JsonValue)ldgui);
        als.add("mail", (JsonValue)new JsonArray());
        als.add("ck", (JsonValue)new JsonArray());
        als.add("dis", (JsonValue)new JsonArray());
        als.add("mun", (JsonValue)new JsonArray());
        als.add("ct", (JsonValue)new JsonArray());
        als.add("reg", (JsonValue)new JsonArray());
        map.add("aliases", (JsonValue)als);
        map.add("___comment", "Bellow you can even override the default command prefix (with example included).");
        JsonMap ovr = new JsonMap();
        ovr.add("some-cmd-prefix", "new-cmd-prefix");
        ovr.add("ld-example", "ld-override");
        map.add("override", (JsonValue)ovr);
        JsonHandler.print((File)file, (JsonValue)map, (JsonHandler.PrintOption)JsonHandler.PrintOption.SPACED);
    }

    public static String getOverride(String string) {
        return OVERRIDES.containsKey(string) ? OVERRIDES.get(string) : string;
    }

    public static ArrayList<String> getAlias(String string) {
        return ALIASES.containsKey(string) ? ALIASES.get(string) : NONE;
    }
}

