/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.util;

import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.UUID;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.Static;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.data.IconHolder;
import net.fexcraft.mod.landdev.data.district.DistrictType;
import net.fexcraft.mod.landdev.util.TranslationUtil;
import net.fexcraft.mod.landdev.util.broad.Broadcaster;
import net.fexcraft.mod.uni.ConfigBase;
import net.fexcraft.mod.uni.EnvInfo;

public class LDConfig
extends ConfigBase {
    public static String SERVER_ICON = "http://fexcraft.net/files/mod_data/landdev/default_server_icon.png";
    public static String DEFAULT_ICON = "http://fexcraft.net/files/mod_data/landdev/default_icon.png";
    public static final String BROADCASTER = "http://fexcraft.net/files/mod_data/landdev/broadcaster_icon.png";
    public static IconHolder SERVER_ICONHOLDER = new IconHolder(SERVER_ICON);
    public static boolean SAVE_SPACED_JSON;
    public static boolean PROTECT_WILDERNESS;
    public static boolean EDIT_WILDERNESS;
    public static boolean NEW_REGIONS;
    public static boolean LOCUP_SIDE;
    public static boolean RUN_LOCATION_EVENT;
    public static long DEFAULT_CHUNK_PRICE;
    public static long REGION_CREATION_FEE;
    public static long COUNTY_CREATION_FEE;
    public static long MUNICIPALITY_CREATION_FEE;
    public static long DISTRICT_CREATION_FEE;
    public static int CHUNK_LINK_LIMIT;
    public static int REQUEST_TIMEOUT_DAYS;
    public static int MIN_MUN_DIS;
    public static boolean TAX_ENABLED;
    public static boolean TAX_OFFLINE;
    public static long TAX_INTERVAL;
    public static boolean CHAT_OVERRIDE;
    public static boolean DISCORD_BOT_ACTIVE;
    public static String CHAT_PLAYER_COLOR;
    public static String CHAT_ADMIN_COLOR;
    public static String CHAT_DISCORD_COLOR;
    public static String CHAT_OVERRIDE_LANG;
    public static int DISCORD_BOT_PORT;
    public static String DISCORD_BOT_ADRESS;
    public static String DISCORD_BOT_TOKEN;
    public static String SERVLANG_STARTED;
    public static String SERVLANG_STOPPING;
    public static String SERVLANG_JOINED;
    public static String SERVLANG_LEFT;
    public static final String GENERAL_CAT = "general";
    public static final String DISCORD_CAT = "discord";
    public static final String CLIENT_CAT = "client";
    public static final String TAX_CAT = "tax";
    public static final String CHAT_CAT = "chat";
    public static final String PRICES_CAT = "prices";
    public static final String SERVLANG = "server_lang";
    public static File CONFIG_PATH;
    private static final DecimalFormat df;

    public LDConfig(File fl) {
        super(fl, "Land Developer");
        CONFIG_PATH = this.file.getParentFile();
        DistrictType.loadConfig(CONFIG_PATH);
    }

    protected void fillInfo(JsonMap map) {
        map.add("info", "Land-Developer Main Configuration File");
        map.add("wiki", "https://fexcraft.net/wiki/mod/landdev");
    }

    protected void fillEntries() {
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "server_icon", SERVER_ICON).info("Server Icon to be shown in the Location Update GUI.").cons((con, map) -> {
            SERVER_ICON = con.getString(map);
            SERVER_ICONHOLDER.set(SERVER_ICON);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "default_icon", DEFAULT_ICON).info("Default Dis/Mun/Cou/Region Icon to be shown in the Location Update GUI.").cons((con, map) -> {
            SERVER_ICON = con.getString(map);
            SERVER_ICONHOLDER.set(SERVER_ICON);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "save_spaced_json", false).info("If true, the JSON will be formatted to be easily readable, otherwise if false it will not have any spacing, to save on disk and load time.").cons((con, map) -> {
            SAVE_SPACED_JSON = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "protect_wilderness", true).info("If wilderness protection should be enabled.").cons((con, map) -> {
            PROTECT_WILDERNESS = con.getBoolean(map);
            EDIT_WILDERNESS = !PROTECT_WILDERNESS;
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "chunk_link_limit", 3).rang(0.0f, 64.0f).info("How many chunks can be linked to another. Set to '0' to disable.").cons((con, map) -> {
            CHUNK_LINK_LIMIT = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "request_timeout_days", 7).rang(1.0f, 30.0f).info("Default days value for request timeouts.").cons((con, map) -> {
            REQUEST_TIMEOUT_DAYS = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "run_location_event", false).info("Should the 'PlayerLocationEvent' be run every time the player enters another district/named-chunk? Use this if you have an LD Addon requiring it.").cons((con, map) -> {
            RUN_LOCATION_EVENT = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "min_municipality_distance", 16).rang(4.0f, 40960.0f).info("Minimum chunk distance between Municipality centers.").cons((con, map) -> {
            MIN_MUN_DIS = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, GENERAL_CAT, "allow_new_regions", true).info("If new LD Region Layers can be created (/rg create).").cons((con, map) -> {
            NEW_REGIONS = con.getBoolean(map);
        }).req(false, false));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, PRICES_CAT, "default.chunk", "100000").info("Default price for unclaimed chunks. (1000 = 1$)").cons((con, map) -> {
            DEFAULT_CHUNK_PRICE = this.parse(con.getString(map), 100000L);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, PRICES_CAT, "create.district", "5000000").info("Server fee for creating a district.").cons((con, map) -> {
            DISTRICT_CREATION_FEE = this.parse(con.getString(map), 5000000L);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, PRICES_CAT, "create.municipality", "25000000").info("Server fee for creating a municipality, half of it goes to the new Municipality.").cons((con, map) -> {
            MUNICIPALITY_CREATION_FEE = this.parse(con.getString(map), 25000000L);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, PRICES_CAT, "create.county", "50000000").info("Server fee for creating a county, half of it goes to the new County.").cons((con, map) -> {
            COUNTY_CREATION_FEE = this.parse(con.getString(map), 50000000L);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, PRICES_CAT, "create.region", "100000000").info("Server fee for creating a region, half of it goes to the new Region.").cons((con, map) -> {
            REGION_CREATION_FEE = this.parse(con.getString(map), 100000000L);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, TAX_CAT, "enabled", true).info("If the Tax System should be enabled.").cons((con, map) -> {
            TAX_ENABLED = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, TAX_CAT, "interval", 24).rang(1.0f, 168.0f).info("Interval between tax collection cycles, in hours.").cons((con, map) -> {
            TAX_INTERVAL = (long)con.getInteger(map) * 3600000L;
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, TAX_CAT, "inactive_players", false).info("If inactive (since more than one interval) players should be taxed as well.").cons((con, map) -> {
            TAX_OFFLINE = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, CHAT_CAT, "override", true).info("If the vanilla chat should be overridden by the LandDev chat.").cons((con, map) -> {
            CHAT_OVERRIDE = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, CHAT_CAT, "color_player", CHAT_PLAYER_COLOR).info("Default color of the player role marker (default `#`) in chat.").cons((con, map) -> {
            CHAT_PLAYER_COLOR = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, CHAT_CAT, "color_admin", CHAT_ADMIN_COLOR).info("Default color of the admin role marker (default `#`) in chat.").cons((con, map) -> {
            CHAT_ADMIN_COLOR = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, CHAT_CAT, "color_discord", CHAT_DISCORD_COLOR).info("Default color of the discord role marker (default `#`) in chat.").cons((con, map) -> {
            CHAT_DISCORD_COLOR = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, DISCORD_CAT, "active", false).info("If the discord chat integration should be active.").cons((con, map) -> {
            DISCORD_BOT_ACTIVE = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, DISCORD_CAT, "adress", DISCORD_BOT_ADRESS).info("Adress/IP of the Discord Chat Bot you are using. By default this points to the one provided by Fexcraft.").cons((con, map) -> {
            DISCORD_BOT_ADRESS = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, DISCORD_CAT, "port", DISCORD_BOT_PORT).rang(1000.0f, 65535.0f).info("Port on which the Discord Chat Bot is listening.").cons((con, map) -> {
            DISCORD_BOT_PORT = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, DISCORD_CAT, "token", DISCORD_BOT_TOKEN).info("Token to use to communicate with the Discord Chat Bot.").cons((con, map) -> {
            DISCORD_BOT_TOKEN = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, CLIENT_CAT, "location_update_on_left", true).info("Set to false if the Location Update GUI should be on the right side.").cons((con, map) -> {
            LOCUP_SIDE = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, CLIENT_CAT, "chat_format", "%s#&0] %s&0: &f%s").info("Format of chat messages if chat override is enabled.").cons((con, map) -> {
            CHAT_OVERRIDE_LANG = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, SERVLANG, "started", SERVLANG_STARTED).info("Message to be send to discord when the server started.").cons((con, map) -> {
            SERVLANG_STARTED = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, SERVLANG, "stopping", SERVLANG_STOPPING).info("Message to be send to discord when the server is stopping.").cons((con, map) -> {
            SERVLANG_STOPPING = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, SERVLANG, "player_joined", SERVLANG_JOINED).info("Message to be send to discord when a player joins.").cons((con, map) -> {
            SERVLANG_JOINED = con.getString(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, SERVLANG, "player_left", SERVLANG_LEFT).info("Message to be send to discord when a player left.").cons((con, map) -> {
            SERVLANG_LEFT = con.getString(map);
        }));
    }

    private long parse(String string, long def) {
        try {
            long l = Long.parseLong(string);
            return l < 0L ? 0L : l;
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    protected void onReload(JsonMap map) {
        if (!EnvInfo.CLIENT) {
            Broadcaster.SENDERS.values().removeIf(s -> !s.type().internal());
        }
    }

    public static long format_price(String[] err, String val) {
        try {
            String str = val.replace(Config.DOT, "").replace(",", ".");
            if (str.length() == 0) {
                return 0L;
            }
            String format = df.format(Double.parseDouble(str));
            return Long.parseLong(format.replace(",", "").replace(".", ""));
        }
        catch (Exception e) {
            err[0] = TranslationUtil.translateCmd("invalid_price", new Object[0]) + " " + e.getMessage();
            if (Static.dev()) {
                e.printStackTrace();
            }
            return 0L;
        }
    }

    static {
        CHAT_PLAYER_COLOR = "&6";
        CHAT_ADMIN_COLOR = "&4";
        CHAT_DISCORD_COLOR = "&9";
        DISCORD_BOT_PORT = 10810;
        DISCORD_BOT_ADRESS = "fexcraft.net";
        DISCORD_BOT_TOKEN = UUID.randomUUID().toString().replace("-", "").substring(0, 8);
        SERVLANG_STARTED = "Server has started. Running LandDeveloper v%s";
        SERVLANG_STOPPING = "Server is closing.";
        SERVLANG_JOINED = "%s joined the server.";
        SERVLANG_LEFT = "%s left the server.";
        df = new DecimalFormat("#.000", new DecimalFormatSymbols(Locale.US));
        df.setRoundingMode(RoundingMode.DOWN);
    }
}

