/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.Supplier;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.util.ClientPacketPlayer;
import net.fexcraft.mod.fcl.util.UIPacket;
import net.fexcraft.mod.fsmm.local.FsmmCmd;
import net.fexcraft.mod.fsmm.util.Config;
import net.fexcraft.mod.landdev.LDN;
import net.fexcraft.mod.landdev.data.PermAction;
import net.fexcraft.mod.landdev.data.chunk.Chunk_;
import net.fexcraft.mod.landdev.data.county.County;
import net.fexcraft.mod.landdev.data.municipality.Municipality;
import net.fexcraft.mod.landdev.data.player.LDPlayer;
import net.fexcraft.mod.landdev.data.region.Region;
import net.fexcraft.mod.landdev.events.LocationUpdate;
import net.fexcraft.mod.landdev.ui.LDKeys;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.landdev.util.PolyClaim;
import net.fexcraft.mod.landdev.util.Protector;
import net.fexcraft.mod.landdev.util.ResManager;
import net.fexcraft.mod.landdev.util.TaxSystem;
import net.fexcraft.mod.landdev.util.broad.DiscordTransmitter;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="landdev")
public class LandDev {
    public static final String MODID = "landdev";
    public static final String VERSION = "1.5.0";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static File SAVE_DIR = new File("./landdev/");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("landdev", "channel")).clientAcceptedVersions(pro -> true).serverAcceptedVersions(pro -> true).networkProtocolVersion(() -> "1.5.0").simpleChannel();

    public LandDev() {
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LDN.preinit(FMLPaths.CONFIGDIR.get().toFile());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LDN.init(this);
        LDN.postinit();
        CHANNEL.registerMessage(1, UIPacket.class, (packet, buffer) -> buffer.m_130079_(packet.com()), buffer -> new UIPacket(buffer.m_130260_()), (packet, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> LandDev.lambda$commonSetup$5((Supplier)context, packet));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    private static void onServerPacket(ServerPlayer player, CompoundTag com) {
    }

    public static void log(Object s) {
        LOGGER.info(String.valueOf(s));
    }

    public static void debug(String s) {
        if (EnvInfo.DEV) {
            LOGGER.info(s);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LDN.onServerStarting();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        LDN.onServerStarted();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LDN.onServerStopping();
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        LDN.onServerStop();
    }

    @SubscribeEvent
    public void onCmdReg(RegisterCommandsEvent event) {
        this.regCmd((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void sendLocationPacket(EntityW entity, TagCW com) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((EntityW)entity).local()), (Object)new UIPacket((CompoundTag)com.local()));
    }

    public static void sendToAll(TagCW com) {
        try {
            CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UIPacket((CompoundTag)com.local()));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void regCmd(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ld").then(Commands.m_82127_((String)"admin").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (((CommandSourceStack)cmd.getSource()).m_81377_().m_129792_() || FsmmCmd.isOp((CommandSourceStack)((CommandSourceStack)cmd.getSource()))) {
                player.adm = !player.adm;
                player.entity.send("landdev.cmd.adminmode." + player.adm);
            } else {
                player.entity.send("\u00a7cno.permission");
            }
            return 0;
        }))).then(Commands.m_82127_((String)"uuid").executes(cmd -> {
            ((CommandSourceStack)cmd.getSource()).m_243053_((Component)Component.m_237113_((String)((CommandSourceStack)cmd.getSource()).m_81375_().m_36316_().getId().toString()));
            return 0;
        }))).then(Commands.m_82127_((String)"reload").executes(cmd -> {
            Protector.load();
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            ((CommandSourceStack)cmd.getSource()).m_243053_((Component)Component.m_237110_((String)"landdev.cmd.reload", (Object[])new Object[]{"landdev-interaction.json"}));
            DiscordTransmitter.restart();
            ((CommandSourceStack)cmd.getSource()).m_243053_((Component)Component.m_237110_((String)"landdev.cmd.reload", (Object[])new Object[]{"discord-bot-integration"}));
            ((CommandSourceStack)cmd.getSource()).m_243053_((Component)Component.m_237115_((String)"landdev.cmd.reload.complete"));
            return 0;
        }))).then(Commands.m_82127_((String)"force-tax").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (!player.adm) {
                return -1;
            }
            TaxSystem.INSTANCE.collect(Time.getDate(), true);
            return 0;
        }))).then(Commands.m_82127_((String)"fees").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.send("landdev.cmd.fees");
            long sf = LDConfig.MUNICIPALITY_CREATION_FEE;
            long cf = chunk.district.county().norms.get("new-municipality-fee").integer();
            player.entity.send("landdev.cmd.fees_municipality");
            player.entity.send("landdev.cmd.fees_mun_server", new Object[]{Config.getWorthAsString((long)sf)});
            player.entity.send("landdev.cmd.fees_mun_county", new Object[]{Config.getWorthAsString((long)cf)});
            player.entity.send("landdev.cmd.fees_mun_total", new Object[]{Config.getWorthAsString((long)(sf + cf))});
            sf = LDConfig.COUNTY_CREATION_FEE;
            cf = chunk.district.region().norms.get("new-county-fee").integer();
            player.entity.send("landdev.cmd.fees_county");
            player.entity.send("landdev.cmd.fees_ct_server", new Object[]{Config.getWorthAsString((long)sf)});
            player.entity.send("landdev.cmd.fees_ct_region", new Object[]{Config.getWorthAsString((long)cf)});
            player.entity.send("landdev.cmd.fees_ct_total", new Object[]{Config.getWorthAsString((long)(sf + cf))});
            sf = LDConfig.REGION_CREATION_FEE;
            player.entity.send("landdev.cmd.fees_region");
            player.entity.send("landdev.cmd.fees_rg_server", new Object[]{Config.getWorthAsString((long)sf)});
            player.entity.send("landdev.cmd.fees_rg_total", new Object[]{Config.getWorthAsString((long)sf)});
            return 0;
        }))).then(Commands.m_82127_((String)"help").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            player.entity.send("\u00a70[\u00a7bLD\u00a70]\u00a76>>\u00a72===========");
            player.entity.send("/ld (UI)");
            player.entity.send("/ld help");
            player.entity.send("/ld admin");
            player.entity.send("/ld fees");
            player.entity.send("/ld reload");
            player.entity.send("/ld force-tax");
            player.entity.send("PolyClaim (Admin)");
            player.entity.send("/ld polyclaim district <dis-id>");
            player.entity.send("/ld polyclaim select");
            player.entity.send("/ld polyclaim status");
            player.entity.send("/ld polyclaim clear");
            player.entity.send("/ld polyclaim start");
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"polyclaim").then(Commands.m_82127_((String)"district").then(Commands.m_82129_((String)"district", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (!player.adm) {
                return 0;
            }
            int did = IntegerArgumentType.getInteger((CommandContext)cmd, (String)"district");
            PolyClaim.setDis(player, did);
            return 0;
        })))).then(Commands.m_82127_((String)"select").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.selCnk(player, ResManager.getChunk(player.entity.getPos()));
            return 0;
        }))).then(Commands.m_82127_((String)"start").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.process(player);
            return 0;
        }))).then(Commands.m_82127_((String)"status").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.status(player);
            return 0;
        }))).then(Commands.m_82127_((String)"clear").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            if (!player.adm) {
                return 0;
            }
            PolyClaim.clear(player);
            return 0;
        })))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
                player.entity.openUI(LDKeys.MAIN, new V3I(0, (int)player.entity.getPos().x >> 4, (int)player.entity.getPos().z >> 4));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ck").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").then(Commands.m_82129_((String)"district", (ArgumentType)IntegerArgumentType.integer((int)-2)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, ((Integer)cmd.getArgument("district", Integer.class)).intValue(), chunk.key.z));
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, chunk.district.id, chunk.key.z));
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"district", (ArgumentType)IntegerArgumentType.integer((int)-2)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_TRANSFER, new V3I(chunk.key.x, ((Integer)cmd.getArgument("district", Integer.class)).intValue(), chunk.key.z));
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, chunk.district.id, chunk.key.z));
            return 0;
        }))).then(Commands.m_82127_((String)"sell").then(Commands.m_82129_((String)"price", (ArgumentType)IntegerArgumentType.integer((int)-2)).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_CLAIM, new V3I(chunk.key.x, ((Integer)cmd.getArgument("price", Integer.class)).intValue(), chunk.key.z));
            return 0;
        })))).then(Commands.m_82127_((String)"buy").then(Commands.m_82129_((String)"for", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            String arg = (String)cmd.getArgument("for", String.class);
            int dis = chunk.district.id;
            switch (arg) {
                case "self": 
                case "player": {
                    dis = -1;
                    break;
                }
                case "company": 
                case "com": {
                    dis = -2;
                    break;
                }
                case "region": 
                case "reg": {
                    dis = -3;
                    break;
                }
                case "here": {
                    dis = chunk.district.id;
                }
            }
            if (arg.startsWith("municipality:")) {
                dis = Integer.parseInt(arg.replace("municipality:", ""));
            }
            if (arg.startsWith("county:")) {
                dis = Integer.parseInt(arg.replace("county:", ""));
            }
            player.entity.openUI(LDKeys.CHUNK_TRANSFER, new V3I(chunk.key.x, dis, chunk.key.z));
            return 0;
        })))).then(Commands.m_82127_((String)"lock").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.CHUNK_LOCK, new V3I(chunk.key.x, 0, chunk.key.z));
            return 0;
        }))).then(Commands.m_82127_((String)"map").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            String marker = null;
            Chunk_ ck = null;
            int r = 9;
            int rm = 4;
            for (int i = 0; i < r; ++i) {
                Object str = "\u00a70|";
                for (int j = 0; j < r; ++j) {
                    int x = chunk.key.x - rm + j;
                    int z = chunk.key.z - rm + i;
                    marker = x == chunk.key.x && z == chunk.key.z ? "+" : "#";
                    ck = ResManager.getChunk(x, z);
                    str = (String)str + (ck == null ? "\u00a74" : (ck.district.id >= 0 ? "\u00a79" : "\u00a72")) + marker;
                }
                player.entity.send((String)str + "\u00a70|");
            }
            player.entity.send("landdev.cmd.chunk.mapdesc");
            return 0;
        }))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
                Chunk_ chunk = ResManager.getChunk(player.entity);
                player.entity.openUI(LDKeys.CHUNK, new V3I(0, chunk.key.x, chunk.key.z));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dis").then(Commands.m_82127_((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            player.entity.openUI(LDKeys.DISTRICT, -1, 0, 0);
            return 0;
        }))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
                Chunk_ chunk = ResManager.getChunk(player.entity);
                player.entity.openUI(LDKeys.DISTRICT, new V3I(0, chunk.district.id, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mun").then(Commands.m_82127_((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            County county = chunk.district.county();
            boolean cn = county.norms.get("new-municipalities").bool();
            boolean pp = player.hasPermit(PermAction.CREATE_MUNICIPALITY, county.getLayer(), county.id);
            if (!cn && !pp) {
                player.entity.send("landdev.cmd.mun.no_new_municipalities");
                player.entity.send("landdev.cmd.mun.no_create_permit");
            } else {
                player.entity.openUI(LDKeys.MUNICIPALITY, -1, 0, 0);
            }
            return 0;
        }))).then(Commands.m_82127_((String)"center").executes(cmd -> {
            Pair<Integer, Double> dis;
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            if (chunk.district.municipality() == null) {
                player.entity.send("landdev.cmd.mun.not_in_a_municipality");
                return 0;
            }
            Municipality mun = chunk.district.municipality();
            if (!mun.manage.can(PermAction.MANAGE_MUNICIPALITY, player.uuid) && !player.adm) {
                player.entity.send("no perm");
                return 0;
            }
            int min = Math.max(LDConfig.MIN_MUN_DIS, mun.county.norms.get("min-municipality-distance").integer());
            if (min < LDConfig.MIN_MUN_DIS) {
                min = LDConfig.MIN_MUN_DIS;
            }
            if ((Integer)(dis = ResManager.disToNearestMun(chunk.key, mun.id)).getLeft() >= 0 && (Double)dis.getRight() < (double)min) {
                player.entity.send("landdev.cmd.mun.center_too_close", new Object[]{ResManager.getMunicipality((Integer)dis.getLeft(), true).name(), dis.getLeft()});
            } else {
                ResManager.MUN_CENTERS.put((Integer)dis.getLeft(), chunk.key);
                player.entity.openUI(LDKeys.MUNICIPALITY, 0, mun.id, 0);
            }
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            if (chunk.district.municipality() == null) {
                player.entity.send("landdev.cmd.mun.not_in_a_municipality");
                return 0;
            }
            player.entity.openUI(LDKeys.MUNICIPALITY, new V3I(0, chunk.district.municipality().id, 0));
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ct").then(Commands.m_82127_((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            Region region = chunk.district.region();
            boolean cn = region.norms.get("new-counties").bool();
            boolean pp = player.hasPermit(PermAction.CREATE_COUNTY, region.getLayer(), region.id);
            if (!cn && !pp) {
                player.entity.send("landdev.cmd.ct.no_new_county");
                player.entity.send("landdev.cmd.ct.no_create_permit");
            } else {
                player.entity.openUI(LDKeys.COUNTY, -1, 0, 0);
            }
            return 0;
        }))).executes(cmd -> {
            try {
                LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
                Chunk_ chunk = ResManager.getChunk(player.entity);
                player.entity.openUI(LDKeys.COUNTY, new V3I(0, chunk.district.county().id, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reg").then(Commands.m_82127_((String)"create").executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            if (!LDConfig.NEW_REGIONS && !player.adm) {
                player.entity.send("landdev.cmd.rg.no_new_region");
                player.entity.send("landdev.cmd.rg.no_create_permit");
            } else {
                player.entity.openUI(LDKeys.REGION, -1, 0, 0);
            }
            return 0;
        }))).executes(cmd -> {
            LDPlayer player = ResManager.getPlayer(((CommandSourceStack)cmd.getSource()).m_230896_());
            Chunk_ chunk = ResManager.getChunk(player.entity);
            player.entity.openUI(LDKeys.REGION, new V3I(0, chunk.district.region().id, 0));
            return 0;
        }));
    }

    private static /* synthetic */ void lambda$commonSetup$5(Supplier context, UIPacket packet) {
        if (((NetworkEvent.Context)context.get()).getDirection().getOriginationSide().isClient()) {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            LandDev.onServerPacket(player, packet.com());
        } else {
            ClientModEvents.onClientPacket(ClientPacketPlayer.get(), packet.com());
        }
    }

    @Mod.EventBusSubscriber(modid="landdev", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        private static void onClientPacket(Player player, CompoundTag com) {
            switch (com.m_128461_("task")) {
                case "location_update": {
                    int time = com.m_128441_("time") ? com.m_128451_("time") : 10;
                    LocationUpdate.clear(Time.getDate() + (long)(time * 1000));
                    LocationUpdate.loadIcons((ListTag)com.m_128423_("icons"));
                    LocationUpdate.loadLines((ListTag)com.m_128423_("lines"));
                    return;
                }
                case "chat_message": {
                    ListTag list = (ListTag)com.m_128423_("msg");
                    String c = list.size() > 3 ? list.m_128778_(3) : "\u00a7a";
                    MutableComponent text = null;
                    switch (list.m_128778_(0)) {
                        case "chat_img": {
                            text = Component.m_237113_((String)list.m_128778_(2));
                            break;
                        }
                        default: {
                            text = Component.m_237113_((String)ContainerInterface.transformat((String)LDConfig.CHAT_OVERRIDE_LANG, (Object[])new Object[]{c, list.m_128778_(1), list.m_128778_(2)}));
                        }
                    }
                    Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)text);
                    return;
                }
            }
        }
    }
}

