/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

import java.awt.Color;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.uni.world.MessageSender;

public class ColorData
implements Saveable {
    private int color = 0xFFFFFF;

    public ColorData() {
    }

    public ColorData(int value) {
        this.color = value;
    }

    public int getInteger() {
        return this.color;
    }

    public String getString() {
        return "#" + Integer.toHexString(this.color);
    }

    public ColorData set(int color) {
        this.color = color;
        return this;
    }

    public void set(String str) {
        this.color = Integer.parseInt(str.replace("#", ""), 16);
    }

    @Override
    public void load(JsonMap map) {
        if (map.has("color")) {
            this.set(map.get("color").string_value());
        } else {
            this.color = 0xFFFFFF;
        }
    }

    @Override
    public void save(JsonMap map) {
        if (this.color < 0xFFFFFF && this.color > 0) {
            map.add("color", "#" + Integer.toHexString(this.color));
        }
    }

    public static boolean validString(MessageSender sender, String newcolor) {
        block5: {
            if (((String)newcolor).replace("#", "").length() != 6) {
                if (sender != null) {
                    sender.send("Invalid colour string!");
                }
                return false;
            }
            if (!((String)newcolor).contains("#")) {
                newcolor = "#" + (String)newcolor;
            }
            try {
                Color.decode((String)newcolor);
            }
            catch (Exception e) {
                if (sender == null) break block5;
                sender.send("Parse Error: " + e.getMessage());
            }
        }
        return true;
    }

    public String toString() {
        return this.getString();
    }
}

