/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.landdev.data;

import java.util.Arrays;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.landdev.data.Saveable;
import net.fexcraft.mod.landdev.util.LDConfig;
import net.fexcraft.mod.uni.tag.TagCW;

public class IconHolder
implements Saveable {
    private String icon;
    public static final List<String> PACKET_COLOURS = Arrays.asList("green", "yellow", "red", "blue");

    public IconHolder() {
    }

    public IconHolder(String string) {
        this.icon = string;
    }

    @Override
    public void load(JsonMap obj) {
        this.icon = obj.has("icon") ? obj.get("icon").string_value() : LDConfig.DEFAULT_ICON;
    }

    @Override
    public void save(JsonMap map) {
        if (this.icon != null && !this.icon.equals(LDConfig.DEFAULT_ICON)) {
            map.add("icon", this.icon);
        }
    }

    public String get() {
        return this.icon;
    }

    public String getn() {
        return this.exists() ? this.icon : "none";
    }

    public String getnn() {
        return this.exists() ? this.icon : LDConfig.DEFAULT_ICON;
    }

    public void set(String url) {
        this.icon = url;
    }

    public boolean exists() {
        return this.icon != null && this.icon.length() > 4;
    }

    public void reset() {
        this.icon = null;
    }

    public static final void writeLocPacketIcon(TagCW compound, IconHolder icon, int id, String color) {
        if (icon != null) {
            compound.set("icon_" + id, icon.getnn());
        } else if (color == null) {
            compound.set("x_" + id, 64);
            compound.set("y_" + id, 224);
        } else {
            compound.set("color_" + id, color);
        }
    }
}

